# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding unit tests
#
# Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

from test_drawable import _TestDrawable
import pgm
import gst

class TestImage(_TestDrawable):

    def setUp(self):
        self.drawable = pgm.Image()
        _TestDrawable.setUp(self)

    def test_interp(self):

        # get
        interp = self.drawable.get_interp()
        self.assertEqual(interp, pgm.ImageInterpType(pgm.IMAGE_BILINEAR))

        # set
        new_interp = pgm.ImageInterpType(pgm.IMAGE_NEAREST)
        self.drawable.set_interp(new_interp)
        self.assertEqual(self.drawable.get_interp(), new_interp)

    def test_aspect_ratio(self):

        # get
        par = self.drawable.get_aspect_ratio()
        self.failUnless(isinstance(par, tuple))
        self.assertEqual(len(par), 2)
        self.assertEqual(par, (0, 1))

        # set
        new_par = (4, 3)
        self.drawable.set_aspect_ratio(*new_par)
        self.assertEqual(self.drawable.get_aspect_ratio(), new_par)

##     def test_set_from(self):

##         # gst buffer
##         buf = gst.Buffer("foo")
##         err = self.drawable.set_from_gst_buffer(pgm.ImagePixelFormat(pgm.IMAGE_RGBA),
##                                                 800, 600, 1, buf)
##         self.assertEqual(err, pgm.Error(pgm.ERROR_OK))
##         self.assertEqual(buf.__grefcount__, 2)

##         # buffer
##         buf = "foo"
##         err = self.drawable.set_from_buffer(pgm.ImagePixelFormat(pgm.IMAGE_RGBA),
##                                             800, 600, 1, len(buf), buf)
##         self.assertEqual(err, pgm.Error(pgm.ERROR_OK))


    def test_clear(self):

        # gst buf ref count
        buf = gst.Buffer("foo")
        err = self.drawable.set_from_gst_buffer(pgm.ImagePixelFormat(pgm.IMAGE_RGBA),
                                                800, 600, 1, buf)
        self.assertEqual(err, pgm.Error(pgm.ERROR_OK))
        self.assertEqual(buf.__grefcount__, 2)

        self.drawable.clear()
        self.assertEqual(buf.__grefcount__, 1)

        # TODO: slave

    def test_layout(self):

        # get
        ltype = self.drawable.get_layout()
        self.assertEqual(ltype, pgm.ImageLayoutType(pgm.IMAGE_SCALED))

        # set
        new_ltype = pgm.ImageLayoutType(pgm.IMAGE_FILLED)
        self.drawable.set_layout(new_ltype)
        self.assertEqual(self.drawable.get_layout(), new_ltype)

