/* **********************************************************
 * Copyright 2002 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * smac.h --
 *
 *      This file declares functionality that allows the
 *      bridge to be used across links that do
 *      not support promiscuous mode, nor provide the
 *      ability to transmit ethernet frames whose MAC source
 *      address does not match the hardware's MAC address. -- MattD
 */

#ifndef _SMAC_H_
#define _SMAC_H_

#ifdef WIN32
#include "vnetInt.h"

#define SMACINT

#else /* WIN32 */

#include "vm_basic_types.h"

/* linux header files include too much garbage, so just define if needed */
#ifndef ETH_ALEN
#define ETH_ALEN 6
#endif /* ETH_ALEN */

#ifndef ETH_HLEN
#define ETH_HLEN 14
#endif /* ETH_HLEN */

#if defined(__x86_64__)
#define SMACINT
#else
#define SMACINT __attribute__((cdecl, regparm(3)))
#endif

#endif /* WIN32 */

typedef enum {
   PacketStatusTooShort = 0x4546, // insuficient data to process packet
   PacketStatusDropPacket,        // bridge should drop packet
   PacketStatusForwardPacket      // bridge should accept/process/forward packet
} PacketStatus;

struct SMACState;

void SMACINT
SMAC_InitState(struct SMACState **ptr);           // IN: state to alloc/init
void SMACINT
SMAC_SetMac(struct SMACState *state, uint8 *mac); // IN: state, and host MAC
void SMACINT
SMAC_CleanupState(struct SMACState **ptr);        // IN: state to cleanup/dealloc

/* 
 * Structure is used to separate out differences 
 * between Windows and Linux packets
 */

#ifdef WIN32
/* defines Windows versions of SMACPacket and SMACPackets */
#include "smac_win.h"
#else /* WIN32 */
/* linux versions of these structs */
typedef struct SMACPacket {
   struct sk_buff *skb;  // packet
   void *startOfData;    // handles non-uniform start of data in sk_buff
} SMACPacket;

typedef struct SMACPackets {
   SMACPacket orig;  // IN: packet
   SMACPacket clone; // OUT: packet
} SMACPackets;
#endif /* WIN32 */

PacketStatus SMACINT
SMAC_CheckPacketFromHost(struct SMACState *state,  // IN: pointer to smac state
			 SMACPackets    *packets); // IN/OUT: packet(s) to process

PacketStatus SMACINT
SMAC_CheckPacketToHost(struct SMACState *state,  // IN: pointer to smac state
		       SMACPackets *packets);	 // IN/OUT: packet(s) to process

void SMACINT
SMAC_SetForwardUnknownPackets(struct SMACState *state, // IN: pointer to smac state
			      Bool forwardUnknown);    // IN: T/F to forward

#endif // _SMAC_H_


