/*
 * Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#include "ENMDataManager.h"
#include "ENMUtil.h"
#include <ENMPlugin.h>
#include <string>
using namespace std;

FILE* enm = NULL;
ENMDataManager* ENMDataManager::m_pENMDataManager = 0 ;

ENMDataManager::ENMDataManager()
{
    if (enm == NULL)
    {
        enm = fopen("/tmp/ENMDataManager.txt", "w");
    }
    m_currentAdapter = "";
}

ENMDataManager::~ENMDataManager()
{

}

ENMDataManager* ENMDataManager::GetInstance()
{
    if( !m_pENMDataManager)
       m_pENMDataManager = new  ENMDataManager();

    return m_pENMDataManager;
}

void ENMDataManager::InitializeDCS_Funcs(DCS_Funcs* pFuncs)
{
    if (NULL != pFuncs)
    {
        m_pFuncs = pFuncs;
    }
}

DCS_Return_Code ENMDataManager::InitUserInfo(ENM_InitUserInfo& userInfo)
{
    m_InitUserInfo = userInfo ;

    DCS_Return_Code ret = DCS_SUCCESS;

    return ret;
};

DCS_Return_Code ENMDataManager::SearchAdapter()
{
    string path((const char*)m_InitUserInfo.userPath.dcsString);

    m_LinuxNetworkApi.GetNetInfo(path,m_WiredAdapterList,m_WirelessAdapterList);


    DCS_Return_Code ret = DCS_SUCCESS;

    return ret;

}

DCS_Return_Code ENMDataManager::IsExistUpAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsUp)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    string path((const char*)m_InitUserInfo.userPath.dcsString);
    bool upFlag = true;
    if(adapterType == DCS_ADAPTER_WIREDLESS)
    {
        upFlag = m_LinuxNetworkApi.IfUp(m_WirelessAdapterList, m_currentAdapter);
    }
    else
    {
        upFlag = m_LinuxNetworkApi.IfUp(m_WiredAdapterList, m_currentAdapter);
    }

    if ( upFlag )
    {
        *pOutIsUp = TRUE;
    }
    else
    {
        *pOutIsUp = FALSE;
    }
//    fprintf(enm, "pOutIsUp is %d\n", *pOutIsUp);
//    fflush(enm);
    return ret;
}

DCS_Return_Code ENMDataManager::IsExistConnectAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsConnect)
{

    DCS_Return_Code ret = DCS_SUCCESS;
    string path((const char*)m_InitUserInfo.userPath.dcsString);
    bool upFlag = true;
    if(adapterType == DCS_ADAPTER_WIREDLESS)
    {
        upFlag = m_LinuxNetworkApi.IfLink(adapterType, m_WirelessAdapterList, path);
    }
    else
    {
        upFlag = m_LinuxNetworkApi.IfLink(adapterType, m_WiredAdapterList, path);
    }

    if ( upFlag )
    {
        *pOutIsConnect = TRUE;
    }
    else
    {
        *pOutIsConnect = FALSE;
    }
    return ret;
}

DCS_Return_Code ENMDataManager::UpAdapter(ENM_ADAPTER_TYPE adapterType)
{
    string path((const char*)m_InitUserInfo.userPath.dcsString);
    DCS_Return_Code ret = DCS_SUCCESS;

    if(adapterType == DCS_ADAPTER_WIREDLESS)
        m_currentAdapter = m_LinuxNetworkApi.StartupInterface(m_WirelessAdapterList, path);
    else
        m_currentAdapter = m_LinuxNetworkApi.StartupInterface(m_WiredAdapterList, path);

    return ret;
}

DCS_Return_Code ENMDataManager::DownAdapter(ENM_ADAPTER_TYPE adapterType)
{

    DCS_Return_Code ret = DCS_SUCCESS;

    bool bSuccess = false;
    if(adapterType == DCS_ADAPTER_WIREDLESS)
        bSuccess = m_LinuxNetworkApi.ShutdownInterface(m_WirelessAdapterList);
    else
        bSuccess = m_LinuxNetworkApi.ShutdownInterface(m_WiredAdapterList);


    return ret;

}

DCS_Return_Code ENMDataManager::DispatchDisableEvent(ENM_ADAPTER_TYPE adapterType)
{
    fprintf(enm, "enter DispatchDisableEvent(ENM_ADAPTER_TYPE adapterType)\n");
    fflush(enm);
    DCS_Return_Code ret = DCS_SUCCESS;

    bool bSuccess = false;
    if(adapterType == DCS_ADAPTER_WIREDLESS)
    {
        fprintf(enm, "adapterType is %d\n", DCS_ADAPTER_WIREDLESS);
        fflush(enm);
        bSuccess = m_LinuxNetworkApi.DispatchDisableEvent(m_WirelessAdapterList);
        if ( !bSuccess )
        {
            fprintf(enm, "disable wireless successful\n");
            fflush(enm);
            BOOL disable = TRUE;
            m_pFuncs->dispatchEvent(DCS_EASY_NETWORK_MANAGER, ENM_WLAN_DISABLED, &disable, sizeof(BOOL));
        }
        else
        {
            fprintf(enm, "disable wireless failed\n");
            fflush(enm);
            BOOL disable = FALSE;
            m_pFuncs->dispatchEvent(DCS_EASY_NETWORK_MANAGER, ENM_WLAN_DISABLED, &disable, sizeof(BOOL));
        }
    }
    else
    {
        fprintf(enm, "adapterType is %d\n", DCS_ADAPTER_WIRED);
        fflush(enm);
        bSuccess = m_LinuxNetworkApi.DispatchDisableEvent(m_WiredAdapterList);
        if ( !bSuccess )
        {
            fprintf(enm, "disable wired successful\n");
            fflush(enm);
            BOOL disable = TRUE;
            m_pFuncs->dispatchEvent(DCS_EASY_NETWORK_MANAGER, ENM_LAN_DISABLED, &disable, sizeof(BOOL));
        }
        else
        {
            fprintf(enm, "disable wired failed\n");
            fflush(enm);
            BOOL disable = FALSE;
            m_pFuncs->dispatchEvent(DCS_EASY_NETWORK_MANAGER, ENM_LAN_DISABLED, &disable, sizeof(BOOL));
        }
    }
    fprintf(enm, "leave DispatchDisableEvent(ENM_ADAPTER_TYPE adapterType)\n");
    fflush(enm);
    return ret;

}

DCS_Return_Code ENMDataManager::ConnectAP(ENM_ConnectAP& apInfo)
{

    DCS_Return_Code ret = DCS_SUCCESS;
    m_LinuxNetworkApi.ConnectAP(m_currentAdapter, (const char*)(apInfo.key.dcsString), string((const char*)apInfo.ssid.dcsString),apInfo.auth);
    return ret;
}

DCS_Return_Code ENMDataManager::GetAPList(AccessPointList* pOutAPList)
{

    DCS_Return_Code ret = DCS_SUCCESS;
    fprintf(enm, "m_currentAdapter is %s\n", m_currentAdapter.c_str());
    fflush(enm);
    m_LinuxNetworkApi.ScanNetwork(m_currentAdapter, (const char*)(m_InitUserInfo.userPath.dcsString), *pOutAPList);
    return ret;
}

DCS_Return_Code ENMDataManager::GetCurrentAP(APStatus* pOutCurrentAP)
{
    fprintf(enm, "m_currentAdapter is %s\n", m_currentAdapter.c_str());
    fflush(enm);
    m_LinuxNetworkApi.UpdateCurrentAP(m_currentAdapter, (const char*)(m_InitUserInfo.userPath.dcsString), *pOutCurrentAP);
    m_CurrentAP = *pOutCurrentAP;
    DCS_Return_Code ret = DCS_SUCCESS;
    return ret;
}

DCS_Return_Code ENMDataManager::GetIPAddressHLAN(ENM_String* pOutIpAddress)
{

    DCS_Return_Code ret = DCS_SUCCESS;
    string ipAddress  = m_LinuxNetworkApi.GetIPAddressHLAN(m_currentAdapter, (const char*)(m_InitUserInfo.userPath.dcsString));
    fprintf(enm, "ip is %s\n", ipAddress.c_str());
    fflush(enm);
    memset(pOutIpAddress, 0, sizeof(ENM_String));
    memcpy(pOutIpAddress, ipAddress.c_str(), ipAddress.length());

    return ret;
}

DCS_Return_Code ENMDataManager::GetConnectTypeHLAN(ENM_String* pOutConnectType)
{

    DCS_Return_Code ret = DCS_SUCCESS;
    string connectType = m_LinuxNetworkApi.GetConnectTypeHLAN(m_currentAdapter, (const char*)(m_InitUserInfo.userPath.dcsString));
    memset(pOutConnectType, 0, sizeof(ENM_String));
    memcpy(pOutConnectType, connectType.c_str(), connectType.length());

    return ret;
}

DCS_Return_Code ENMDataManager::AllocateDhIP()
{

    DCS_Return_Code ret = DCS_SUCCESS;

    if( m_currentAdapter != "")
        m_LinuxNetworkApi.DhAllocateIP(m_currentAdapter);

    return ret;
}

DCS_Return_Code ENMDataManager::CloseWlanConnection()
{
    DCS_Return_Code ret = DCS_SUCCESS;
    m_LinuxNetworkApi.CloseWlanConnection(m_currentAdapter);
    return ret;
}

DCS_Return_Code ENMDataManager::Enable8021xAuthentication(bool* pEnable)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    m_LinuxNetworkApi.Enable8021xAuthentication(*pEnable);
    return ret;
}

DCS_Return_Code ENMDataManager::EnableInternetSharing(bool* pEnable)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    m_LinuxNetworkApi.EnableInternetSharing(*pEnable);
    return ret;
}

DCS_Return_Code ENMDataManager::OverwriteHomePage(ENM_String* pStrHomePage)
{
    string path((const char*)m_InitUserInfo.userPath.dcsString);
    DCS_Return_Code ret = DCS_SUCCESS;
    fprintf(enm, "homepage is %s\n", pStrHomePage->dcsString);
    m_LinuxNetworkApi.OverwriteHomePage(*pStrHomePage, path);
    fflush(enm);
    return ret;
}

DCS_Return_Code ENMDataManager::OverwriteProxy(ENM_ProxyInfo* pProxyInfo)
{
    string path((const char*)m_InitUserInfo.userPath.dcsString);
    DCS_Return_Code ret = DCS_SUCCESS;
	fprintf(enm, "Enter enm overwrite proxy \n");
	fprintf(enm, "overwrite proxy %s\n",pProxyInfo->host.dcsString);
	fprintf(enm, "overwrite proxy %s\n",pProxyInfo->port.dcsString);
    fflush(enm);
    m_LinuxNetworkApi.OverwriteProxy(*pProxyInfo, path);
    return ret;
}

//    DCS_Return_Code GetNeighborsInfo(PENM_NEIGHBORS_INFO* pNeighborsInfo);

DCS_Return_Code ENMDataManager::ChangeAddress(ENM_AddressInfo* pAddressInfo)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    strcpy((char* )pAddressInfo->adapterInfo.userName.dcsString, m_currentAdapter.c_str());
    m_LinuxNetworkApi.ChangeAddress(*pAddressInfo);
    return ret;
}

DCS_Return_Code ENMDataManager::EnableFileAndPrint(bool* pEnable)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    return ret;
}

DCS_Return_Code ENMDataManager::EnableWindowsFirewall(bool* pEnable)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    return ret;
}

DCS_Return_Code ENMDataManager::IsExistAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsExist)
{

    DCS_Return_Code ret = DCS_SUCCESS;
    string path((const char*)m_InitUserInfo.userPath.dcsString);
    bool existFlag = true;
    if(adapterType == DCS_ADAPTER_WIREDLESS)
    {
        if ( 0 == m_WirelessAdapterList.Count() )
        {
            existFlag =false;
        }
    }
    else
    {
        if ( 0 == m_WiredAdapterList.Count() )
        {
            existFlag =false;
        }
    }

    if ( existFlag )
    {
        *pOutIsExist = TRUE;
    }
    else
    {
        *pOutIsExist = FALSE;
    }
    return ret;
}

DCS_Return_Code ENMDataManager::ExecSmbtree()
{
    DCS_Return_Code ret = DCS_SUCCESS;
    m_LinuxNetworkApi.ExecSmbtree();
//    string path((const char*)m_InitUserInfo.userPath.dcsString);
//    m_currentAdapter = m_LinuxNetworkApi.StartupInterface(m_WirelessAdapterList, path);
    return ret;
}

DCS_Return_Code ENMDataManager::ExecNmblookup(ENM_String* strHostName)
{
    DCS_Return_Code ret = DCS_SUCCESS;
    m_LinuxNetworkApi.ExecNmblookup(*strHostName, m_currentAdapter);
    return ret;
}
