/****************************************************************************

 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

File Name:          PowerSchemeMgmt.h

Description:

    This file defines class PowerSchemeMgmt.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef POWERSCHEMEMGMT_H_INCLUDED
#define POWERSCHEMEMGMT_H_INCLUDED

#include "inc/DCSCommon.h"
#include "xmlparser/tinyxml.h"

#include <cstdlib>
#include <string>
#include <iostream>
#include <map>
#include <vector>
using namespace std;
#include <pwd.h>
#include <stdio.h>

const string SCHEMEFILE("/.ipm/PowerScheme_pmsch.xml");
const string DEFAULTSCHEMEFILE("/etc/ipower-management/config-file-bak/PowerScheme_pmsch.xml");

const string SCHEMES("schemes");
const string SCHEME("scheme");
const string NAME("name");
const string SCHEMEID("schemeid");
const string DEFAULT("isdefault");
const string DESC("desc");
const string SCHEME_ACTIVE("active");
const string ACVALUE("acvalue");
const string DCVALUE("dcvalue");
const string VALUE("value");

const int BUFFER_SIZE = 256;
const int SETTING_MAX_NUM = 6;
//const string SCHEME_SETTINGS[SETTING_MAX_NUM] = {
//            "LCDBrightness", "LANSpeed", "CloseLCD", "Standby", "LANStatus", "WLANStatus"};

const int DEFAULT_SCHEMEID[3] = {807111933, 269187357, 807111934};
const int NONDEFAULT = 0;

class PowerSchemeMgmt{

public:
    PowerSchemeMgmt(string userHomeDir);
    ~PowerSchemeMgmt();

    DCS_Return_Code GetActiveSchemeId(int &schemeId);
    DCS_Return_Code DeletePowerScheme(int schemeId);
    DCS_Return_Code SetActivePowerScheme(int schemeId);
    DCS_Return_Code AddPowerScheme(char *pName, char *pDesc, int copyFrom, int schemeId);

    //Sets a variable value in a power scheme.
    DCS_Return_Code SetPowerVariable(int schemeId, BOOL isAC, const char *pVarName, int value);

    //Gets the value of the variable.
    DCS_Return_Code GetPowerVariable(int schemeId, BOOL isAC, const char *pVarName, int *pValue);

    DCS_Return_Code GetPowerSchemeNameDesc(int schemeId, string &pSchemeName, string &pSchemeDesc);

    DCS_Return_Code InitSchemeFilePath();

private:
    DCS_Return_Code GetDefaultSchemeInfo(int schemeId, map<string, int> &acMapping, map<string, int> &dcMapping);

private:
    string m_SchemeFilePath;
};


#endif // POWERSCHEMEMGMT_H_INCLUDED
