/**
 * 
 * @file VKDHelper.h
 *
 * @version 1.0
 * @author Shirley Zhao
 * @date 2008/07/20
 */

#ifndef VKD_HELPER_H
#define VKD_HELPER_H

#include <pthread.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>


#include <set>
#include "../../../../inc/DCSCommon.h"
#include "../../../../inc/plugins/DcsPlugin.h"
#include "../../../../inc/plugins/vkbd/VKbdDef.h"
#include "../../../../inc/plugins/vkbd/VKbdPlugin.h"

/**
 * @class VkdHelper
 * @brief VkdHelper provides help on operating Vkd driver.
 *
 * It is implemented as a singleton.
 */

//#define VKD_TEST

//typedef int __u32;

class VkdHelper
{
public:
	static VkdHelper &GetInstance()
	{
		static VkdHelper helper;
		return helper;
	};

	/** public functions which really implement DCS Plugin interfface. */
	int Initialize(DCS_Funcs *pDispatcher);
	DCS_Return_Code HandleRequest(DCS_RequestData *pRequest);
	int Cleanup();

public:

	VkdHelper(void)
		: m_Thread(0), m_Device(-1)
	{
		m_Backlight_Count = 0;
	};

	~VkdHelper(void)
	{
	};

	/** declare copy constructor and equal operator to prevent
	 *  copied instance
	 */
	VkdHelper(const VkdHelper &);
	VkdHelper &operator =(const VkdHelper &);

	/* Vkd related functions */
	BOOL ProcFnkeyMsg(int oprt);
	BOOL DispatchEventToDCS(DCS_VKbd_Data data);

//	void TestFun();
//	void TestSiglrmHandler(int sig);

//	void SetTimer(int interval, int value);
//	void BzbnSiglrmHandler(int sig);
//	void BacklightSiglrmHandler(int sig);

	void SetBzbnPressed();
	void SetBzbnReleased();
	void SetBacklightDownPressed(void);
	void SetBacklightDownReleased(void);
	void SetBacklightUpPressed(void);
	void SetBacklightUpReleased(void);

	/* Vkd related variables */
	int m_Bzbn_Signal;
	int m_Backlight_Signal;
	int m_Backlight_Count;

	/** pointer to DCS dispatch function */
	DCS_Funcs *m_pFuncs;

	/** const values */
	static const char * const MODULE_NAME; /** Vkd chip module name */

	/** Linux working thread function */
	friend void *VkdEventHandler(void *arg);	

	static const char * const DEVICE_PATH; /** path to open driver */

	pthread_t m_Thread;
	int m_Device;

public:
	void TestFun();
#ifndef VKD_TEST
	void SetTimer(int interval, int value);
#endif
//	void TestSiglrmHandler(int sig);
//	void BzbnSiglrmHandler(int sig);
//	void BacklightSiglrmHandler(int sig);

};
#endif /** VKD_HELPER_H */

