/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DCS_CRYPTO_H_
#define DCS_CRYPTO_H_
#include "DCSCommon.h"
#include "ConnMgmt.h"

#ifdef UNIT_TEST
#include "TestCrypto.h"
#endif

class Crypto{
#ifdef UNIT_TEST
	friend class TestCrypto;
#endif
public:
	Crypto(DCS_UserID id) {userID = id;}
/**clearMessage is the message to be encrypted, and *pLen is the length of the message,
 * and it also returns the length of encrypted result message
 */
	int EncryptMessage(unsigned char* clearMessage,int clearMessageLen, unsigned char* encryptedMessage,int* pLen);
/**encryptedMessage is the message to be decrypted, and *pLen is the length of the message,
 *and it also returns the length of decrypted result message
 */
	int DecryptMessage(unsigned char* encryptedMessage, int encryptedLen, unsigned char* decryptedMessage,int* pLen);
private:

/* the password is read from the system registry table
 * \\HKEY_LOCAL_MACHINE\SOFTWARE\Intel\DCS\Password which is only readable for Administrator user (Windows)
 * or /etc/DCS/crypto.txt which is only readable for root user (Linux)
 */
	const char* GetPassword();
	DCS_UserID userID;
	char password[MAX_PATH];
};
#endif
