/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifdef WIN32
#include <afxwin.h>
#endif
#include "vkbd/VKbdDef.h"
#include <string> 

#include "SupplierManager.h"   
#include "PolicyApi.h"
#include "Policy.h"
#include "pm/PMPlugin.h"
#include <iostream>
#include "vkbd/VKbdPlugin.h"
#include "tablet/TabletPlugin.h"
#include "accel/AccelPlugin.h"

#ifdef WIN32
#include "io.h"
char* MODULE_LIBRARY_PATH;
#else
#include <stdio.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <stdio.h>  
#include <dirent.h>  
#include <sys/types.h>  
#include <sys/stat.h>  
#include <unistd.h>
/**All the module libraries are placed under /usr/lib/dcs*/
#define MODULE_LIBRARY_PATH  "/usr/lib/dcs"
#endif

#include <string>
using namespace std;
#define MAX_PATH_LENGTH 1024
/** the module interface number
*  char* moduleApis[MODULE_API_NUM] = { "DP_GetModuleID", "DP_Initialize", "DP_Uninitialize", "DP_HandleRequest", "DP_GetDescription"};
*/
extern void DCS_EventDispatcher(int moduleID, int eventID, PVOID pData, size_t dataLen);
extern void DebugString(const char* format, ...);
#define MODULE_API_NUM 100

DCS_Funcs dcsFuncs;
SupplierManager* SupplierManager::pInstance;

SupplierManager* SupplierManager::Instance()
{
	if (pInstance == NULL)
		pInstance = new SupplierManager();
	return pInstance;
}

SupplierManager::SupplierManager()
{
	loadedModuleNum = 0;
#ifdef WIN32	
	m_hMutex = NULL;
	
	while ((m_hMutex = CreateMutex(NULL, FALSE, NULL)) == NULL)
	{
		Sleep(5000);
		DebugString("create mutex fail in suppliermanager constructor");
	}
#endif
	Init();
}
SupplierManager::~SupplierManager()
{
	Unlock();
#ifdef WIN32	
	m_hMutex = NULL;
#endif
	UnInit();
//	if (pInstance != NULL)
//		delete pInstance;
}
int SupplierManager::UnInit()
{
	int ret = 0;	
	map<DCS_Socket, vector<bool> >::iterator iter;

	for (int i=0; i<loadedModuleNum; i++)
	{
#ifdef WIN32
		DebugString("free library %d", i);
		ret = loadedModuleInfo[i].unInit();
		DebugString("Uninit module ID= %d return %d", loadedModuleInfo[i].ID, ret);
		ret = FreeLibrary(*(HMODULE*)loadedModuleInfo[i].lib);
		DebugString("free library module ID= %d return %d", loadedModuleInfo[i].ID, ret);
#else
		const char *dlError;        /*  Pointer to error string     */
		if (loadedModuleInfo[i].lib)
			ret = dlclose(loadedModuleInfo[i].lib );
		dlError = dlerror();
		DebugString("Close handle return-%s-\n",dlError); 
#endif
		loadedModuleInfo[i].lib = NULL;
		loadedModuleInfo[i].funcHandler = NULL;
		loadedModuleInfo[i].unInit = NULL;

			/*for (iter=loadedModuleInfo[i].clientRegisteredEventTbl.begin();iter!=loadedModuleInfo[i].clientRegisteredEventTbl.end();iter++)
			{
					DebugString("socket:%d, regevt:%d", iter->first, iter->second.size());
					iter->second.clear();
			}*/
			loadedModuleInfo[i].clientRegisteredEventTbl.clear();
	}
	
	return 0;
}

/**
*	Search specified directory to get the libraries that have specified interfaces, 
*	call the interface to get the module ID, and Initialize the library.
*  Document the module ID into the loadedModuleIDs table.
*/
int SupplierManager::Init()
{
#ifdef WIN32
	char* sysDir = getenv("SystemRoot");
	MODULE_LIBRARY_PATH=(char *)alloca(MAX_PATH);
	strcpy(MODULE_LIBRARY_PATH,sysDir);
	strcat(MODULE_LIBRARY_PATH,"\\system32\\dcs\\");

#else
	const char *dlError;        /*  Pointer to error string     */
	struct   stat   s;  

#endif
	int ret = 0;             /*  return codes            */
	const char* dir = MODULE_LIBRARY_PATH;
	int moduleNum = 0;
	TCHAR* moduleFileNames[MAX_MODULE_NUM];
	int i=0;
//	const char* moduleApis[MODULE_API_NUM] = { "DP_GetModuleID", "DP_Initialize", "DP_Uninitialize", "DP_HandleRequest", "DP_GetDescription"};
	int   (*DP_GetModuleID)();        /**<  Pointer to DP_GetModuleID   */
	int   (*DP_Initialize)(DCS_Funcs *pDispatcher);        /**<  Pointer to DP_Initialize   */
	int   (*DP_Uninitialize)();        /**<  Pointer to DP_Uninitialize, not called in Init   */
	DCS_Return_Code (*DP_HandleRequest)(DCS_RequestData*);        /**<  Pointer to DP_HandleRequest , not called in Init  */
	int   (*DP_GetDescription)();        /**<  Pointer to DP_GetDescription, not called in Init*/

	dcsFuncs.version = DCS_VERSION;
	dcsFuncs.dispatchEvent = &DCS_EventDispatcher;


	loadedModuleNum = 0;

#ifdef WIN32
	////////////////////////////////////////need to create the directory when the directory not exists
	////////////////////////////////////////
#else
	if(lstat(dir,   &s)   <   0){  
		mkdir(dir, 0777);
		DebugString("lstat   error\n");  
		return 0; 
	}  
	if(!S_ISDIR(s.st_mode)){  
		DebugString("%s   is   not   a   direction   name\n",   dir);  
		return 0; 
	}  
#endif
#ifdef WIN32
	int nLen = (int)strlen(dir)+1;
	int nwLen = MultiByteToWideChar(CP_ACP,0,dir,nLen,NULL,0);
	TCHAR s_dir[MAX_PATH_LENGTH];
	MultiByteToWideChar(CP_ACP,0,dir,nLen,s_dir,nwLen);
	ScanDir(s_dir, moduleFileNames, &moduleNum);   
#else
	ScanDir(dir, moduleFileNames, &moduleNum); 
#endif
	for (i=0;i<moduleNum && i<MAX_MODULE_NUM;i++)
	{
		//TCHAR* libName = new TCHAR[MAX_PATH]; //windows defined macro, PATH_MAX : LINUX defined macro
		TCHAR libName[MAX_PATH];
#ifdef WIN32
		wmemset(libName,0,MAX_PATH);
		//wcscpy(libName,  moduleFileNames[i]);
		wmemcpy(libName,moduleFileNames[i],wcslen(moduleFileNames[i])+1);
#else 
		memset(libName,0,MAX_PATH);
		memcpy(libName,moduleFileNames[i],strlen(moduleFileNames[i])+1);
#endif
#ifdef WIN32
		//CString s_libName(libName);
		//HINSTANCE hInst
		loadedModuleInfo[loadedModuleNum].lib = LoadLibrary(libName);
#else
		loadedModuleInfo[loadedModuleNum].lib = dlopen(libName,RTLD_LAZY);
		dlError = dlerror();
		DebugString(" Open Library return-%s- \n", dlError);
		if( dlError ) continue; // continue to load the next library
#endif	

		int moduleID = 0;
		BOOL duplicated = FALSE;

#ifdef WIN32
		*(void **)(&DP_GetModuleID) = GetProcAddress(loadedModuleInfo[loadedModuleNum].lib,"DP_GetModuleID");
		if( NULL == DP_GetModuleID) 
		{
			/////////////////////////////////////////////////////////////////////////////////////BUGBUG
			//unload library
			continue; //this library interface is not consistent with designed Module Library
		}
#else
		*(void **)(&DP_GetModuleID) = dlsym( loadedModuleInfo[loadedModuleNum].lib ,"DP_GetModuleID");
		dlError = dlerror();
		DebugString(" Find symbol DP_GetModuleID return-%s- \n",  dlError);
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif
#ifdef WIN32
		*(void **)(&DP_Initialize) = GetProcAddress(loadedModuleInfo[loadedModuleNum].lib,"DP_Initialize");
		if( NULL == DP_Initialize) 
			continue; //this library interface is not consistent with designed Module Library
#else

		*(void **)(&DP_Initialize) = dlsym( loadedModuleInfo[loadedModuleNum].lib , "DP_Initialize");
		dlError = dlerror();
		DebugString(" Find symbol  DP_Initialize return-%s- \n", dlError);
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif
#ifdef WIN32
		*(void **)(&DP_Uninitialize) = GetProcAddress(loadedModuleInfo[loadedModuleNum].lib,"DP_Uninitialize");
		if( NULL == DP_Uninitialize) 
			continue; //this library interface is not consistent with designed Module Library

#else

		*(void **)(&DP_Uninitialize) = dlsym( loadedModuleInfo[loadedModuleNum].lib , "DP_Uninitialize");
		dlError = dlerror();
		DebugString(" Find symbol %s return-%s- \n", "DP_Uninitialize", dlError);
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif
#ifdef WIN32
		*(void **)(&DP_HandleRequest) = GetProcAddress(loadedModuleInfo[loadedModuleNum].lib,"DP_HandleRequest");
		if( NULL == DP_HandleRequest) 
			continue; //this library interface is not consistent with designed Module Library
#else

		*(void **)(&DP_HandleRequest) = dlsym( loadedModuleInfo[loadedModuleNum].lib , "DP_HandleRequest");
		dlError = dlerror();
		DebugString(" Find symbol %s return-%s- \n", "DP_HandleRequest", dlError);
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif
#ifdef WIN32
		*(void **)(&DP_GetDescription) = GetProcAddress(loadedModuleInfo[loadedModuleNum].lib,"DP_GetDescription");
		if( NULL == DP_GetDescription) 
			continue; //this library interface is not consistent with designed Module Library
#else

		*(void **)(&DP_GetDescription) = dlsym( loadedModuleInfo[loadedModuleNum].lib , "DP_GetDescription");

		dlError = dlerror();
		DebugString(" Find symbol %s return-%s- \n", "DP_GetDescription", dlError);
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif		
		/* Get Module ID*/
		if (DP_GetModuleID != NULL)
			moduleID = (*DP_GetModuleID)();
#ifdef WIN32
#else
		dlError = dlerror();
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif
		if (moduleID >0 && moduleID <= MAX_MODULE_NUM) /**< available Module ID*/
		{
			//judge if current module ID is the same with the libaries already loaded
			for (int k=0; k<loadedModuleNum && k<MAX_MODULE_NUM; k++)
				if (loadedModuleInfo[k].ID == moduleID)
				{
					DebugString("Duplicated module ID.");
					duplicated = TRUE;
					break; /**<duplicated module ID*/
				}
				loadedModuleInfo[loadedModuleNum].ID = moduleID;
		}
		else 
		{
			//unload the library
			continue; //module ID not available
		}


		if (duplicated) continue; /**<duplicated or not available module ID, not load current library, continue to next library file*/

		/** Initialize*/
		if (DP_Initialize != NULL)
		{
			ret = (*DP_Initialize)(&dcsFuncs);
#ifdef WIN32
#else	
	dlError = dlerror();
		if( dlError ) 
			continue; //this library interface is not consistent with designed Module Library
#endif
			int ttt=0;
			while (ret != DCS_SUCCESS)
			{
				
				DebugString("Init module ID= %d failed", moduleID);
				#ifdef _WIN32
					Sleep(2000);
				#else
					sleep(2);
				#endif
				ret = (*DP_Initialize)(&dcsFuncs);
				ttt++;
				if (ttt> 5)
				break; // fail to initialize, don't load the library
			}
			if (ttt>5)
			{
				DP_Uninitialize();
				continue;
			}
		}
		/**< Handle function*/
		loadedModuleInfo[loadedModuleNum].funcHandler = DP_HandleRequest;

		loadedModuleInfo[loadedModuleNum].unInit = DP_Uninitialize;
		//}
		loadedModuleInfo[loadedModuleNum].clientRegisteredEventTbl.clear();//registeredEvents = 0;

		loadedModuleNum++;

		//delete[] libName;
		//libName = NULL;
	}

//	if (dir != NULL) dir = NULL;
	for (i=0;i<loadedModuleNum;i++)
		if (moduleFileNames[i] != NULL) 
		{
			delete[] moduleFileNames[i];
			moduleFileNames[i] = NULL;
		}

		return(0);
}
#ifdef WIN32

void   SupplierManager::ScanDir(TCHAR   *path, TCHAR * files[], int* filenum)   
{  
	if (path==NULL)
		return ;
	if (filenum==NULL)
		return ;
	if (files==NULL)
		return ;


	TCHAR s_dllDir[MAX_PATH];
	wmemset(s_dllDir,0,MAX_PATH);
	wcscpy(s_dllDir,path);
	WIN32_FIND_DATA FindFileData;
	HANDLE hFind;
	*filenum=0;
	wstring tmp_name;
	int nIndex;

	if ( _waccess(s_dllDir,0) == -1)
	{
		return ;
	}
	try 
	{
		wcscat(s_dllDir,_T("*.dll"));
		hFind = FindFirstFile(s_dllDir, &FindFileData);
		
		if (hFind == INVALID_HANDLE_VALUE)
			return ;

		tmp_name=FindFileData.cFileName;
		nIndex=(int)tmp_name.rfind('.');
		if (nIndex <= 0)
			return ;
		tmp_name = tmp_name.substr(nIndex,tmp_name.size()-nIndex);

		//memset(tmp,0,MAX_PATH);
		if (tmp_name == _T(".dll") )
		{
			wmemset(s_dllDir,0,MAX_PATH);
			wcscpy(s_dllDir,path);
			wcscat(s_dllDir,FindFileData.cFileName);
		
			if ( GetFileAttributes(s_dllDir) != FILE_ATTRIBUTE_DIRECTORY) // not a.dll folder
			{
				files[*filenum] = (TCHAR*) malloc(MAX_PATH);
				wcscpy(files[*filenum],s_dllDir);
				(*filenum)++;
			}
		}
		if (hFind == INVALID_HANDLE_VALUE) 
		{
			printf ("Invalid File Handle. GetLastError reports %d\n",GetLastError ());
		} 
		else 
		{

			while (FindNextFile(hFind, &FindFileData) != 0) 
			{
				tmp_name=FindFileData.cFileName;
				nIndex=(int)tmp_name.rfind('.');
				if (nIndex <= 0)
					return ;
				tmp_name = tmp_name.substr(nIndex,tmp_name.size()-nIndex);
				if (tmp_name == _T(".dll"))
				{
					if ( *filenum >= MAX_MODULE_NUM)
						break;

					wmemset(s_dllDir,0,MAX_PATH);
					wcscpy(s_dllDir,path);
					wcscat(s_dllDir,FindFileData.cFileName);

					if ( GetFileAttributes(s_dllDir) != FILE_ATTRIBUTE_DIRECTORY) // not a.dll folder
					{
						files[*filenum] = (TCHAR*) malloc(MAX_PATH);
						wcscpy(files[*filenum],s_dllDir);
						(*filenum)++;
					}
				}
			}

			FindClose(hFind);
		}

	}
	catch(...)	
	{
		DebugString("error ocurrs in Scandir() \n");
	}
	/*finally
	{
	DebugString("LoadModuleInfo are listing here...\n");

	}*/

}   
#else
void   SupplierManager::ScanDir(const char   *path, char* files[], int* filenum)   {  
	DIR   *dir;  
	char   fullpath[MAX_PATH_LENGTH],currfile[MAX_PATH_LENGTH];  
	struct   dirent   *s_dir;  
	struct   stat   file_stat;  
        string file_name;
        string back_name;
        int nIndex=0;
        
	if (files == NULL || path == NULL || filenum == NULL) 
	{
		DebugString("SupplierManager::ScanDir, parameter is null");
		return;
	}
	*filenum = 0;
	strcpy(fullpath,path);  

	dir=opendir(fullpath);  
	while   ( dir != NULL && (s_dir=readdir(dir))!=NULL)   {  
		if   ((strcmp(s_dir->d_name,".")==0)||(strcmp(s_dir->d_name,"..")==0))   continue;  
                file_name = s_dir->d_name;
		nIndex = file_name.rfind('.',-1);
		if (nIndex == -1)
		        continue;
		       
		back_name = file_name.substr(nIndex,file_name.size()-1);
		
		if (back_name == ".so")
		{
        		if ( strlen(currfile) + strlen(fullpath) + strlen(s_dir->d_name) +1 < MAX_PATH_LENGTH)
        			sprintf(currfile,"%s/%s",fullpath,s_dir->d_name);  
		        stat(currfile,&file_stat);  
		        if   (S_ISDIR(file_stat.st_mode))  
	        		continue;//ScanDir(currfile);  
        		else  
		        {
	        		DebugString("%s\n",currfile);  
	        		files[*filenum] = new char[MAX_PATH_LENGTH];
	        		strcpy(files[*filenum], currfile);
	        		(*filenum) ++;
	        	}
		}
	}  
	closedir(dir);  
}   
#endif

	/* handle unregister event,  remove the module/event from the registered event table */
int  SupplierManager::HandleUnregisterEvent(DCS_Socket clifd, int moduleID, int eventID)
{
	if (moduleID < 0 || moduleID >= MAX_MODULE_NUM) 
		return DCS_MODULE_NOTEXIST;

	if ( eventID <MIN_EVENT_ID  || eventID >= MAX_EVENT_ID)
		return DCS_EVENT_NOTEXIST;

	map<DCS_Socket, int>::iterator iter;

	if (eventID >= DCS_EVENT_NUM_START)// && eventID < DCS_UNREGISTER_EVENT_NUM_START)//register event
		eventID -= DCS_EVENT_NUM_START;

	Lock();
	try {
	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
			if (loadedModuleInfo[i].ID == moduleID){
				iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);

				if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())
					iter->second &= ~(1<<eventID);
			}
/*	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
			if (loadedModuleInfo[i].ID == moduleID){
				if (! loadedModuleInfo[i].clientRegisteredEventTbl.empty())
				{
					iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);
					if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())
						if (iter->second.size() > eventID)
							loadedModuleInfo[i].clientRegisteredEventTbl[clifd][eventID]=0;
				}
				break;
			}
*/
	} catch (...) {
		DebugString("HandleUnregisterEvent catch exception");
	}
	Unlock();
	return DCS_SUCCESS;
	
}


/** handle event, event id is of type Module_Operation */
int SupplierManager::HandleEvent(DCS_Socket clifd, int moduleID, int eventID)
{//BUGBUG: need to protect the critical section, not thread-safe
	if (moduleID < 0 || moduleID >= MAX_MODULE_NUM) 
		return DCS_MODULE_NOTEXIST;

	if ( eventID <MIN_EVENT_ID  || eventID >= MAX_EVENT_ID)
		return DCS_EVENT_NOTEXIST;

	map<DCS_Socket, int >::iterator iter;

	if (eventID >= DCS_EVENT_NUM_START)// && eventID < DCS_UNREGISTER_EVENT_NUM_START)//register event
		eventID -= DCS_EVENT_NUM_START;

	Lock();
	try {
		/**register event*/
	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
		if (loadedModuleInfo[i].ID == moduleID){
			iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);
	
			if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())//this client already registered events
				loadedModuleInfo[i].clientRegisteredEventTbl[clifd] |= 1<<eventID;//(int) pow ((double)2 , eventID);
			else//this client  never register event
				loadedModuleInfo[i].clientRegisteredEventTbl[clifd]= 1<<eventID;
			
			Unlock();
			return 0;
		}
	} catch (...) {
		DebugString("HandleEvent catch exception");
	}

	/*
	bool* v=NULL;
	//register event
	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
		if (loadedModuleInfo[i].ID == moduleID){
			if (! loadedModuleInfo[i].clientRegisteredEventTbl.empty())
			{				
				iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);
				if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())//this client already registered events
				{
					loadedModuleInfo[i].clientRegisteredEventTbl[clifd][eventID] = 1;
					 Unlock();
					 return 0;
				}
			}
			v = new bool [MAX_EVENT_NUM];
			memset(v,0, sizeof (bool) * MAX_EVENT_NUM);

			//this client  never register event
		//	loadedModuleInfo[i].clientRegisteredEventTbl.insert(pair<DCS_Socket, vector<bool> >(clifd, vector<bool> (v,v+MAX_EVENT_NUM)));
			loadedModuleInfo[i].clientRegisteredEventTbl[clifd] = vector<bool> (v,v+MAX_EVENT_NUM);
			loadedModuleInfo[i].clientRegisteredEventTbl[clifd][eventID] = 1;
			DebugString("registering: socket:%d, regevt:%d", clifd, eventID);
			Unlock();
			return 0;
		}
		
		*/
	Unlock();
	return DCS_MODULE_NOTEXIST;
}


/** handle event, event id is of type Module_Operation */
BOOL SupplierManager::CheckEvent(DCS_Socket clifd, int moduleID, int eventID)
{

	if (moduleID < 0 || moduleID >= MAX_MODULE_NUM) 
		return FALSE;

	if ( eventID <0  || eventID >= MAX_EVENT_ID)
		return FALSE;
	if (eventID >= DCS_EVENT_NUM_START)
		eventID -= DCS_EVENT_NUM_START;
	map<DCS_Socket, int >::iterator iter;


	Lock();
	try {
		for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
		if (loadedModuleInfo[i].ID == moduleID){
			iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);
			if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())//this client already registered events
				if (iter->second & (1<<eventID))//(int)pow((double)2 , eventID))
				{Unlock();	return TRUE;}
			
			break;
		}
	} catch (...) {
		DebugString("CheckEvent catch exception");
	}
	/*
	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
		if (loadedModuleInfo[i].ID == moduleID){
	
			if (loadedModuleInfo[i].clientRegisteredEventTbl.empty())
			{
				Unlock();
				return FALSE;}
				iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);

				if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())//this client already registered events
				{
					if (iter->second[eventID])
					{
						Unlock();
						return TRUE;
					}
					else
						DebugString("event %d is not registered for cli: %d, value: %d", eventID, clifd, loadedModuleInfo[i].clientRegisteredEventTbl[clifd][eventID]);

			}

			break;
		}*/

	
	Unlock();
	
	return FALSE;
}

int SupplierManager::HandlePolicy(int funcID, PVOID params,size_t paramsLen, PVOID pReturnData, size_t* pReturnDataLen)
{
	if (funcID > POLICY_SAVE || funcID < POLICY_SET) return DCS_FUNC_NOTEXIST;
	//if (params == NULL)
	//	return DCS_NOT_SUPPORTED;

	if (pReturnData == NULL || pReturnDataLen == NULL)
		return DCS_NOT_SUPPORTED;

	int ret = 0;
	Policy* pPolicy = Policy::Instance();
	DCS_Policy_Operation opID = (DCS_Policy_Operation)funcID;
	DCS_Policy_Data* data = NULL;
	DCS_Policy_Access* access = NULL;

	switch (opID){
	case POLICY_SET:
		*pReturnDataLen = 0;
		if (paramsLen != sizeof(DCS_Policy_Data)) 
		{
			DebugString("SupplierManager::HandlePolicy: paramsLen is not correct.");
			return DCS_FAIL_OPERATION;
		}
		data = (DCS_Policy_Data*)params;
		ret = pPolicy->SetPolicy(data->userGroup, data->moduleId, data->opId, data->access);
		break;
	case POLICY_GET:
		*pReturnDataLen = 0;
		if (paramsLen !=  sizeof(DCS_Policy_Data)) 
		{
			DebugString("SupplierManager::HandlePolicy: paramsLen is not correct.");
			return DCS_FAIL_OPERATION;
		}
		data = (DCS_Policy_Data*)params;
		ret = pPolicy->GetPolicy(data->userGroup, data->moduleId, data->opId, (DCS_Policy_Access*)pReturnData);
		if (ret) 
		{
			pReturnData = NULL;
			*pReturnDataLen = 0;
			return ret;
		}
		*pReturnDataLen = sizeof(DCS_Policy_Access);
		break;
	case POLICY_REMOVE:
		*pReturnDataLen = 0;
		if (paramsLen !=  sizeof(DCS_Policy_Data)) 
		{
			DebugString("SupplierManager::HandlePolicy: paramsLen is not correct.");
			return DCS_FAIL_OPERATION;
		}
		data = (DCS_Policy_Data*)params;
		ret = pPolicy->RemovePolicy(data->userGroup, data->moduleId, data->opId);
		break;
	case POLICY_SET_DEFAULT:
		*pReturnDataLen = 0;
		if (paramsLen !=  sizeof(DCS_Policy_Access)) 
		{
			DebugString("SupplierManager::HandlePolicy: paramsLen is not correct.");
			return DCS_FAIL_OPERATION;
		}
		access = (DCS_Policy_Access*) params;
		ret = pPolicy->SetDefaultPolicy(*access);
		break;
	case POLICY_SAVE:
		*pReturnDataLen = 0;
		ret = pPolicy->SavePolicy();
		break;
	default:
		ret = DCS_FUNC_NOTEXIST;
	}
	return ret;
}
/** handle function request, function id is of type Module_Operation */
int SupplierManager::HandleFuncRequest(DCS_Socket , int moduleID, DCS_RequestData* pData)
{
	int ret = 0;
	if (moduleID < 0 || moduleID >= MAX_MODULE_NUM )
		return DCS_MODULE_NOTEXIST;

	if (pData == NULL )
	{
		DebugString("SupplierManager::HandleFuncRequest parameter is null");
		return DCS_FAIL_OPERATION;
	}
	DebugString("handle func request: module id: %d, func id: %d", moduleID, pData->funcId);
//	if ( pData->funcId <0  || pData->funcId >= MAX_FUNC_ID)
//		return DCS_FUNC_NOTEXIST;   //pm event is also function

	if ( pData->pReturnData == NULL)
	{
		DebugString("SupplierManager::HandleFuncRequest parameter is null");
		return DCS_FAIL_OPERATION;
	}
	if (moduleID == DCS_POLICY) //Policy Control, no need to send to plugin to handle, DCS will directly call Policy to implement
		return HandlePolicy(pData->funcId,  pData->pParams, pData->paramsLen,  pData->pReturnData, &( pData->pReturnDataLen));

//	Lock();
	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
		if (loadedModuleInfo[i].ID == moduleID){
	
				try
				{
					if (loadedModuleInfo[i].funcHandler==NULL)
						throw "Bad Function Handler";
					ret = loadedModuleInfo[i].funcHandler(pData);
				}
				catch(const char* errstr)
				{
					std::cerr << errstr << std::endl;
					DebugString("HandleFuncRequest catch exception: %s", errstr);
					ret = -1;
//					Unlock();
				}
//				Unlock();
				return ret;
		}
//	Unlock();
		return DCS_MODULE_NOTEXIST;
}

int SupplierManager::RemoveClient(DCS_Socket clifd)
{
	Lock();
	try {
	map<DCS_Socket, int >::iterator iter;
	for (int i=0; i<loadedModuleNum && i<MAX_MODULE_NUM; i++)
	{		
		iter = loadedModuleInfo[i].clientRegisteredEventTbl.find(clifd);
		if(iter != loadedModuleInfo[i].clientRegisteredEventTbl.end())//this client registered events
			loadedModuleInfo[i].clientRegisteredEventTbl.erase(clifd);
	}
	} catch (...) {
		DebugString("RemoveClient catch exception");
	}
	Unlock();
	return 0;
}


#ifdef _WIN32
int SupplierManager::Lock()
{
    WaitForSingleObject(m_hMutex, INFINITE);
	return 0;
}

int SupplierManager::Unlock()
{
	// ͷŻ
    ReleaseMutex(m_hMutex);

	return 0;
}
#else

static pthread_mutex_t EventMappingMutex= PTHREAD_MUTEX_INITIALIZER;

int SupplierManager::Lock()
{   
	pthread_mutex_lock(&EventMappingMutex);
	return 0;
}

int SupplierManager::Unlock()
{
	// release the mutex object
	pthread_mutex_unlock(&EventMappingMutex);

	return 0;
}
#endif
