/****************************************************************************
Copyright (c) 2008 Intel Corporation.  All rights reserved. 

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS. 
****************************************************************************/
/**
 * @file VKbdHelper.h
 */

#ifndef VKBD_HELPER_H
#define VKBD_HELPER_H

#include <set>
#include "plugins/DcsPlugin.h"
#include "plugins/vkbd/VKbdDef.h"
#include "plugins/vkbd/VKbdPlugin.h"
#include "virkbdio.h"

/**
 * @class VKbdHelper
 * @brief VKbdHelper provides help on operating VirKbd driver.
 *
 * It is implemented as a singleton.
 */

class VKbdHelper
{
public:
	static VKbdHelper &GetInstance()
	{
		static VKbdHelper helper;
		return helper;
	};
	int Initialize(DCS_Funcs *pDispatcher);
	DCS_Return_Code HandleRequest(DCS_RequestData *pRequest);
	int DestroyClient(int cliId);
	int Cleanup();

private:
	VKbdHelper(void)
		: m_pFuncs(NULL), m_hEvent(NULL), m_hThread(NULL), m_hDevice(NULL)
	{
		InitializeCriticalSection(&m_UserIdLock);
	};	
	~VKbdHelper(void)
	{
		DeleteCriticalSection(&m_UserIdLock);
	};
	BOOL StartVKbd();
	BOOL StopVKbd();
	BOOL SetVKbdEvent();
	BOOL GetVKbdData(int &data);
	void AddUserId(const int &userId)
	{
		LockHelper helper(m_UserIdLock);
		m_ClientIdSet.insert(userId);
	};
	void EmptyUserId()
	{
		LockHelper helper(m_UserIdLock);
		m_ClientIdSet.clear();
	};
	void RemoveUserId(const int &userId)
	{
		LockHelper helper(m_UserIdLock);
		m_ClientIdSet.erase(userId);
	};
	BOOL IsUserIdEmpty()
	{
		LockHelper helper(m_UserIdLock);
		return m_ClientIdSet.empty();
	};
	VKbdHelper(const VKbdHelper &);
	VKbdHelper &operator =(const VKbdHelper &);
	friend DWORD WINAPI pressFn10Proc(LPVOID lpParameter);
	friend DWORD WINAPI pressFn11Proc(LPVOID lpParameter);
	friend DWORD WINAPI clickKeyProc(LPVOID lpParameter);
	friend DWORD WINAPI VKbdEventHandler(LPVOID lpParameter);
	void CloseHandles();

	DCS_Funcs *m_pFuncs;
	std::set<int> m_ClientIdSet;
	static const char * const MODULE_NAME;
	static const wchar_t * const EVENT_NAME;
	static const wchar_t * const STARTEVT_NAME;
	static const wchar_t * const ENDEVT_NAME;
	HANDLE m_hEndEvt;
	HANDLE m_hEvent;
	HANDLE m_hThread;
	HANDLE m_hDevice;
	int m_iKeyData;
	bool m_bFlag;
	int m_iCount;
	int m_iClkNum;
	CRITICAL_SECTION m_UserIdLock;
	
	class LockHelper
	{
	public:
		LockHelper(CRITICAL_SECTION &lock)
			: m_Lock(lock)
		{
			EnterCriticalSection(&m_Lock);
		};

		~LockHelper()
		{
			LeaveCriticalSection(&m_Lock);
		};

	private:
		CRITICAL_SECTION &m_Lock;
	};
};

#endif /** VKBD_HELPER_H */
