/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "PolicyApi.h"
#include "ConnMgmt.h"
#include "ReqMgmt.h"
extern int DCS_WaitResponse(DCS_Response* pResponse, int, int);
extern DCS_Return_Code DCS_DispatchEvent();
extern int DCS_Lock();
extern int DCS_Unlock();


static int GetModuleID()
{
	return DCS_POLICY;
}
DCS_Return_Code DCS_SetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access access)
{
	DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	DCS_Policy_Data policy_data;
	policy_data.userGroup=userGroup;
	policy_data.moduleId=moduleId;
	policy_data.opId=opId;
	policy_data.access=access;

	pReqMgmt->GenFuncReq(GetModuleID(),POLICY_SET, sizeof(DCS_Policy_Data), &policy_data);
	
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), POLICY_SET);
	
//release one lock	
    DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_GetPolicy(DCS_UserGroup userGroup, int moduleId, int opId, DCS_Policy_Access* access)
{
	DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	DCS_Policy_Data policy_data;
	policy_data.userGroup=userGroup;
	policy_data.moduleId=moduleId;
	policy_data.opId=opId;

	pReqMgmt->GenFuncReq(GetModuleID(),POLICY_GET, sizeof(DCS_Policy_Data), &policy_data);
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), POLICY_GET);
	
	if ( response.returnCode == DCS_SUCCESS)
		if (response.data != NULL)// && response.dataLen == sizeof (  DCS_Policy_Access))
			*access = *((DCS_Policy_Access* )response.data);
	if (response.data != NULL )
	{
		delete[] response.data;
		response.data=NULL;
	}
	//release one lock	
    DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_RemovePolicy(DCS_UserGroup userGroup, int moduleId, int op_id)
{
	DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();
	DCS_Response response;
	DCS_Policy_Data policy_data;
	policy_data.userGroup=userGroup;
	policy_data.moduleId=moduleId;
	policy_data.opId=op_id;

	pReqMgmt->GenFuncReq(GetModuleID(),POLICY_REMOVE, sizeof(DCS_Policy_Data), &policy_data);
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), POLICY_REMOVE);
	
//release one lock	
    DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_SetDefaultPolicy(DCS_Policy_Access access)
{
	DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	DCS_Response response;

	pReqMgmt->GenFuncReq(GetModuleID(),POLICY_SET_DEFAULT, sizeof(DCS_Policy_Access), &access);
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), POLICY_SET_DEFAULT);
	
//release one lock	
    DCS_Unlock();
	return response.returnCode;
}

DCS_Return_Code DCS_SavePolicy()
{
	DCS_Lock();
	ReqMgmt* pReqMgmt = ReqMgmt::Instance();

	DCS_Response response;

	pReqMgmt->GenFuncReq(GetModuleID(),POLICY_SAVE, 0, NULL);
	memset(&response, 0, sizeof(response));
	DCS_DispatchEvent();
	
	DCS_WaitResponse(&response, GetModuleID(), POLICY_SAVE);
	
//release one lock	
    DCS_Unlock();
	return response.returnCode;
}

