/*
 * Debug Printer
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * @file DbgPrint.h
 *
 * Definition a function DbgPrint to print log using syslog
 */

#ifndef DBG_PRINT_H
#define DBG_PRINT_H

#include <syslog.h>

#ifdef _DEBUG
#define DbgPrint(format, arg...) \
	syslog(LOG_DEBUG, "%s " format, __func__, ##arg)
#else
#define DbgPrint(format, arg...)
#endif

#endif /* DBG_PRINT_H */

