/*
 * Display Toggle for Linux
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * @file main.cpp
 *
 * main
 */

#include <string.h>
#include "DisplayToggle.h"

int main(int argc, char *argv[])
{
	DisplayToggle toggle;
	const char *TOGGLE = "Toggle";
	const char *INTERLNAL = "Internal";
	const char *EXTERNAL = "External";
	const char *DUAL = "Dual";

	if (2 == argc) {
		if (0 == strncmp(TOGGLE, argv[1], strlen(TOGGLE))) {
			return toggle.ToggleDisplay();
		} else if (0 == strncmp(INTERLNAL, argv[1], strlen(INTERLNAL))) {
			return toggle.SetDisplayStatus(DisplayToggle::DISPLAY_INTERNAL,
				toggle.GetDisplayStatus());
		} else if (0 == strncmp(EXTERNAL, argv[1], strlen(EXTERNAL))) {
			return toggle.SetDisplayStatus(DisplayToggle::DISPLAY_EXTERNAL,
				toggle.GetDisplayStatus());
		} else if (0 == strncmp(DUAL, argv[1], strlen(DUAL))) {
			return toggle.SetDisplayStatus(DisplayToggle::DISPLAY_DUAL,
				toggle.GetDisplayStatus());
		}
	}

	return toggle.GetDisplayStatus();
}
