/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include "FnKeyMon.h"
#include "OnScrDsp.h"

FILE *fil_fnkey;
FnKeyMon mon;
char lck[MAX_PATH];

void CALLBACK DcsAbrHnd()
{
	DCS_Uninitialize();

	while (DCS_SUCCESS != DCS_Initialize()) {
		DbgPrint("DCS_Initialize failed, wait for 3 second to reconnect\n");
		sleep(3);
	}

	/* register callbacks again */
	DCS_SetAbortHandler(DcsAbrHnd);
	DCS_RegisterFnKeyCallback(&mon.FnKeyCb);
	DCS_RegisterLCDBrightnessChangedCallback(&mon.BrgChnCb);
	DCS_RegisterWLanChangedCallback(&mon.WrlChnCb);
}

void DelPip(int sgn)
{
	/* ignore all other signals */
	if ((SIGHUP == sgn) || (SIGINT == sgn) || (SIGQUIT == sgn) ||
		(SIGILL == sgn) || (SIGABRT == sgn) || (SIGSEGV == sgn) ||
		(SIGTERM == sgn) || (SIGTSTP == sgn) || (SIGPIPE == sgn)) {
		char buf[MAX_PATH + 10];
		DbgPrint("signal %d received and delete pipe file\n", sgn);
		strcpy(buf, "rm -f ");
		strncat(buf, lck, MAX_PATH + 10);
		system(buf);
		exit(1);
	}
}

int main(int argc, char* argv[])
{
	int rsl = 0;
	uid_t uid;
	struct passwd *user;
	pthread_t thr; /* id of XKB working thread */

	DbgOpen();

	/* install signal handlers to delete named pipe file */
	if ((SIG_ERR == signal(SIGHUP, DelPip)) ||
		(SIG_ERR == signal(SIGINT, DelPip)) ||
		(SIG_ERR == signal(SIGQUIT, DelPip)) ||
		(SIG_ERR == signal(SIGILL, DelPip)) ||
		(SIG_ERR == signal(SIGABRT, DelPip)) ||
		(SIG_ERR == signal(SIGFPE, DelPip)) ||
		(SIG_ERR == signal(SIGSEGV, DelPip)) ||
		(SIG_ERR == signal(SIGPIPE, DelPip)) ||
		(SIG_ERR == signal(SIGALRM, DelPip)) ||
		(SIG_ERR == signal(SIGTERM, DelPip)) ||
		(SIG_ERR == signal(SIGUSR1, DelPip)) ||
		(SIG_ERR == signal(SIGUSR2, DelPip)) ||
		(SIG_ERR == signal(SIGTSTP, DelPip)) ||
		(SIG_ERR == signal(SIGTTIN, DelPip)) ||
		(SIG_ERR == signal(SIGTTOU, DelPip))) {
		DbgPrint("Install signal handlers failed\n");
		return 1;
	}
	
	/* get user's home direct */
	uid = getuid();
	user = getpwuid(uid);
	if (NULL == user) {
		DbgPrint("can't find the current user!\n");
		return 1;
	}

	strcpy(lck, "/var/lock/FnKeyMonLock_");
	strncat(lck, user->pw_name, MAX_PATH);

	/* use named pipe to exclude FnKeyMon process to one for one user */
	rsl = mkfifo(lck, S_IRUSR | S_IWUSR);
	if (0 != rsl) {
		DbgPrint("the named pipe %s already exists!\n", lck);
		return 1;
	}

	g_thread_init(NULL);
	gdk_threads_init();
	gtk_init(&argc, &argv);

	/* Initialize widget, images etc. */
	OnScrDsp::GetIns();

	/* initialize DCS SDK */
	while (DCS_SUCCESS != DCS_Initialize()) {
		DbgPrint("DCS_Initialize failed, wait for 3 second to reconnect\n");
		sleep(3);
	}

	/* Initialize FnKeyMon for real. It only needs to call once even DCS
	 * connection aborted for now.
	 */
	mon.Init();

	/* register brightness changed callback */
	rsl = DCS_RegisterLCDBrightnessChangedCallback(&mon.BrgChnCb);
	if (DCS_SUCCESS != rsl) {
		DbgPrint("DCS_RegisterLCDBrightnessChangedCallback failed\n");
		return rsl;
	}

	/* register WLAN changed callback */
	rsl = DCS_RegisterWLanChangedCallback(&mon.WrlChnCb);
	if (DCS_SUCCESS != rsl) {
		DbgPrint("DCS_RegisterWLanChangedCallback failed\n");
		return rsl;
	}

	/* register function key callback */
	rsl = DCS_RegisterFnKeyCallback(&mon.FnKeyCb);
	if (DCS_SUCCESS != rsl) {
		DbgPrint("DCS_RegisterFnKeyCallback failed\n");
		return rsl;
	}

	/* handle connection abort event from DCS */
	rsl = DCS_SetAbortHandler(DcsAbrHnd);
	if (DCS_SUCCESS != rsl) {
		DbgPrint("DCS_SetAbortHandler failed\n");
		return rsl;
	}

	/* create a work thread for XKB event loop */
	if (pthread_create(&thr, NULL, XkbWrk, &mon)) {
		return 1;
	}

	gdk_threads_enter();
	while (1) {
		gtk_main();
		DbgPrint("gtk_main quit! Wait for 3 second to restart\n");
		sleep(3);
	}
	gdk_threads_leave();

	return DCS_Uninitialize(); /* should never return since it always runs */
}
