#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include <pthread.h>
#include <unistd.h>
#include <fcntl.h>
typedef int BOOL;
#define TRUE 1
#define FALSE 0
static BOOL hiddenCursor=TRUE;
char* TSC_CFG_PATH = "/etc/dcs/";
#define CFG_FILE "TSController.cfg"
#define MAX_PATH 256
extern int Ini_WriteString(char *Section, char *Ident, char *Value, char *FileName);
extern int Ini_ReadString(char *Section, char *Ident, char *Default, char *ret, char *FileName);
BOOL GetCursorStatus();

BOOL CheckMouse()
{//check if the usb mouse is plugined
	int ret = 0;
	ret = system("/usr/bin/dcs/checkmouse.sh");
//	printf("ret = %d\n", ret);
	if (ret > 0)//have mouse
		return TRUE;
	else // no mouse
		return FALSE;

}

void HideCursor()
{
	BOOL ret = CheckMouse();
	if (ret)  //mouse exists, don't hide
		return;
	system("/usr/bin/dcs/hidecursor.sh");
}

void ShowCursor()
{
	system("/usr/bin/dcs/showcursor.sh");
}
BOOL GetCursorStatus()
{
	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);

	if (access(CFG_FILE,0) ==0 ) //file exist
	{
		Ini_ReadString("TSController","HideCursor","",str_tmp,CFG_FILE);
	}
	
	if (!(strcmp(str_tmp,"FALSE")))
	{
		hiddenCursor = FALSE;
		return FALSE;
	}
	
	hiddenCursor = TRUE;

	return TRUE;
}

int SetCursorStatus(BOOL bStatus)
{
	if (access(TSC_CFG_PATH,F_OK) < 0) // dir not exist
	{	
		return -1;
	}
	hiddenCursor = bStatus;

	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);
	strcpy(str_tmp,TSC_CFG_PATH);
	strcat(str_tmp,CFG_FILE);

	FILE* file;
	if ( (file=fopen(str_tmp,"w+")) != NULL )
	{
		if (hiddenCursor==TRUE)
			Ini_WriteString("TSController","HideCursor","TRUE",str_tmp);
		else
			Ini_WriteString("TSController","HideCursor","FALSE",str_tmp);
	}
	fclose(file);

	return 0;
}

int main(int argc, char* argv[])
{
	int ret = 0;

	if (argc <= 1)
		return -1;
	
	if (strcmp(argv[1], "TRUE")== 0)
	{
		SetCursorStatus(TRUE);
		HideCursor();
	}
	else
	{
	 	SetCursorStatus(FALSE);
		ShowCursor();
	}
	return 0;
}
