/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "AboutDialog.h"

#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/string.h>

#include "ENMApp.h"
#include "pic/enm_about.xpm"

const int AboutDialog::ID_BTN_OK = ::wxNewId();

//declare event table
BEGIN_EVENT_TABLE(AboutDialog,wxDialog)
    EVT_BUTTON(ID_BTN_OK, AboutDialog::OnButtonOKClick)
END_EVENT_TABLE()

/**************************************************************************************************
* Function Name : AboutDialog                                                                     *
* Description  : Constructor                                                                      *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
AboutDialog::AboutDialog(wxWindow* parent, wxWindowID id)
        : wxDialog(parent, id, _("Easy Network"))
{
	SetClientSize(wxSize(350,230));
    wxBitmap background(wxImage(::wxGetApp().strImagePath + _T("about_bg_with_icon.png")));
	m_bmpBackground = new wxStaticBitmap(this, wxID_ANY, background);
	m_stxModuleName = new wxStaticText(this, wxID_ANY,_("Easy Network"), wxPoint(92,70), wxSize(200, 20));
	wxFont stxModuleNameFont(10, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, wxEmptyString, wxFONTENCODING_DEFAULT);
	m_stxModuleName->SetFont(stxModuleNameFont);
	m_stxVersion = new wxStaticText(this, wxID_ANY, _("Version 2.0.0.110"), wxPoint(92,90));
	m_stxCopyright = new wxStaticText(this, wxID_ANY, _("Copyright(c) 2008 Intel Corporation."), wxPoint(92,130));
	m_stxRight = new wxStaticText(this, wxID_ANY, _("All rights reserved."), wxPoint(92,150));
#if defined(__WXMSW__)
	m_btnOK = new wxButton(m_bmpBackground, ID_BTN_OK, _("OK"), wxPoint(252,196), wxSize(70,25));
#endif
#if defined(__UNIX__)
    m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(252,191), wxSize(80,30));
#endif
	m_btnOK->SetDefault();
	Center();

	wxIcon icon_about(enm_about_xpm);
    SetIcon(icon_about);
}

/**************************************************************************************************
* Function Name : ~AboutDialog                                                                     *
* Description  : Destructor                                                                      *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
AboutDialog::~AboutDialog()
{
}

/**************************************************************************************************
* Function Name : OnButtonOKClick                                                                     *
* Description  : Active when click OK button                                                                      *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void AboutDialog::OnButtonOKClick(wxCommandEvent& event)
{
    Close();
}
