/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "ENMTaskTray.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "WirelessScanner.h"
#include <iostream>
#include <fstream>
#include <string>
#include <linux/types.h>
#include <linux/wireless.h>
#include <linux/ethtool.h>
#include <linux/sockios.h>
#include <errno.h>
#include "DataCenterLinux.h"
#include "ENMUtil.h"
#include "SwitchAdapterEvent.h"
#include <wx/longlong.h>
#include <wx/timer.h>
#include "ScanEvent.h"
#include "ProfileManagementControl.h"
#include <sdk/PMApi.h>
#include <wx/file.h>
#include <wx/filefn.h>
using namespace std;

static wxString logFile(::wxGetHomeDir() + _T("/DataCenterLinux.log"));
//static wxString logFile(_T("/tmp/DataCenterLinux.log"));

const long DataCenterLinux::ID_TIMER_READNETWORKSTATUS = wxNewId();
const long DataCenterLinux::ID_TIMER_SCAN = wxNewId();
const long DataCenterLinux::ID_TIMER_ALLOCATE = wxNewId();
const long DataCenterLinux::ID_TIMER_WPA = wxNewId();
const long DataCenterLinux::ID_TIMER_SUSPEND = wxNewId();
const long DataCenterLinux::ID_TIMER_SWITCHUSER = wxNewId();
const long DataCenterLinux::ID_TIMER_STARTTIMERAFTERRESUME = wxNewId();
const long DataCenterLinux::ID_TIMER_WAITFORRESUME = wxNewId();
const int NETSTATUS_TIMERINTERVAL = 10000 ;
const int ALLOCATE_TIMERINTERVAL = 10000 ;
const int TIMER_SCAN_DELAY = 6000 ;
const int WPA_DELAY = 20000;
const int SUSPENDPERIOD = 2000;
const int SWITCHUSERPERIOD = 1000;
const int STARTTIMERAFTERRESUME = 6000 ;
const wxString g_path = ENMUtil::GetCurrentUserAppDataFolder();
//const int FILESIZE = 1024;
//const int ORDERBUFSIZE = 128;
BEGIN_EVENT_TABLE(DataCenterLinux, wxEvtHandler)
    EVT_TIMER(ID_TIMER_READNETWORKSTATUS, DataCenterLinux::OnReadNetworkStatusTimer)
    EVT_TIMER(ID_TIMER_SCAN, DataCenterLinux::OnScanTimer)
    EVT_TIMER(ID_TIMER_ALLOCATE, DataCenterLinux::OnAllocatorTimer)
    EVT_TIMER(ID_TIMER_WPA, DataCenterLinux::OnWpaTimer)
    EVT_TIMER(ID_TIMER_SUSPEND, DataCenterLinux::OnSusPendTimer)
    EVT_TIMER(ID_TIMER_SWITCHUSER, DataCenterLinux::OnSwitchUserTimer)
    EVT_TIMER(ID_TIMER_STARTTIMERAFTERRESUME, DataCenterLinux::OnStartTimerAfterResume)
    EVT_TIMER(ID_TIMER_WAITFORRESUME, DataCenterLinux::OnWaitForResume)
    EVT_SCAN(ID_SCAN_OVER, DataCenterLinux::SearchAP)
END_EVENT_TABLE()

DataCenterLinux::DataCenterLinux()
{
     m_pAPStatus = NULL;
     m_pNetworkInfo = NULL;
     m_pCurrentWiredStatus = NULL;
     m_LastNetworkMode = NETWORK_MODE_DEFAULT ;
     m_CurrentNetworkMode = NETWORK_MODE_DEFAULT ;

     m_apList.nCount = 0;

     memset(m_apList.apList, 0, sizeof(m_apList.apList));

     m_pLinuxWlanScanner = NULL;

     m_isApplyProfile = false;

     m_isShowWiredLANDlg = false;
     m_isShowWirelessLANDlg = false;
     m_VerifyWiredConnected = 0;
     m_isAutoWireless = false;
     m_isShowWirelessOnOffDlg = false;
     m_isNetworkDlgTurnWireless = true;
     m_postEvent = false;

     m_pScanThread = NULL;

}

DataCenterLinux::~DataCenterLinux()
{
    DestroyData();
    if( !m_pScanThread)
    {
        delete m_pScanThread;
        m_pScanThread = NULL ;
    }
}

void DataCenterLinux::InitData()
{
    DCS_RegisterLanChangedCallback(LanChangeCallBack);
    DCS_RegisterWLanChangedCallback(WlanChangeCallBack);
    DCS_RegisterDownInterfaceCallback(DisableAdapterCallBack);
    DataCenter::InitData();

    CreateNetTools();

    GetNetInfo();

    //DisableAllAdapters();

    m_NetStatusTimer.SetOwner(this, ID_TIMER_READNETWORKSTATUS);

    //m_NetStatusTimer.Start(NETSTATUS_TIMERINTERVAL);

    m_ScanTimer.SetOwner(this, ID_TIMER_SCAN);

    m_AlllcatorTimer.SetOwner(this, ID_TIMER_ALLOCATE);
    m_WaitForResume.SetOwner(this, ID_TIMER_WAITFORRESUME);

    m_WpaTimer.SetOwner(this, ID_TIMER_WPA);
    ENMUtil::Log(logFile, _T("m_SuspendTimer start begin"));
    m_SuspendTimer.SetOwner(this, ID_TIMER_SUSPEND);
    m_SuspendTimer.Start(SUSPENDPERIOD);
    m_iWaitForResume = 0;
    ENMUtil::Log(logFile, _T("m_SuspendTimer start end"));
//    m_StartTimerAfterResume.SetOwner(this, ID_TIMER_STARTTIMERAFTERRESUME);
//    m_SwitchTimer.SetOwner(this, ID_TIMER_SWITCHUSER);
//    m_SwitchTimer.Start(SWITCHUSERPERIOD);
//    m_switchUser = false;

//    if ( outputFile.Exists() )
//    {
//        outputFile.Open(_T("/tmp/syspend.out"));
//    }
//    else
//    {
//        outputFile.Create(_T("/tmp/syspend.out"));
//    }
//    outputFile.Clear();

    m_pSwitchAdapterThread = new SwitchAdapterThread(this);
    if ( m_pSwitchAdapterThread->Create() == wxTHREAD_NO_ERROR )
    {
        m_pSwitchAdapterThread->Run();
    }

    m_pGetCurAPThread = new GetCurAPThread(this);
    if ( m_pGetCurAPThread->Create() == wxTHREAD_NO_ERROR )
    {
        m_pGetCurAPThread->Run();
    }

    times = 0;

    m_killDhclientCount = 0;

//    ReadNetworkStatus();

}
bool DataCenterLinux::IfConnect()
{
    BOOL existWirelessAdalpter;
    DCS_IsExistAdapter(DCS_ADAPTER_WIREDLESS, &existWirelessAdalpter);
    if ( !existWirelessAdalpter )
    {
        return false;
    }
    ENM_String* IP = new ENM_String();
    memset(IP, 0, sizeof(ENM_String));
    DCS_GetIPAddressLAN(IP);
    string strIP((const char*)IP->dcsString);
//    string strIP = GetIPAddressHLAN(m_UsingWirelessAdpterName, ENMUtil::WxStringToString(g_path));
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), wxT("ip is ") + wxString::FromUTF8(strIP.c_str()));
    if ( (strIP == "127.0.0.1") || (strIP.empty()) )
    {
        return false;
    }
    else
    {
        return true;
    }
//    sockfd = socket(PF_INET,SOCK_DGRAM,0);
//    strncpy(ifr.ifr_name,m_UsingWirelessAdpterName.c_str(),IFNAMSIZ);
//
//    if(ioctl(sockfd,SIOCGIFADDR,&ifr) == -1)
//    {
//        perror("ioctl error");
//        close(sockfd);
//        return false;
//    }
//    else
//    {
//        close(sockfd);
//        addr = (struct sockaddr_in *)&(ifr.ifr_addr);
//        address = inet_ntoa(addr->sin_addr);
//        if (address == NULL)
//        {
//            return false;
//        }
//        else
//        {
//            if (!strcmp(address, "127.0.0.1"))
//            {
//                return false;
//            }
//            else
//            {
//                return true;
//            }
//        }
//    }
}

void DataCenterLinux::OnAllocatorTimer(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer"));
//    if( times < 10 )
//    {
//        times++;
//    }
//    else
//    {
        if ( times < 4 )
        {
            if ( IfConnect() )
            {
                ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--success begin"));
                times = 0;
                WirelessSwitchEvent switchAPevent;
                if( m_pAPStatus != NULL )
                {
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--SetOldSsid begin"));
                    switchAPevent.SetOldSsid(m_pAPStatus->ssid);
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--SetOldSsid end"));
                }
                if( m_pAPStatus )
                {
                    DCS_GetCurrentAP(m_pAPStatus);
//                   SetSsid(*m_pAPStatus);
//                   m_pLinuxWlanScanner->UpdateCurrentAP(*m_pAPStatus);
    //                UpdateCurrentAP(&m_pAPStatus->ssid, true);
                }
                if( m_pAPStatus != NULL )
                {
                    switchAPevent.SetNewSsid(m_pAPStatus->ssid);
                    ::wxPostEvent(GetProfileController(), switchAPevent);
                    ::wxPostEvent(GetNetworkManagerDlgHandle(), switchAPevent);
                    ::wxPostEvent(ENMTaskTray::GetInstance(), switchAPevent);
                }
                WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_SUCCESS);
                if ( m_isApplyProfile )
                {
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--post event to profilecontroller begin"));
                    ::wxPostEvent(this->GetProfileController(), event);
                    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--post event to profilecontroller end"));
                }
                else
                {
                    ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
                }
                m_AlllcatorTimer.Stop();

                ENM_String* sKill = new ENM_String();
                memset(sKill, 0, sizeof(ENM_String));
                strcpy((char*)sKill->dcsString, "killall");
                DCS_WriteFile(sKill);
//                StartGlobalTimer();
                ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--success end"));
            }
            else
            {
                times++;
            }
        }
        else
        {
            ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--failure begin"));
            times = 0;
            ENM_String* sKill = new ENM_String();
            memset(sKill, 0, sizeof(ENM_String));
            strcpy((char*)sKill->dcsString, "killall");
            DCS_WriteFile(sKill);

            if( m_pAPStatus )
            {
                delete m_pAPStatus;
                m_pAPStatus = NULL;
                //UpdateCurrentAP(&m_pAPStatus->ssid, false);
            }

            WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);

            if ( m_isApplyProfile )
            {
                ::wxPostEvent(this->GetProfileController(), event);
            }
            else
            {
                ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
            }

            m_AlllcatorTimer.Stop();
//            StartGlobalTimer();
            ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnAllocatorTimer--failure end"));
        }
        ENMUtil::Log(logFile, _T("Leave DataCenterLinux::OnAllocatorTimer"));
//    }

}
string DataCenterLinux::GetIPAddressHLAN(const string adapterName, const string userPath)
{
//    char cOrder[ORDERBUFSIZE];
//    sprintf(cOrder, "ifconfig %s > ~/ifc.txt", adapterName.c_str());
//    system(cOrder);
//    ifstream in;
//    string sPath = userPath + "/ifc.txt";
//    const char* cFileName = sPath.c_str();
//    in.open(cFileName,ios_base::in);
//    char cFileBuf[1024];
//    wxString IP;
//    while(in.getline(cFileBuf, sizeof(cFileBuf)))
//    {
//        wxString content = wxString::FromUTF8(cFileBuf);
//        if ((int) content.find(wxT("inet addr:")) > 0)
//        {
//            size_t posBegin = content.Find(wxT("inet addr:")) + 10;
//            size_t posEnd = content.Find(wxT("Bcast:")) - 1;
//            int len = posEnd - posBegin;
//            IP = content.Mid(posBegin, len);
//            break;
//        }
//    }
//    in.close();

    ENM_String* EnmIP = new ENM_String();
    memset(EnmIP, 0, sizeof(ENM_String));
    DCS_GetIPAddressLAN(EnmIP);
    wxString IP = ENMUtil::StringToWxString(string((const char*)EnmIP->dcsString));
	if ( !IP.Cmp(_T("127.0.0.1")) )
    {
        IP = _("Acquiring Network Address");
    }

    return ENMUtil::WxStringToString(IP);

}

wxString DataCenterLinux::GetConnectTypeHLAN()
{
    string strType = GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path));
    wxString strLan;
    if ( strType == "Wired LAN - 10Mbps" )
    {
        strLan = _("Wired LAN - 10Mbps");
    }
    else
    {
        strLan = _("Wired LAN - 100Mbps");
    }
    return strLan;
}

string DataCenterLinux::GetConnectTypeHLAN(const string adapterName, const string userPath)
{
//    char cOrder[ORDERBUFSIZE];
//    sprintf(cOrder, "ethtool %s > ~/eth.txt", adapterName.c_str());
//    system(cOrder);
//    ifstream in;
//    string sPath = userPath + "/eth.txt";
//    const char* cFileName = sPath.c_str();
//    in.open(cFileName,ios_base::in);
//    char cFileBuf[1024];
//    wxString speed;
//    string strType;
//    while(in.getline(cFileBuf, sizeof(cFileBuf)))
//    {
//        wxString content = wxString::FromUTF8(cFileBuf);
//        if ((int) content.find(wxT("Speed:")) > 0)
//        {
//            size_t posBegin = content.Find(wxT("Speed:")) + 7;
//            speed = content.Mid(posBegin);
//            strType = "Wired LAN -" + ENMUtil::WxStringToString(speed);
//            break;
//        }
//    }
//    in.close();

    ENM_String* type = new ENM_String();
    memset(type, 0, sizeof(ENM_String));
    DCS_GetConnectTypeLAN(type);
    string strType((const char*)type->dcsString);

    return strType;
}

void DataCenterLinux::DestroyData()
{

    m_NetStatusTimer.Stop();

    if ( NULL !=  m_pNetworkInfo )
    {
         delete m_pNetworkInfo ;
         m_pNetworkInfo = NULL;
    }

    if ( NULL !=  m_pCurrentWiredStatus )
    {
         delete m_pCurrentWiredStatus ;
         m_pCurrentWiredStatus = NULL;
    }

    if ( NULL !=  m_pLinuxWlanScanner )
    {
         delete m_pLinuxWlanScanner ;
         m_pLinuxWlanScanner = NULL;
    }

    if ( NULL !=  m_pSsid )
    {
         delete m_pSsid ;
         m_pSsid = NULL;
    }

}

void DataCenterLinux::CreateNetTools()
{
    if ( NULL == m_pNetworkInfo )
    {
        m_pNetworkInfo = new NETWORK_INFO();
    }

    if ( NULL == m_pCurrentWiredStatus )
    {
        m_pCurrentWiredStatus = new NETWORK_WIRED_STATUS_INFO();
    }

    if ( NULL == m_pLinuxWlanScanner )
    {
        m_pLinuxWlanScanner = new WirelessScanner();
    }

}

void DataCenterLinux::ReadNetworkStatus()
{
    GetNetInfo();

//    bool wiredAdapterIsUp = IfUp(ADAPTER_WIRED);
//
//    if ( !wiredAdapterIsUp )
//    {
//        m_pNetworkInfo->isWiredLANEnabled = false;
//    }
//    else
//    {
//        m_pNetworkInfo->isWiredLANEnabled = true;
//    }
//
//    bool wirelessAdapterIsUp = IfUp(ADAPTER_WIREDLESS);
//
//    if ( !wirelessAdapterIsUp )
//    {
//        m_pNetworkInfo->isWirelessEnabled = false;
//    }
//    else
//    {
//        m_pNetworkInfo->isWirelessEnabled = true;
//    }
//
//    if ( m_pNetworkInfo->isWiredLANEnabled )
//    {
//        m_pNetworkInfo->isWiredLANConnected = IfLink(ADAPTER_WIRED, m_UsingWiredAdpterName);
//    }
//    else
//    {
//        m_pNetworkInfo->isWiredLANConnected = false;
//    }
//
//    if ( m_pNetworkInfo->isWirelessEnabled )
//    {
//        m_pNetworkInfo->isWirelessConnected = IfLink(ADAPTER_WIREDLESS, m_UsingWirelessAdpterName);
//    }
//    else
//    {
//        m_pNetworkInfo->isWirelessConnected = false;
//    }
//
//    SetCurrentNetworkMode(*m_pNetworkInfo);

    if ( m_LastNetworkMode == NETWORK_MODE_DEFAULT )
    {
        BOOL IfWiredEnable;
        DCS_GetLANStatus(&IfWiredEnable);
        if ( IfWiredEnable )
        {
            m_LanIsEnable = true;
        }
        else
        {
            m_LanIsEnable = false;
        }
        BOOL IfWirelessEnable;
        DCS_GetWirelessStatus(&IfWirelessEnable);
        if ( IfWirelessEnable )
        {
            m_WlanIsEnable = true;
        }
        else
        {
            m_WlanIsEnable = false;
        }
    }

    if ( m_LanIsEnable )
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wired enabled"));
        m_pNetworkInfo->isWiredLANEnabled = IfUp(ADAPTER_WIRED);
        if ( m_pNetworkInfo->isWiredLANEnabled )
        {
            m_pNetworkInfo->isWiredLANConnected = IfLink(ADAPTER_WIRED, m_UsingWiredAdpterName);
        }
        else
        {
            m_pNetworkInfo->isWiredLANConnected = false;
        }
    }
    else
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wired disabled"));
        m_pNetworkInfo->isWiredLANEnabled = false;
        m_pNetworkInfo->isWiredLANConnected = false;
    }

    if ( m_WlanIsEnable )
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wireless enabled"));
        m_pNetworkInfo->isWirelessEnabled = IfUp(ADAPTER_WIREDLESS);
        if ( m_pNetworkInfo->isWirelessEnabled )
        {
            m_pNetworkInfo->isWirelessConnected = IfLink(ADAPTER_WIREDLESS, m_UsingWirelessAdpterName);
        }
        else
        {
            m_pNetworkInfo->isWirelessConnected = false;
        }
    }
    else
    {
//        ENMUtil::Log(logFile, _T("in ReadNetworkStatus::wireless disabled"));
        m_pNetworkInfo->isWirelessEnabled = false;
        m_pNetworkInfo->isWirelessConnected = false;
    }

    SetCurrentNetworkMode(*m_pNetworkInfo);
}

bool DataCenterLinux::EnableConnection(wxString wszName, bool bEnable)
{
    bool result = false;

    return result;
}
void DataCenterLinux::OnReadNetworkStatusTimer(wxTimerEvent& event)
{
    ReadNetworkStatus();
}
void DataCenterLinux::OnScanTimer(wxTimerEvent& event)
{
//    WlanResult result = DataCenterLinux::SearchAP();

    //UpdateUI

//    if ( m_pScanNetworkDlg )
//        m_pScanNetworkDlg->UI_UpdateAPSatus(result,GetAPList());
}

//wxString DataCenterLinux::GetIPAddressHLAN()
//{
//    struct ifreq* pIfr = m_wiredInfo.GetIfr();
//    return m_wiredInfo.GetAddress(pIfr);
//
//}
//
//wxString DataCenterLinux::GetConnectTypeHLAN()
//{
//    wxString strNetSpeed = wxT("");
//
//    struct ifreq* pIfr = NULL;
//    if( m_pNetworkInfo->isWiredLANConnected )
//    {
//        pIfr = m_wiredInfo.GetIfr();
//
//        strNetSpeed = m_wiredInfo.GetSpeed(pIfr);
//
//    }
//    else{}
//
//    wxString strWiredType = strNetSpeed;
//
//    return strWiredType;
//
//}

NETWORK_MODE DataCenterLinux::GetCurrentNetworkMode()
{
    return m_CurrentNetworkMode;
}

void DataCenterLinux::SetCurrentNetworkMode(NETWORK_INFO& networkInfo)
{
//    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::SetCurrentNetworkMode"));
    bool bWiredEnable = networkInfo.isWiredLANEnabled;
    bool bWirelessEnable = networkInfo.isWirelessEnabled;
    bool bWiredConnected = m_pNetworkInfo->isWiredLANConnected;
    bool bWirelessConnected = m_pNetworkInfo->isWirelessConnected;

    if ( bWiredConnected )
    {
        if ( 3 == m_killDhclientCount )
        {
            ENM_String* sKill = new ENM_String();
            memset(sKill, 0, sizeof(ENM_String));
            strcpy((char*)sKill->dcsString, "killall");
            DCS_WriteFile(sKill);
            m_killDhclientCount = 0;
        }
        else
        {
            m_killDhclientCount++;
        }
    }

    UI_NETWORK_STATUS_INFO  statusInfo;
    statusInfo.IPAddress = _T("");
    statusInfo.SignalQuality = 0;
    statusInfo.Type = _T("");

    if ( bWirelessEnable && !bWiredEnable )
    {
//        if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT )
//        {
//            ENM_String* sKill = new ENM_String();
//            memset(sKill, 0, sizeof(ENM_String));
//            strcpy((char*)sKill->dcsString, "killall");
//            DCS_WriteFile(sKill);
//            m_killDhclientCount = 0;
//        }
        if ( bWirelessConnected )
        {
            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;

            if ( NULL == m_pAPStatus )
            {
                m_pAPStatus = new APStatus();
            }

            if( m_pLinuxWlanScanner )
            {
                GetCurAPParameter();
                statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
            }

            if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
            {
                ENMTaskTray::GetInstance()->StopApplyWirelessDlg();
            }
        }
        else
        {
            if ( NULL != m_pAPStatus )
            {
               delete m_pAPStatus;
               m_pAPStatus = NULL ;
            }
            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
        }

        if ( ENMTaskTray::GetInstance()->GetApplyWirelessFlag() && !m_pNetworkManagerDlg->IsApplyingProfile() )
        {
            if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT || m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_DISCONNECT || m_LastNetworkMode == NETWORK_MODE_DISCONNECTED )
            {
//                if ( !IfUp(ADAPTER_WIRED) && IfUp(ADAPTER_WIREDLESS) )
//                {
                    ENMTaskTray::GetInstance()->SetApplyWirelessFlag(false);
                    ENMTaskTray::GetInstance()->ApplyWirelessProfile();
//                }
            }
        }

    }
    else if( bWiredEnable && !bWirelessEnable )
    {
        if ( bWiredConnected )
        {
            m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_CONNECT;
        }
        else
        {
            m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_DISCONNECT;
            if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT )
            {
                if ( !m_isShowWirelessLANDlg )
                {
                    m_isShowWirelessLANDlg = true;
                    if ( ENMUtil::ShowSwitchWirelessLANDlg() == wxID_OK )
                    {
                        SwitchAdapterParameter(ADAPTER_WIRED,ADAPTER_WIREDLESS,NULL);
                    }
                    m_isShowWirelessLANDlg = false;
                }
            }
        }

        if ( NULL != m_pAPStatus )
        {
           delete m_pAPStatus;
           m_pAPStatus = NULL ;
        }

        m_pCurrentWiredStatus->IPAddress = wxString::FromUTF8(GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str());
        if ( m_pCurrentWiredStatus->IPAddress.IsEmpty() && bWiredConnected && !DataCenter::GetInstance()->GetProfileController()->GetStaticFlag() )
        {
            ENM_String* sDhclient = new ENM_String();
            memset(sDhclient, 0, sizeof(ENM_String));
            strcpy((char*)sDhclient->dcsString, "dhclient");
            DCS_WriteFile(sDhclient);
        }
        m_pCurrentWiredStatus->Type = wxString::FromUTF8(GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str());
        statusInfo = GetWiredUIInfo(*m_pCurrentWiredStatus);
        if ( m_LastNetworkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || m_LastNetworkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT )
        {
            if ( !m_isShowWirelessOnOffDlg )
            {
                m_isShowWirelessOnOffDlg = true;
                ENMUtil::ShowWirelessOnOffDlg(false);
                m_isShowWirelessOnOffDlg = false;
            }
        }
    }
	else if( bWiredEnable && bWirelessEnable )
    {
        if( m_LastNetworkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || m_LastNetworkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT || m_LastNetworkMode == NETWORK_MODE_DEFAULT )
        {
			if ( bWiredConnected )
			{

                if ( m_LastNetworkMode == NETWORK_MODE_DEFAULT )
                {
                    SwitchAdapterParameter(ADAPTER_WIREDLESS, (ADAPTER_TYPE)0, NULL);
                    m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_CONNECT;
                }
                else
                {
                    if ( bWirelessConnected )
                    {
                        m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;

                        // Update AP Status information
                       if( m_pLinuxWlanScanner && m_pAPStatus )
                       {
                            GetCurAPParameter();
                            statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
                       }
                    }
                    else
                    {
                        m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
                    }

                    if ( !m_isShowWiredLANDlg )
                    {
                        m_isShowWiredLANDlg = true;
                        ENMUtil::ShowSwitchWiredLANDlg();
                        m_isShowWiredLANDlg = false;
                    }
                }
			}
			else
			{
                m_VerifyWiredConnected++;

                if ( m_VerifyWiredConnected > 1 )
                {
                    SwitchAdapterParameter(ADAPTER_WIRED, ADAPTER_WIREDLESS, NULL);

                    if ( bWirelessConnected )
                    {
                        m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;
                       if( m_pLinuxWlanScanner && m_pAPStatus )
                       {
                            GetCurAPParameter();
                            statusInfo = GetWirelessedUIInfo(*m_pAPStatus);
                       }
                    }
                    else
                    {
                        m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
                    }
                    m_VerifyWiredConnected = 0;
                }
			}

        }
        else if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT || m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_DISCONNECT  )
        {
            SwitchAdapterParameter(ADAPTER_WIREDLESS, (ADAPTER_TYPE)0, NULL);
            if ( bWiredConnected )
            {
                m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_CONNECT;
            }
            else
            {
                m_CurrentNetworkMode = NETWORK_MODE_WIRED_LAN_DISCONNECT;
            }
            m_pCurrentWiredStatus->IPAddress = wxString::FromUTF8(GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str());
            if ( m_pCurrentWiredStatus->IPAddress.IsEmpty() && bWiredConnected && !DataCenter::GetInstance()->GetProfileController()->GetStaticFlag())
            {
                ENM_String* sDhclient = new ENM_String();
                memset(sDhclient, 0, sizeof(ENM_String));
                strcpy((char*)sDhclient->dcsString, "dhclient");
                DCS_WriteFile(sDhclient);
            }
            m_pCurrentWiredStatus->Type = wxString::FromUTF8(GetConnectTypeHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str());
            statusInfo = GetWiredUIInfo(*m_pCurrentWiredStatus);
        }
        else
        {
        }
    }
    else
    {
        if ( NULL != m_pAPStatus )
        {
           delete m_pAPStatus;
           m_pAPStatus = NULL ;
        }
        m_CurrentNetworkMode = NETWORK_MODE_DISCONNECTED;
        if ( m_LastNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT )
        {
            if ( !m_isShowWirelessLANDlg && m_isNetworkDlgTurnWireless )
            {
                m_isShowWirelessLANDlg = true;
                if ( ENMUtil::ShowSwitchWirelessLANDlg() == wxID_OK )
                {
                    SwitchAdapterParameter(ADAPTER_WIRED, ADAPTER_WIREDLESS, NULL);
                }
                m_isShowWirelessLANDlg = false;
            }
            m_isNetworkDlgTurnWireless = true;
        }
    }

    //Update UI network status information
    if( m_pNetworkManagerDlg )
    {
        m_pNetworkManagerDlg->UI_UpdateNetworkStatusInfo(m_CurrentNetworkMode, statusInfo);
    }

    ENMTaskTray::GetInstance()->SetTaskbarIcon(m_CurrentNetworkMode, statusInfo);

    //Update UI network status
    if( m_LastNetworkMode != m_CurrentNetworkMode || m_CurrentNetworkMode == NETWORK_MODE_DISCONNECTED )
    {
        m_postEvent = false;
		GetProfileController()->NotifyModeChanged(m_CurrentNetworkMode);

        if ( m_pNetworkManagerDlg )
        {
            m_pNetworkManagerDlg->UI_UpdateNetworkMode(m_CurrentNetworkMode);
        }
    }

    m_LastNetworkMode = m_CurrentNetworkMode;

}
WlanResult DataCenterLinux::BeginSearchAP()
{
    if( !m_pScanThread)
    {
        delete m_pScanThread;
        m_pScanThread = NULL ;
    }

    m_pScanThread = new ScanThread(this);
    if ( m_pScanThread->Create() == wxTHREAD_NO_ERROR )
    {
        m_pScanThread->Run();
        return WLAN_SUCCESS;
    }
    else
    {
        return WLAN_ERROR;
    }
}
void DataCenterLinux::SearchAP(ScanEvent& event)
{
    if ( m_apList.nCount != 0 )
    {
        if ( m_pScanNetworkDlg )
        {
            m_pScanNetworkDlg->UI_UpdateAPSatus(WLAN_SUCCESS, m_apList);
        }
    }
}
const APStatus* DataCenterLinux::GetAPStatusFromList(size_t iIndex)
{
//    if( iIndex >=0 && iIndex < m_apList.nCount )
//        return &m_apList.apList[iIndex];
//    else
//        return NULL;
    assert(false);
}
const AccessPointList& DataCenterLinux::GetAPList()
{
//     return m_apList ;
    assert(false);
}
void DataCenterLinux::UpdateCurrentAP(const  WlanSsid* pSsid, bool connected)
{
//   if(connected)
//   {
//       if( !m_pAPStatus)
//         m_pAPStatus = new APStatus() ;
//
//       m_pAPStatus->ssid =  *pSsid ;
//
//        if( m_pLinuxWlanScanner )
//        {
//            m_pLinuxWlanScanner->UpdateCurrentAP(*m_pAPStatus);
//        }
//
//   }
//   else
//   {
//       delete m_pAPStatus;
//       m_pAPStatus = NULL ;
//   }
}
UI_NETWORK_STATUS_INFO DataCenterLinux::GetWirelessedUIInfo(APStatus& apStatus)
{

    UI_NETWORK_STATUS_INFO  uiNetworkStatusInfo;

    //wxString strMac = MacAddressToString(m_apStatus->macAddress);
    uiNetworkStatusInfo.SignalQuality = apStatus.signalQuality;

    switch(apStatus.type)
    {
    case WLAN_802_11_B:
        uiNetworkStatusInfo.Type = _("Wireless LAN - 802.11b - 11Mbps");
        break;
    case WLAN_802_11_G:
        uiNetworkStatusInfo.Type = _("Wireless LAN - 802.11g - 54Mbps");
        break;
    case WLAN_802_11_N:
        uiNetworkStatusInfo.Type = _("Wireless LAN - 802.11n - 108Mbps");
        break;
    default:
        break;
    }
    uiNetworkStatusInfo.IPAddress = ENMUtil::StringToWxString(GetIPAddressHLAN(m_UsingWirelessAdpterName, ENMUtil::WxStringToString(g_path)));
    return uiNetworkStatusInfo;
}
UI_NETWORK_STATUS_INFO DataCenterLinux::GetWiredUIInfo( NETWORK_WIRED_STATUS_INFO& wiredStatus)
{

    UI_NETWORK_STATUS_INFO  uiNetworkStatusInfo;

    uiNetworkStatusInfo.SignalQuality = -1;
    uiNetworkStatusInfo.IPAddress = wiredStatus.IPAddress;
    uiNetworkStatusInfo.Type = wiredStatus.Type;

    return uiNetworkStatusInfo;
}
bool DataCenterLinux::EnableNetworkAdapter(ADAPTER_TYPE adapterType,bool bEnable)
{
    BOOL existUpAdapter;
    if ( bEnable )
    {
        if ( adapterType == ADAPTER_WIRED )
        {
            DCS_UpAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }

        if ( existUpAdapter )
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    else
    {
        if ( adapterType == ADAPTER_WIRED )
        {
            DCS_DownAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }

        if ( !existUpAdapter )
        {
            return true;
        }
        else
        {
            return false;
        }
    }
//    if ( bEnable )
//    {
//        if ( adapterType == ADAPTER_WIRED )
//        {
//            m_UsingWiredAdpterName = StartupInterface(m_asWiredInterface);
//            if ( m_UsingWiredAdpterName == "" )
//            {
//                return false;
//            }
//            else
//            {
//                return true;
//            }
//        }
//        else
//        {
//            m_UsingWirelessAdpterName = StartupInterface(m_asWirelessInterface);
//            if ( m_UsingWirelessAdpterName == "" )
//            {
//                return false;
//            }
//            else
//            {
//                return true;
//            }
//        }
//
//
//
//    }
//    else
//    {
//        wxArrayString interfaceList;
//        if ( adapterType == ADAPTER_WIRED )
//        {
//            interfaceList = m_asWiredInterface;
//        }
//        else
//        {
//            interfaceList = m_asWirelessInterface;
//        }
//
//        return ShutdownInterface(interfaceList);
//    }
}
WlanResult DataCenterLinux::ConnectWlanNetwork(const APStatus& apStatus, wxString key, int keyIdx, bool applyProfile)
{
//    if ( NULL != m_pAPStatus )
//    {
//       delete m_pAPStatus;
//       m_pAPStatus = NULL ;
//    }
    if ( IfUp(ADAPTER_WIRED) )
    {
        WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);
        if ( applyProfile )
        {
            ::wxPostEvent(this->GetProfileController(), event);
        }
        return WLAN_CONNECTION_ERROR;
    }
    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::ConnectWlanNetwork"));
    m_isApplyProfile = applyProfile;
//    StopGlobalTimer();
    memset(&m_connectInfo, 0 ,sizeof(ENM_ConnectAP));
    strcpy((char* )m_connectInfo.key.dcsString, ENMUtil::WxStringToString(key).c_str());
    memcpy((char* )m_connectInfo.ssid.dcsString, (const char*)apStatus.ssid.ucSsid, 32);
    m_connectInfo.auth = (keyIdx << 16) | apStatus.auth;
//    m_connectInfo.auth = apStatus.auth;

    ConnectAPThread *pGetCurAPThread = new ConnectAPThread(this);
    if ( pGetCurAPThread->Create() == wxTHREAD_NO_ERROR )
    {
        pGetCurAPThread->Run();
    }

//    wxLongLong wxLongBegin = ::wxGetLocalTimeMillis();
//    DCS_ConnectAP(m_connectInfo);
//    wxLongLong wxLongEnd = ::wxGetLocalTimeMillis();
//    ENMUtil::Log(::wxGetHomeDir() + wxT("/log.txt"), wxString::Format(wxT("connect AP need %d\n"), (wxLongEnd - wxLongBegin).ToLong()));
    if( !m_pAPStatus)
         m_pAPStatus = new APStatus() ;

//    *m_pAPStatus = apStatus;
    switch(apStatus.auth)
    {
        case WLAN_SECURITY_WPA_PSK:
        {
            ENMUtil::Log(logFile, _T("In DataCenterLinux::connect to AP with WPA password"));
//            m_WpaTimer.Start(WPA_DELAY, wxTIMER_ONE_SHOT);
            m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
        }
        break;
        case WLAN_SECURITY_WEP:
        {
            ENMUtil::Log(logFile, _T("In DataCenterLinux::connect to AP with WEP password"));
            m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
        }
        break;
        default:
        {
            ENMUtil::Log(logFile, _T("In DataCenterLinux::connect to AP without password"));
            m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
        }
        break;
    }
    ENMUtil::Log(logFile, _T("Leave DataCenterLinux::ConnectWlanNetwork"));
    return WLAN_SUCCESS;
}

void DataCenterLinux::OnWpaTimer(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter DataCenterLinux::OnWpaTimer"));
    ENM_NEIGHBORS_INFO NeighbInfo;
    DCS_GetNeighborInfo(&NeighbInfo);
    wxSleep(2);
    if ( ParseWpaFile() )
    {
//        DCS_AllocateDhIP();
        ENM_String* sWpaSupplicant = new ENM_String();
        memset(sWpaSupplicant, 0, sizeof(ENM_String));
        strcpy((char*)sWpaSupplicant->dcsString, "connect");
        DCS_WriteFile(sWpaSupplicant);
        m_AlllcatorTimer.Start(ALLOCATE_TIMERINTERVAL);
    }
    else
    {
        ENM_String* sWpaSupplicant = new ENM_String();
        memset(sWpaSupplicant, 0, sizeof(ENM_String));
        strcpy((char*)sWpaSupplicant->dcsString, "disconnect");
        DCS_WriteFile(sWpaSupplicant);
        wxSleep(6);
        if( m_pAPStatus )
        {
            delete m_pAPStatus;
            m_pAPStatus = NULL;
        }

        WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_CONNECT_FAILED);

        if ( m_isApplyProfile )
        {
            ::wxPostEvent(this->GetProfileController(), event);
        }
        else
        {
            ::wxPostEvent(this->GetScanNetworkDlgHandle(), event);
        }

//        StartGlobalTimer();
    }
    ENMUtil::Log(logFile, _T("Leave DataCenterLinux::OnWpaTimer"));
}

void DataCenterLinux::OnSusPendTimer(wxTimerEvent& event)
{
//    ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->") + home);
//    if ( wxFile::Exists(home + _T("/suspend")) )
    if ( wxFile::Exists(_T("/tmp/.suspend")) )
    {
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->suspend"));
        StopGlobalTimer();
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->suspend:stop timer"));
//        string removeFile = "rm " + ENMUtil::WxStringToString(home) + "/suspend";
//        string removeFile = "rm /tmp/suspend";
//        system(removeFile.c_str());
        ENM_String sRmSuspend;
        memset(&sRmSuspend, 0, sizeof(ENM_String));
        strcpy((char*)sRmSuspend.dcsString, "rmSuspend");
        DCS_WriteFile(&sRmSuspend);
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->suspend:remove suspend file"));
    }
//    if ( wxFile::Exists(home + _T("/resume")) )
    if ( wxFile::Exists(_T("/tmp/.resume")) )
    {
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->resume"));
        ENM_String sRmSuspend;
        memset(&sRmSuspend, 0, sizeof(ENM_String));
        strcpy((char*)sRmSuspend.dcsString, "rmResume");
        DCS_WriteFile(&sRmSuspend);
        ProfileEvent profileEvent(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
        ::wxPostEvent(GetNetworkManagerDlgHandle(), profileEvent);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:post event"));
        m_StartTimerAfterResume.Start(STARTTIMERAFTERRESUME, true);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:start timer"));
        StartGlobalTimer();
        m_WaitForResume.Stop();
        ENMUtil::Log(logFile, _T("Leave OnWaitForResume"));
//        m_WaitForResume.Start(1000, wxTIMER_CONTINUOUS);
        ENMUtil::Log(logFile, _T("Enter OnSusPendTimer-->resume:remove resume file"));
    }
//    ENMUtil::Log(logFile, _T("Leave OnSusPendTimer"));
    return;
}

void DataCenterLinux::OnWaitForResume(wxTimerEvent& event)
{
    BOOL IfWiredEnable;
    DCS_GetLANStatus(&IfWiredEnable);
    BOOL IfWirelessEnable;
    DCS_GetWirelessStatus(&IfWirelessEnable);
    if ( (m_CurrentNetworkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || m_CurrentNetworkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT) && IfWirelessEnable )
    {
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume:WirelessEnable"));
        ProfileEvent profileEvent(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
        ::wxPostEvent(GetNetworkManagerDlgHandle(), profileEvent);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:post event"));
        m_StartTimerAfterResume.Start(STARTTIMERAFTERRESUME, true);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:start timer"));
        StartGlobalTimer();
        m_WaitForResume.Stop();
        ENMUtil::Log(logFile, _T("Leave OnWaitForResume"));
    }
    else if ( (m_CurrentNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT || m_CurrentNetworkMode == NETWORK_MODE_WIRED_LAN_DISCONNECT) && IfWiredEnable )
    {
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume:WiredEnable"));
        ProfileEvent profileEvent(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
        ::wxPostEvent(GetNetworkManagerDlgHandle(), profileEvent);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:post event"));
        m_StartTimerAfterResume.Start(STARTTIMERAFTERRESUME, true);
        ENMUtil::Log(logFile, _T("Enter OnWaitForResume-->resume:start timer"));
        StartGlobalTimer();
        m_WaitForResume.Stop();
        ENMUtil::Log(logFile, _T("Leave OnWaitForResume"));
    }
}

void DataCenterLinux::OnStartTimerAfterResume(wxTimerEvent& event)
{
    ENMUtil::Log(logFile, _T("Enter OnStartTimerAfterResume"));
    if ( (wxString::FromUTF8(GetIPAddressHLAN(m_UsingWiredAdpterName, ENMUtil::WxStringToString(g_path)).c_str()).IsEmpty()) && m_CurrentNetworkMode == NETWORK_MODE_WIRED_LAN_CONNECT )
    {
        m_killDhclientCount = 0;
        ENM_String* sDhclient = new ENM_String();
        memset(sDhclient, 0, sizeof(ENM_String));
        strcpy((char*)sDhclient->dcsString, "dhclient");
        DCS_WriteFile(sDhclient);
    }
//    StartGlobalTimer();
    ENMUtil::Log(logFile, _T("Leave OnStartTimerAfterResume"));
}

void DataCenterLinux::OnSwitchUserTimer(wxTimerEvent& event)
{
    wxString homeDir = wxGetHomeDir();
    string order = "echo $USERNAME > " + ENMUtil::WxStringToString(homeDir) + "/ActiveUser.out";
    system(order.c_str());
    wxTextFile userFile(homeDir + _T("/ActiveUser.out"));
    userFile.Open();
    wxString firstLine = userFile.GetFirstLine();
    if ( m_activeUser.IsEmpty() )
    {
        ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->m_activeUser is empty"));
        m_activeUser = firstLine;
    }
    else
    {
        ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->m_activeUser is not empty, and it's ") + m_activeUser + _T(" firstLine is ") + firstLine + _T(" at ") + ::wxNow());
        if ( firstLine.Cmp(m_activeUser) != 0 )
        {
            ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->user changed"));
            if ( !m_switchUser )
            {
                ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->stop timer"));
                StopGlobalTimer();
                m_switchUser = true;
            }
        }
        else
        {
            ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->user doesn't changed"));
            if ( m_switchUser )
            {
                ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->post event"));
                ProfileEvent event(ID_PROFILE_APPLY, PEVT_PROFILE_APPLY_REAPPLY);
                ::wxPostEvent(GetNetworkManagerDlgHandle(), event);
                ENMUtil::Log(logFile, _T("Enter OnSwitchUserTimer-->start timer"));
                StartGlobalTimer();
                m_switchUser = false;
            }
        }
    }
    userFile.Close();
    string removeFile = "rm " + ENMUtil::WxStringToString(homeDir) + "/ActiveUser.out";
    system(removeFile.c_str());
    return;
}

bool DataCenterLinux::ParseWpaFile()
{
    ifstream wpaLog;
    string path = "/tmp/wpa.log";
    char wpaLogBuf[1024] = {0};
    wpaLog.open(path.c_str(), ios_base::in);
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........"));
    while ( wpaLog.getline(wpaLogBuf, sizeof(wpaLogBuf)) )
    {
        wxString content = wxString::FromUTF8(wpaLogBuf);
        ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........") + content);
        if ((int) content.find(wxT("pre-shared key may be incorrect")) > 0)
        {
            ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........pre-shared key may be incorrect"));
            wpaLog.close();
            return false;
        }
        if ((int) content.find(wxT("EVENT-CONNECTED")) > 0)
        {
            ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........CTRL-EVENT-CONNECTED"));
            wpaLog.close();
            return true;
        }
    }
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("parse file........find nothing"));
    wpaLog.close();
    return false;
}

bool DataCenterLinux::DisableAllAdapters()
{
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("line-------->1129"));
    SwitchAdapterParameter(ADAPTER_WIRED, (ADAPTER_TYPE)0, NULL);
    ENMUtil::Log(wxT("/tmp/ENMLog.txt"), _T("line-------->1131"));
    SwitchAdapterParameter(ADAPTER_WIREDLESS, (ADAPTER_TYPE)0, NULL);
//    EnableNetworkAdapter(ADAPTER_WIRED,false);
//
//    EnableNetworkAdapter(ADAPTER_WIREDLESS,false);

    return true;
}

int DataCenterLinux::OpenSockets()
{
	static const int families[] = {
		AF_INET, AF_IPX, AF_AX25, AF_APPLETALK
	};
	unsigned int i;
	int	sock;

	for(i = 0; i < sizeof(families)/sizeof(int); ++i)
	{
		sock = socket(families[i], SOCK_DGRAM, 0);
		if(sock >= 0)
        return sock;
	}

	return -1;
}

void DataCenterLinux::GetNetInfo()
{
    DCS_SearchAdapter();
//    system("iwconfig > ~/iwc.txt");
//    system("ifconfig -a -s > ~/ifc.txt");
//    ifstream iwcstream;
//    ifstream ifcstream;
//	string sIwcPath = ENMUtil::WxStringToString(g_path) + "/iwc.txt";
//	string sIfcPath = ENMUtil::WxStringToString(g_path) + "/ifc.txt";
//    iwcstream.open(sIwcPath.c_str(),ios_base::in);
//    ifcstream.open(sIfcPath.c_str(),ios_base::in);
//    char cIwcFileBuf[1024];
//    char cIfcFileBuf[1024];
//    char wirelessAdapterName[128] = {0};
//    char ifcName[128] = {0};
//    int linecount = 1;
//    while(ifcstream.getline(cIfcFileBuf, sizeof(cIfcFileBuf)))
//    {
//        memset(ifcName, '\0', 128);
//        if (1 != linecount)
//        {
//            int i = 0;
//            while (cIfcFileBuf[i] != ' ' &&  cIfcFileBuf[i] != '\t' &&  cIfcFileBuf[i] != '\n' &&  cIfcFileBuf[i] != '\0')
//            {
//                ifcName[i] = cIfcFileBuf[i];
//                i++;
//            }
//            string sName(ifcName);
//            if ( sName != "lo" && sName != "wmaster0" && string::npos == sName.find(":avahi") )
//            {
//                m_asWiredInterface.Add(wxString::FromUTF8((const char*)ifcName));
//            }
//        }
//        linecount++;
//    }
//    while(iwcstream.getline(cIwcFileBuf, sizeof(cIwcFileBuf)))
//    {
//        if (cIwcFileBuf[0] != ' ' && cIwcFileBuf[0] != ' ' &&  cIwcFileBuf[0] != '\t' &&  cIwcFileBuf[0] != '\n' &&  cIwcFileBuf[0] != '\0')
//        {
//            int i = 0;
//            while (cIwcFileBuf[i] != ' ' &&  cIwcFileBuf[i] != '\t' &&  cIwcFileBuf[i] != '\n' &&  cIwcFileBuf[i] != '\0')
//            {
//                wirelessAdapterName[i] = cIwcFileBuf[i];
//                i++;
//            }
//            m_asWirelessInterface.Add(wxString::FromUTF8((const char*)wirelessAdapterName));
//        }
//    }
//    for (int j = 0; j < m_asWirelessInterface.Count(); j++)
//    {
//        for (int k = 0; k < m_asWiredInterface.Count(); k++)
//        {
//            if ( m_asWiredInterface[k].Cmp(m_asWirelessInterface[j]) == 0 )
//            {
//                m_asWiredInterface.RemoveAt(k);
//            }
//        }
//    }
////    for (int i = 0; i < m_asWiredInterface.Count(); i++)
////    {
////        char name[m_asWiredInterface[i].Len()];
////        strcpy(name,m_asWiredInterface[i].mb_str());
////        printf("%d wired interface: %s\n", i + 1, name);
////    }
////    for (int i = 0; i < m_asWirelessInterface.Count(); i++)
////    {
////        char name[m_asWirelessInterface[i].Len()];
////        strcpy(name,m_asWirelessInterface[i].mb_str());
////        printf("%d wireless interface: %s\n", i + 1, name);
////    }
////    printf("------------------------------------------\n");
//    iwcstream.close();
//    ifcstream.close();
}

bool DataCenterLinux::IfUp(ADAPTER_TYPE adapterType)
{
    BOOL IfWiredEnable;
    BOOL IfWirelessEnable;
    BOOL ifUp;
    if ( adapterType == ADAPTER_WIRED )
    {
        DCS_GetLANStatus(&IfWiredEnable);
        if ( IfWiredEnable )
        {
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &ifUp);
        }
        else
        {
            return false;
        }

    }
    else
    {
        DCS_GetWirelessStatus(&IfWirelessEnable);
        if ( IfWirelessEnable )
        {
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &ifUp);
        }
        else
        {
            return false;
        }

    }
    if ( ifUp )
    {
        return true;
    }
    else
    {
        return false;
    }
//    system("ifconfig -s > ~/ifup.txt");
//    ifstream ifUp;
//    string path = ENMUtil::WxStringToString(g_path) + "/ifup.txt";
//    ifUp.open(path.c_str(), ios_base::in);
//    char ifUpBuf[1024] = {0};
//    char name[128];
//    int linecount = 1;
//    wxArrayString temp;
//    while ( ifUp.getline(ifUpBuf, sizeof(ifUpBuf)) )
//    {
//        memset(name, '\0', 128);
//        if ( 1 != linecount )
//        {
//            int i = 0;
//            while (ifUpBuf[i] != ' ' &&  ifUpBuf[i] != '\t' &&  ifUpBuf[i] != '\n' &&  ifUpBuf[i] != '\0')
//            {
//                name[i] = ifUpBuf[i];
//                i++;
//            }
//            temp.Add(wxString::FromUTF8((const char*)name));
//        }
//        linecount++;
//    }
//    ifUp.close();
////    wxArrayString inUsing;
////    if ( ADAPTER_WIRED == adapterType )
////    {
////        inUsing = m_asWiredInterface;
////    }
////    else
////    {
////        inUsing = m_asWirelessInterface;
////    }
//
//    if ( adapterName.empty() )
//    {
//        for (int j = 0; j < temp.Count(); j++)
//        {
//            for (int k = 0; k < wxaAdapterList.Count(); k++)
//            {
//                if ( wxaAdapterList[k].Cmp(temp[j]) == 0 )
//                {
//                    return ENMUtil::WxStringToString(temp[j]);
//                }
//            }
//        }
//        return "";
//    }
//    else
//    {
//        for (int k = 0; k < temp.Count(); k++)
//        {
//            if ( temp[k].Cmp(wxString::FromUTF8((const char*)adapterName.c_str())) == 0 )
//            {
//                return ENMUtil::WxStringToString(temp[k]);
//            }
//        }
//        return "";
//    }

}

bool DataCenterLinux::IfLink(ADAPTER_TYPE adapterType, string adapterName)
{
    BOOL bIfConnect;

    if ( ADAPTER_WIRED == adapterType )
    {
        DCS_IsExistConnectAdapter(DCS_ADAPTER_WIRED, &bIfConnect);
    }
    else
    {
        DCS_IsExistConnectAdapter(DCS_ADAPTER_WIREDLESS, &bIfConnect);
    }

    if ( bIfConnect )
    {
        return true;
    }
    else
    {
        return false;
    }
//    if ( ADAPTER_WIRED == adapterType )
//    {
//        if ( adapterName.empty() )
//        {
//            for (int k = 0; k < m_asWiredInterface.Count(); k++)
//            {
//                char cOrder[128];
//                sprintf(cOrder, "ethtool %s > ~/eth.txt", ENMUtil::WxStringToString(m_asWiredInterface[k]).c_str());
//                system(cOrder);
//                ifstream in;
//                string sPath = ENMUtil::WxStringToString(g_path) + "/eth.txt";
//                const char* cFileName = sPath.c_str();
//                in.open(cFileName,ios_base::in);
//                char cFileBuf[1024];
//                wxString speed;
//                bool b;
//                while(in.getline(cFileBuf, sizeof(cFileBuf)))
//                {
//                    wxString content = wxString::FromUTF8(cFileBuf);
//                    if ((int) content.find(wxT("Link detected:")) > 0)
//                    {
//                        if ((int) content.find(wxT("yes")) > 0)
//                        {
//                            b = true;
//                        }
//                        else
//                        {
//                            b = false;
//                        }
//                    }
//                    else
//                    {
//                        b = false;
//                    }
//                }
//                in.close();
//
//                return b;
//            }
//        }
//        else
//        {
//            char cOrder[128];
//            sprintf(cOrder, "ethtool %s > ~/eth.txt", adapterName.c_str());
//            system(cOrder);
//            ifstream in;
//            string sPath = ENMUtil::WxStringToString(g_path) + "/eth.txt";
//            const char* cFileName = sPath.c_str();
//            in.open(cFileName,ios_base::in);
//            char cFileBuf[1024];
//            wxString speed;
//            bool b;
//            while(in.getline(cFileBuf, sizeof(cFileBuf)))
//            {
//                wxString content = wxString::FromUTF8(cFileBuf);
//                if ((int) content.find(wxT("Link detected:")) > 0)
//                {
//                    if ((int) content.find(wxT("yes")) > 0)
//                    {
//                        b = true;
//                    }
//                    else
//                    {
//                        b = false;
//                    }
//                }
//                else
//                {
//                    b = false;
//                }
//            }
//            in.close();
//
//            return b;
//        }
//    }
//    else
//    {
//        if ( adapterName.empty() )
//        {
//            for (int k = 0; k < m_asWirelessInterface.Count(); k++)
//            {
//                bool adapterIsUp = IfUp(ADAPTER_WIREDLESS);
//                if ( adapterIsUp )
//                {
//                    char cOrder[128];
//                    sprintf(cOrder, "ifconfig %s > ~/ifc.txt", ENMUtil::WxStringToString(m_asWirelessInterface[k]).c_str());
//                    system(cOrder);
//                    ifstream in;
//                    string sPath = ENMUtil::WxStringToString(g_path) + "/ifc.txt";
//                    const char* cFileName = sPath.c_str();
//                    in.open(cFileName,ios_base::in);
//                    char cFileBuf[1024];
//                    wxString IP;
//                    while(in.getline(cFileBuf, sizeof(cFileBuf)))
//                    {
//                        wxString content = wxString::FromUTF8(cFileBuf);
//                        if ((int) content.find(wxT("inet addr:")) > 0)
//                        {
//                            size_t posBegin = content.Find(wxT("inet addr:")) + 10;
//                            size_t posEnd = content.Find(wxT("Bcast:")) - 2;
//                            int len = posEnd - posBegin;
//                            IP = content.Mid(posBegin, len);
//                            string ip = ENMUtil::WxStringToString(IP);
//                            if ( ip != "127.0.0.1" && !ip.empty() )
//                            {
//                                in.close();
//                                return true;
//                            }
//                        }
//                    }
//                    in.close();
//                }
//            }
//            return false;
//        }
//        else
//        {
//            char cOrder[128];
//            sprintf(cOrder, "ifconfig %s > ~/ifc.txt", adapterName.c_str());
//            system(cOrder);
//            ifstream in;
//            string sPath = ENMUtil::WxStringToString(g_path) + "/ifc.txt";
//            const char* cFileName = sPath.c_str();
//            in.open(cFileName,ios_base::in);
//            char cFileBuf[1024];
//            wxString IP;
//            while(in.getline(cFileBuf, sizeof(cFileBuf)))
//            {
//                wxString content = wxString::FromUTF8(cFileBuf);
//                if ((int) content.find(wxT("inet addr:")) > 0)
//                {
//                    size_t posBegin = content.Find(wxT("inet addr:")) + 10;
//                    size_t posEnd = content.Find(wxT("Bcast:")) - 1;
//                    int len = posEnd - posBegin;
//                    IP = content.Mid(posBegin, len);
//                }
//            }
//            in.close();
//
//            string ip = ENMUtil::WxStringToString(IP);
//            if ( ip != "127.0.0.1" && !ip.empty() )
//            {
//                return true;
//            }
//            else
//            {
//                return false;
//            }
//        }
//    }

}

//bool DataCenterLinux::IfWiredUp()
//{
//    struct ifreq ifr;
//    int socketfd= socket(PF_INET, SOCK_STREAM, 0);
//    bool flag = false;
//    for (int i = 0; i < m_asWiredInterface.Count(); i++)
//    {
//        strcpy(ifr.ifr_name, m_asWiredInterface[i].mb_str());
//        int i = ioctl(socketfd, SIOCGIFFLAGS, &ifr);
//        if (i == -1)
//        {
//            //printf("SIOCGIFFLAGS failed: %s\n", strerror(errno));
//            break;
//        }
//        else
//        {
//            if ((ifr.ifr_flags & IFF_UP) == 0)
//            {
//                //printf("%s is down is IfWiredUp\n", ifr.ifr_name);
//            }
//            else
//            {
//                //printf("%s is up is IfWiredUp\n", ifr.ifr_name);
//                flag = true;
//                break;
//            }
//        }
//    }
////    if (flag)
////    {
////        //printf("one interface is up, return true\n");
////    }
////    else
////    {
////        //printf("all interface is down, return false\n");
////    }
//    close(socketfd);
//    return flag;
//}
//
//bool DataCenterLinux::IfWiredLink()
//{
//    struct ifreq ifr;
//    int socketfd= socket(PF_INET, SOCK_STREAM, 0);
//    bool flag = false;
//    for (int i = 0; i < m_asWiredInterface.Count(); i++)
//    {
//        strcpy(ifr.ifr_name, m_asWiredInterface[i].mb_str());
//        int i = ioctl(socketfd, SIOCGIFFLAGS, &ifr);
//        if (i == -1)
//        {
//            //printf("SIOCGIFFLAGS failed: %s\n", strerror(errno));
//            break;
//        }
//        else
//        {
//            if ((ifr.ifr_flags & IFF_RUNNING) == 0)
//            {
//                //printf("%s is disconnect in IfWiredLink\n", ifr.ifr_name);
//            }
//            else
//            {
//                //printf("%s is connect in IfWiredLink\n", ifr.ifr_name);
//                flag = true;
//                break;
//            }
//        }
//    }
////    if (flag)
////    {
////        //printf("one interface is connect, return true\n");
////    }
////    else
////    {
////        //printf("all interface is disconnect, return false\n");
////    }
//    close(socketfd);
//    return flag;
//}
//
//bool DataCenterLinux::IfWirelessUp()
//{
//    struct ifreq ifr;
//    int socketfd= socket(PF_INET, SOCK_STREAM, 0);
//    bool flag = false;
//    for (int i = 0; i < m_asWirelessInterface.Count(); i++)
//    {
//        strcpy(ifr.ifr_name, m_asWirelessInterface[i].mb_str());
//        int i = ioctl(socketfd, SIOCGIFFLAGS, &ifr);
//        if (i == -1)
//        {
//            //printf("SIOCGIFFLAGS failed: %s\n", strerror(errno));
//            break;
//        }
//        else
//        {
//            if ((ifr.ifr_flags & IFF_UP) == 0)
//            {
//                //printf("%s is down in IfWirelessUp\n", ifr.ifr_name);
//            }
//            else
//            {
//                //printf("%s is up in IfWirelessUp\n", ifr.ifr_name);
//                flag = true;
//                break;
//            }
//        }
//    }
////    if (flag)
////    {
////        //printf("one interface is up, return true\n");
////    }
////    else
////    {
////        //printf("all interface is down, return false\n");
////    }
//    close(socketfd);
//    return flag;
//}
//
//bool DataCenterLinux::IfWirelessLink()
//{
//    struct sockaddr_in *addr;
//    struct ifreq ifr;
//    char* address;
//    int sockfd;
//    int socketfd= socket(PF_INET, SOCK_STREAM, 0);
//    bool flag = false;
//    for (int i = 0; i < m_asWirelessInterface.Count(); i++)
//    {
//        strcpy(ifr.ifr_name, m_asWirelessInterface[i].mb_str());
//        int i = ioctl(socketfd, SIOCGIFADDR, &ifr);
//        if (i == -1)
//        {
//            //printf("SIOCGIFADDR failed: %s\n", strerror(errno));
//            break;
//        }
//        else
//        {
//            addr = (struct sockaddr_in *)&(ifr.ifr_addr);
//            address = inet_ntoa(addr->sin_addr);
//            if (address == NULL)
//            {
//                close(socketfd);
//                return false;
//            }
//            else
//            {
//                close(socketfd);
//                if (!strcmp(address, "127.0.0.1"))
//                {
//                    return false;
//                }
//                else
//                {
//                    return true;
//                }
//            }
//        }
//    }
////    if (flag)
////    {
////        //printf("one interface is connect, return true\n");
////    }
////    else
////    {
////        //printf("all interface is disconnect, return false\n");
////    }
//    close(socketfd);
//    return flag;
//}

wxArrayString DataCenterLinux::GetInterface(int i)
{
//    if (i == 1)
//    {
//        return m_asWiredInterface;
//    }
//    else
//    {
//        return m_asWirelessInterface;
//    }
    wxArrayString strArray;
    return strArray;
}

bool DataCenterLinux::ShutdownInterface(ADAPTER_TYPE adapterType)
{
    BOOL existUpAdapter;
    BOOL IfEnable;
    if ( adapterType == ADAPTER_WIRED )
    {
        DCS_GetLANStatus(&IfEnable);
//        if ( NETWORK_MODE_WIRED_LAN_CONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_WIRED_LAN_DISCONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_DISCONNECTED == m_CurrentNetworkMode )
//        {
//            wxSleep(5);
//        }
//        wxSleep(10);
        if ( IfEnable )
        {
            ENM_String* sKill = new ENM_String();
            memset(sKill, 0, sizeof(ENM_String));
            strcpy((char*)sKill->dcsString, "killall");
            DCS_WriteFile(sKill);
            DCS_DownAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            return true;
        }
    }
    else
    {
        DCS_GetWirelessStatus(&IfEnable);
//        if ( NETWORK_MODE_WIRED_LAN_CONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_WIRED_LAN_DISCONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_DISCONNECTED == m_CurrentNetworkMode )
//        {
//            wxSleep(5);
//        }
//        wxSleep(10);
        if ( IfEnable )
        {
            DCS_DownAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }
        else
        {
            return true;
        }
    }

    if ( existUpAdapter )
    {
        return false;
    }
    else
    {
        return true;
    }

//    struct ifreq ifr;
//    int socketfd= socket(PF_INET, SOCK_STREAM, 0);
//    wxArrayString changeStatus;
//    bool flag = false;
//    if (adapterType == ADAPTER_WIRED)
//    {
//        changeStatus = m_asWiredInterface;
//    }
//    else
//    {
//        changeStatus = m_asWirelessInterface;
//    }
//
//    for (int j = 0; j < changeStatus.Count(); j++)
//    {
//        strcpy(ifr.ifr_name, changeStatus[j].mb_str());
//        int m = ioctl(socketfd, SIOCGIFFLAGS, &ifr);
//        if (m == -1)
//        {
//            //printf("get flags of %s failed: %s\n", ifr.ifr_name, strerror(errno));
//            flag = false;
//            break;
//        }
//        else
//        {
//            ifr.ifr_flags &= ~IFF_UP;
//            int n = ioctl(socketfd, SIOCSIFFLAGS, &ifr);
//            if (n == -1)
//            {
//                //printf("set flags of %s failed: %s\n", ifr.ifr_name, strerror(errno));
//                flag = false;
//                break;
//            }
//            else
//            {
//                //printf("%s is down\n", ifr.ifr_name);
//                flag = true;
//            }
//        }
//    }
//    close(socketfd);
//    return flag;
}
//
bool DataCenterLinux::StartupInterface(ADAPTER_TYPE adapterType)
{
    if( m_pAPStatus )
    {
        delete m_pAPStatus;
        m_pAPStatus = NULL;
    }
    BOOL IfEnable;
    BOOL existUpAdapter;
    if ( adapterType == ADAPTER_WIRED )
    {
        DCS_GetLANStatus(&IfEnable);
//        if ( NETWORK_MODE_WIRED_LAN_CONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_WIRED_LAN_DISCONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_DISCONNECTED == m_CurrentNetworkMode )
//        {
//            wxSleep(5);
//        }
//        wxSleep(10);
        if ( IfEnable )
        {
            DCS_UpAdapter(DCS_ADAPTER_WIRED);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIRED, &existUpAdapter);
        }
        else
        {
            return false;
        }
    }
    else
    {
        DCS_GetWirelessStatus(&IfEnable);
//        if ( NETWORK_MODE_WIRED_LAN_CONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_WIRED_LAN_DISCONNECT == m_CurrentNetworkMode
//            || NETWORK_MODE_DISCONNECTED == m_CurrentNetworkMode )
//        {
//            wxSleep(5);
//        }
//        wxSleep(10);
        if ( IfEnable )
        {
            ENMUtil::Log(logFile, _T("has ra0"));
            DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
            DCS_IsExistUpAdapter(DCS_ADAPTER_WIREDLESS, &existUpAdapter);
        }
        else
        {
            ENMUtil::Log(logFile, _T("no ra0"));
            return false;
        }
    }

    if ( !existUpAdapter )
    {
        ENMUtil::Log(logFile, _T("has ra0 but cannot up"));
        return false;
    }
    else
    {
        return true;
    }
//    struct ifreq ifr;
//    int socketfd= socket(PF_INET, SOCK_STREAM, 0);
//    string name = "";
//    wxArrayString changeStatus;
//    if (ADAPTER_WIRED == adapterType)
//    {
//        changeStatus = m_asWiredInterface;
//    }
//    else
//    {
//        changeStatus = m_asWirelessInterface;
//    }
//
//    for (int j = 0; j < changeStatus.Count(); j++)
//    {
//        strcpy(ifr.ifr_name, changeStatus[j].mb_str());
//        int m = ioctl(socketfd, SIOCGIFFLAGS, &ifr);
//        if (m == -1)
//        {
//            //printf("get flags of %s failed: %s\n", ifr.ifr_name, strerror(errno));
//            close(socketfd);
//            return name;
//        }
//        else
//        {
//            ifr.ifr_flags |= IFF_UP;
//            int n = ioctl(socketfd, SIOCSIFFLAGS, &ifr);
//            if (n == -1)
//            {
//                //printf("set flags of %s failed: %s\n", ifr.ifr_name, strerror(errno));
//                close(socketfd);
//                return name;
//            }
//            else
//            {
//                //printf("%s is up\n", ifr.ifr_name);
//                close(socketfd);
//                return name = string(ifr.ifr_name);
//            }
//        }
//    }
//    return name;
}
//bool DataCenterLinux::ShutdownInterface(const wxArrayString& interfaceList)
//{
//    bool flag = true;

//    if ( interfaceList.Count() <= 0 )
//    {
//        flag = false;
//    }

//    for (int i = 0; i < interfaceList.Count(); i++)
//    {
//        for ( int j = 0; j < 5; j++ )
//        {
//            char cOrder[ORDERBUFSIZE];
//            sprintf(cOrder, "ifconfig %s down", ENMUtil::WxStringToString(interfaceList[i]).c_str());
//            system(cOrder);
//        }

//        string strName = IfUp(interfaceList, ENMUtil::WxStringToString(interfaceList[i]));
//
//        if ( strName != "" )
//        {
//            flag = false;
//            break;
//        }

//    }
//    return flag;
//}

//string DataCenterLinux::StartupInterface(const wxArrayString& interfaceList)
//{
//    string name = "";

//    int i = 0;
//    for (i = 0; i < interfaceList.Count(); i++)
//    {
//        for ( int j = 0; j < 5; j++ )
//        {
//        if ( ENMUtil::WxStringToString(interfaceList[i]) != "eth1" )
//        {
//            char cOrder[ORDERBUFSIZE];
//            sprintf(cOrder, "ifconfig %s up", ENMUtil::WxStringToString(interfaceList[i]).c_str());
//            system(cOrder);
//        }

//        }
//        string strName = IfUp(interfaceList, ENMUtil::WxStringToString(interfaceList[i]));
//
//        if ( strName != "" )
//        {
//            name = strName;
//            break;
//        }
//        name = ENMUtil::WxStringToString(interfaceList[i]);
//
//    }
//
//    return name;

//}

wxArrayString DataCenterLinux::GetNetworkAdapterName(ADAPTER_TYPE adapterType)
{
//    if ( ADAPTER_WIRED == adapterType )
//    {
//        return m_asWiredInterface;
//    }
//    else
//    {
//        return m_asWirelessInterface;
//    }
    wxArrayString strArray;
    return strArray;
}
wxString DataCenterLinux::GetUsingAdapterName(ADAPTER_TYPE adapterType)
{
//    if ( ADAPTER_WIRED == adapterType )
//    {
//        return wxString::FromUTF8(m_UsingWiredAdpterName.c_str());
//    }
//    else
//    {
//        return wxString::FromUTF8(m_UsingWirelessAdpterName.c_str());
//    }
    wxString strTemp;
    return strTemp;
}

void DataCenterLinux::StartGlobalTimer()
{
    m_NetStatusTimer.Start(NETSTATUS_TIMERINTERVAL);
}

void DataCenterLinux::StopGlobalTimer()
{
    m_NetStatusTimer.Stop();
}

bool DataCenterLinux::CloseWlanConnection(bool ifScanDlg)
{
    DCS_CloseWlanConnection();
    if ( ifScanDlg )
    {
        if ( m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT )
        {
            m_postEvent = true;
            GetProfileController()->NotifyModeChanged(NETWORK_MODE_WIRELESS_LAN_DISCONNECT);
            ENMUtil::Log(logFile, _T("*****change mode*****"));
//            m_LastNetworkMode = NETWORK_MODE_WIRELESS_LAN_CONNECT;
//            m_CurrentNetworkMode = NETWORK_MODE_WIRELESS_LAN_DISCONNECT;
//            GetProfileController()->NotifyModeChanged(m_CurrentNetworkMode);
        }
    }
    if ( NULL != m_pAPStatus )
    {
       delete m_pAPStatus;
       m_pAPStatus = NULL ;
    }
    if ( !ifScanDlg )
    {
        SwitchAdapterParameter((ADAPTER_TYPE)0, ADAPTER_WIREDLESS, NULL);
    }
//    SwitchAdapterParameter((ADAPTER_TYPE)0, ADAPTER_WIREDLESS, NULL);
//    if ( !IfUp(ADAPTER_WIREDLESS) )
//    {
//        StartupInterface(ADAPTER_WIREDLESS);
//    }
    WlanAcmEvent event(ID_WLAN_ACM_CONNECT, WLAN_ACM_EVENT_DISCONNECTED);
    ::wxPostEvent(m_pScanNetworkDlg, event);
//    char cFirOrder[128];
//    sprintf(cFirOrder, "dhclient %s -r", m_UsingWirelessAdpterName.c_str());
//    system(cFirOrder);
//    sprintf(cFirOrder, "ifconfig %s 127.0.0.1", m_UsingWirelessAdpterName.c_str());
//    system(cFirOrder);
//    sprintf(cFirOrder, "iwconfig %s essid \"\"", m_UsingWirelessAdpterName.c_str());
//    system(cFirOrder);
//    sprintf(cFirOrder, "iwconfig %s essid off", m_UsingWirelessAdpterName.c_str());
//    system(cFirOrder);
//    if ( m_pAPStatus )
//    {
//        delete m_pAPStatus;
//        m_pAPStatus = NULL ;
//    }
    return true;
}
bool DataCenterLinux::IsWirelessConnected()
{
    return false ;
}

void DataCenterLinux::SetSsid(APStatus& apStatus)
{
//    char cFirOrder[128];
//    sprintf(cFirOrder, "iwconfig %s > ~/iwconfig.txt", m_UsingWirelessAdpterName.c_str());
//    system(cFirOrder);
//    ifstream in;
//    string sPath = ENMUtil::WxStringToString(g_path) + "/iwconfig.txt";
//    const char* cFileName = sPath.c_str();
//    in.open(cFileName,ios_base::in);
//    char cFileBuf[1024];
//    wxString Essid;
//	m_BitRate = wxT("11");
//    while(in.getline(cFileBuf, sizeof(cFileBuf)))
//    {
//        wxString content = wxString::FromUTF8(cFileBuf);
//        if ((int) content.find(wxT("ESSID:")) > 0)
//        {
//            size_t posBegin = content.Find(wxT("\"")) + 1;
//            size_t posEnd = content.Find('\"', true);
//            int len = posEnd - posBegin;
//            Essid = content.Mid(posBegin, len);
//            apStatus.ssid.length = len;
//            memcpy(apStatus.ssid.ucSsid, ENMUtil::WxStringToString(Essid).c_str(), len);
//        }
//        if ((int) content.find(wxT("Bit Rate:")) > 0)
//        {
//            size_t posBegin = content.Find(wxT(':')) + 1;
//            size_t posEnd = content.Find(wxT("Mb/s")) - 1;
//            int len = posEnd - posBegin;
//            m_BitRate = content.Mid(posBegin, len);
//            break;
//        }
//    }
//    in.close();
}

bool DataCenterLinux::IsWiredInterfaceConnected()
{
    return IfLink(ADAPTER_WIRED, "");
}
WlanScanner* DataCenterLinux::GetScanner()
{
    return m_pLinuxWlanScanner;
}

bool DataCenterLinux::IsInterfaceEnabled(ADAPTER_TYPE adapterType)
{
    bool bRet = false;
//	wxArrayString arrayInterface = GetNetworkAdapterName(adapterType);
	bool bAdapterName = IfUp(adapterType);

	if ( bAdapterName )
	{
		bRet = true;
	}

    return bRet;

}

DataCenterLinux::SwitchAdapterThread::SwitchAdapterThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinux = pDataCenterLinux;
    m_continueFlag = true;
}

DataCenterLinux::SwitchAdapterThread::~SwitchAdapterThread()
{
}

void* DataCenterLinux::SwitchAdapterThread::Entry()
{
    while ( m_continueFlag )
    {
        if ( m_vParameter.empty() )
        {
            wxThread::Sleep(500);
        }
        else
        {
            ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:there are %d times\n"), m_vParameter.size()));
            bool downResult = true;
            bool upResult = true;
            if ( 0 != m_vParameter[0].adapterTypeDown )
            {
//                downResult = m_DataCenterLinux->ShutdownInterface(m_DataCenterLinux->GetNetworkAdapterName(m_vParameter[0].adapterTypeDown));
                BOOL existAdapter;
                DCS_IsExistAdapter((ENM_ADAPTER_TYPE)m_vParameter[0].adapterTypeDown, &existAdapter);
                if ( existAdapter )
                {
                    ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:shutdown %d\n"), m_vParameter[0].adapterTypeDown));
                    downResult = m_DataCenterLinux->ShutdownInterface(m_vParameter[0].adapterTypeDown);
                    ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:shutdown result is %d\n"), downResult));
                }
                else
                {
                    downResult = true;
                }

            }

            if ( downResult && 0 != m_vParameter[0].adapterTypeUp )
            {
//                m_DataCenterLinux->m_UsingWirelessAdpterName = m_DataCenterLinux->StartupInterface(m_DataCenterLinux->GetNetworkAdapterName(m_vParameter[0].adapterTypeUp));
//                upResult = (m_DataCenterLinux->m_UsingWirelessAdpterName != "");
                BOOL existAdapter;
                DCS_IsExistAdapter((ENM_ADAPTER_TYPE)m_vParameter[0].adapterTypeUp, &existAdapter);
                if ( existAdapter )
                {
                    ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:startup %d\n"), m_vParameter[0].adapterTypeUp));
                    upResult = m_DataCenterLinux->StartupInterface(m_vParameter[0].adapterTypeUp);
                    ENMUtil::Log(logFile, wxString::Format(wxT("In SwitchAdapterThread:startup result is %d\n"), upResult));
                    if ( upResult )
                    {
                        DCS_CloseWlanConnection();
                    }
                }
                else
                {
                    upResult = false;
                }
            }

            if ( NULL != m_vParameter[0].handler )
            {
//                if ( ADAPTER_WIRED == m_vParameter[0].adapterTypeDown
//                    && ADAPTER_WIREDLESS == m_vParameter[0].adapterTypeUp
//                    && (NETWORK_MODE_WIRED_LAN_CONNECT == m_DataCenterLinux->m_CurrentNetworkMode
//                    || NETWORK_MODE_WIRED_LAN_DISCONNECT == m_DataCenterLinux->m_CurrentNetworkMode
//                    || NETWORK_MODE_DISCONNECTED == m_DataCenterLinux->m_CurrentNetworkMode) )
//                {
//                    wxSleep(5);
//                }
                SwitchAdapterEvent event(m_vParameter[0].adapterTypeDown, m_vParameter[0].adapterTypeUp, upResult);
//                event.m_bSwitchResult = upResult;
                ::wxPostEvent(m_vParameter[0].handler, event);
            }

            m_vParameter.erase(m_vParameter.begin());
        }
    }

    return NULL;
}

void DataCenterLinux::SwitchAdapterThread::OnExit()
{

}

void DataCenterLinux::SwitchAdapterParameter(ADAPTER_TYPE adapterTypeDown, ADAPTER_TYPE adapterTypeUp, wxEvtHandler* handler)
{
    SwitchAdapterThread::SwitchAdapter switchAdapter;
    switchAdapter.adapterTypeDown = adapterTypeDown;
    switchAdapter.adapterTypeUp = adapterTypeUp;
    switchAdapter.handler = handler;
    m_pSwitchAdapterThread->m_vParameter.push_back(switchAdapter);
}

DataCenterLinux::GetCurAPThread::GetCurAPThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinuxForGetAP = pDataCenterLinux;
    m_getFlag = true;
}

DataCenterLinux::GetCurAPThread::~GetCurAPThread()
{
}

void* DataCenterLinux::GetCurAPThread::Entry()
{
    while ( m_getFlag )
    {
        if ( m_vGetAP.empty() )
        {
            wxThread::Sleep(500);
        }
        else
        {
            if ( m_DataCenterLinuxForGetAP->m_pAPStatus == NULL )
            {
                m_DataCenterLinuxForGetAP->m_pAPStatus = new APStatus();
            }
            DCS_GetCurrentAP(m_DataCenterLinuxForGetAP->m_pAPStatus);
            m_vGetAP.erase(m_vGetAP.begin());

        }
    }
    return NULL;
}

void DataCenterLinux::GetCurAPThread::OnExit()
{

}

void DataCenterLinux::GetCurAPParameter()
{
    m_pGetCurAPThread->m_vGetAP.push_back(1);
}

DataCenterLinux::ConnectAPThread::ConnectAPThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinuxForConAP = pDataCenterLinux;
}

DataCenterLinux::ConnectAPThread::~ConnectAPThread()
{
}

void* DataCenterLinux::ConnectAPThread::Entry()
{
    ENMUtil::Log(logFile, _T("Enter ConnectAPThread::Entry"));
    if ( strlen((const char*)(m_DataCenterLinuxForConAP->m_connectInfo.ssid.dcsString)) != 0 )
    {
        ENMUtil::Log(logFile, _T("ConnectAPThread::Entry-->DCS_ConnectAP(m_DataCenterLinuxForConAP->m_connectInfo)"));
        DCS_ConnectAP(m_DataCenterLinuxForConAP->m_connectInfo);
    }
    ENMUtil::Log(logFile, _T("Leave ConnectAPThread::Entry"));
    return NULL;
}

void DataCenterLinux::ConnectAPThread::OnExit()
{

}

void DataCenterLinux::SetShowBalloonFlag(bool isShown)
{
    m_isNetworkDlgTurnWireless = isShown;
}

void DataCenterLinux::SetAutoWirelessFlag(bool m_isAutoWireless)
{
    m_isAutoWireless = m_isAutoWireless;
}

DataCenterLinux::ScanThread::ScanThread(DataCenterLinux* pDataCenterLinux) : wxThread()
{
    m_DataCenterLinuxForScanAP = pDataCenterLinux;
}

DataCenterLinux::ScanThread::~ScanThread()
{
}

void* DataCenterLinux::ScanThread::Entry()
{
    DCS_GetAPList(&(m_DataCenterLinuxForScanAP->m_apList));
    ScanEvent event(ID_SCAN_OVER);
    ::wxPostEvent(m_DataCenterLinuxForScanAP, event);
    return NULL;
}

void DataCenterLinux::ScanThread::OnExit()
{
}

void CALLBACK LanChangeCallBack(BOOL* LanChanged)
{
    ENMUtil::Log(logFile, _T("enter LanChangeCallBack"));
    if ( *LanChanged )
    {
        ENMUtil::Log(logFile, _T("enter LanChangeCallBack--->enable lan"));
        ((DataCenterLinux*) DataCenter::GetInstance())->m_LanIsEnable = true;
//        DCS_SearchAdapter();
//        DCS_UpAdapter(DCS_ADAPTER_WIRED);
    }
    else
    {
        ENMUtil::Log(logFile, _T("enter LanChangeCallBack--->disable lan"));
        ((DataCenterLinux*) (DataCenter::GetInstance()))->m_LanIsEnable = false;
    }
    ENMUtil::Log(logFile, _T("leave LanChangeCallBack"));
}

void CALLBACK WlanChangeCallBack(BOOL* WlanChanged)
{
    ENMUtil::Log(logFile, _T("enter WlanChangeCallBack"));
    if ( *WlanChanged )
    {
        ENMUtil::Log(logFile, _T("in WlanChangeCallBack--->enable wlan"));
        ((DataCenterLinux*) DataCenter::GetInstance())->m_WlanIsEnable = true;
//        DCS_SearchAdapter();
//        DCS_UpAdapter(DCS_ADAPTER_WIREDLESS);
    }
    else
    {
        ENMUtil::Log(logFile, _T("in WlanChangeCallBack--->disable wlan"));
        ((DataCenterLinux*) DataCenter::GetInstance())->m_WlanIsEnable = false;
    }
    ENMUtil::Log(logFile, _T("leave WlanChangeCallBack"));
}

void CALLBACK DisableAdapterCallBack(BOOL* DisableAdapter)
{
    ENMUtil::Log(logFile, _T("enter DisableAdapterCallBack"));
    if ( *DisableAdapter )
    {
        ENMUtil::Log(logFile, _T("in DisableAdapterCallBack--->disable wlan"));
        DCS_DispatchDisableEvent(DCS_ADAPTER_WIREDLESS);
    }
    else
    {
        ENMUtil::Log(logFile, _T("in DisableAdapterCallBack--->disable lan"));
        DCS_DispatchDisableEvent(DCS_ADAPTER_WIRED);
    }
    ENMUtil::Log(logFile, _T("leave DisableAdapterCallBack"));
}
