/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "KeyDialog.h"

#include <wx/msgdlg.h>

const int KeyDialog::ID_BTN_OK = ::wxNewId();
const int KeyDialog::ID_BTN_CANCEL = ::wxNewId();

BEGIN_EVENT_TABLE(KeyDialog,wxDialog)
    EVT_INIT_DIALOG(KeyDialog::OnInit)
    EVT_BUTTON(ID_BTN_OK, KeyDialog::OnButtonClick)
    EVT_BUTTON(ID_BTN_CANCEL, KeyDialog::OnButtonClick)
END_EVENT_TABLE()

KeyDialog::KeyDialog(wxWindow* parent, bool ifEnableKeyIdx)
        : wxDialog(), m_strKey(_T(""))
{
	Create(parent, wxID_ANY, _("Connect to Wireless Network"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE);
	int width = 420, height = 176;
	int margin = 10, vm = 6;
	SetClientSize(wxSize(width, height));
	wxSize labelSize(110, 20);
	wxSize editSize(width - labelSize.GetWidth() - margin * 3, 26);

	int x = margin, y = margin;
	m_pStxLabel1 = new wxStaticText(this, wxID_ANY, _("Please enter network key."), wxPoint(x, y), wxSize(width - margin * 2, labelSize.GetHeight()));

	x = margin;
	y += labelSize.GetHeight() + vm;
	m_pStxLabel2 = new wxStaticText(this, wxID_ANY, _("Key:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_txtKey = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxPoint(x, y), editSize, wxTE_PASSWORD);
	m_txtKey->SetMaxLength(32);

	x = margin;
	y += editSize.GetHeight() + vm;
	m_pStxLabel3 = new wxStaticText(this, wxID_ANY, _("Confirm Key:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_txtConfirmKey = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxPoint(x, y), editSize, wxTE_PASSWORD);
	m_txtConfirmKey->SetMaxLength(32);

	x = margin;
	y += editSize.GetHeight() + vm;
	m_pStxLabel4 = new wxStaticText(this, wxID_ANY, _("Key Index:"), wxPoint(x, y + 3), labelSize);
	x += labelSize.GetWidth() + margin;
	m_cbbIndex = new wxComboBox(this, wxID_ANY, wxEmptyString, wxPoint(x, y), wxSize(60, editSize.GetHeight()), 0, 0, wxCB_READONLY);
	m_cbbIndex->Append(_T("1"));
	m_cbbIndex->Append(_T("2"));
	m_cbbIndex->Append(_T("3"));
	m_cbbIndex->Append(_T("4"));
	m_cbbIndex->SetValue(_T("1"));
    m_cbbIndex->Enable(ifEnableKeyIdx);

    wxSize btnSize(90, 30);
    x = width - (btnSize.GetWidth() + margin) * 2;
    y = height - btnSize.GetHeight() - margin;
#if defined(__WXMSW__)
    m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(x, y), btnSize);
    x += btnSize.GetWidth() + margin;
    m_btnCancel = new wxButton(this, ID_BTN_CANCEL, _("Cancel"), wxPoint(x, y), btnSize);
#endif
#if defined(__UNIX__)
    m_btnCancel = new wxButton(this, ID_BTN_CANCEL, _("Cancel"), wxPoint(x, y), btnSize);
    x += btnSize.GetWidth() + margin;
    m_btnOK = new wxButton(this, ID_BTN_OK, _("OK"), wxPoint(x, y), btnSize);
#endif
	m_btnOK->SetDefault();
	Center();
}

KeyDialog::~KeyDialog()
{
}

void KeyDialog::OnInit(wxInitDialogEvent& event)
{
    m_txtKey->SetFocus();
}

wxString KeyDialog::GetKey() const
{
    return m_strKey;
}

int KeyDialog::GetIdx() const
{
    long inx;
    m_cbbIndex->GetValue().ToLong(&inx);
    return (int)inx;
}

void KeyDialog::OnButtonClick(wxCommandEvent& event)
{
    int buttonId = event.GetId();
    if ( buttonId == ID_BTN_OK )
    {
        wxString strKey = m_txtKey->GetValue();
        wxString strConfirmKey = m_txtConfirmKey->GetValue();
        if ( strKey.IsEmpty() )
        {
            wxMessageDialog msg(this, _("Please input a key!"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            return;
        }
        if ( !strKey.IsAscii() )
        {
            wxMessageDialog msg(this, _("Illegal characters detected!"), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            return;
        }
        if ( strKey.Cmp(strConfirmKey) != 0 )
        {
            wxMessageDialog msg(this, _("The network keys you typed do not match."), wxEmptyString, wxOK | wxICON_INFORMATION);
            msg.ShowModal();
            return;
        }
        m_strKey = m_txtKey->GetValue();
    }
    else
    {
        m_strKey = _T("");
    }
    if ( buttonId == ID_BTN_OK )
    {
        EndModal(wxID_OK);
    }
    else
    {
        EndModal(wxID_CANCEL);
    }

}
