/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_OTHER_SETTINGS_H_
#define _PROFILE_OTHER_SETTINGS_H_

#include <wx/wizard.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/statbox.h>
#include <wx/statbmp.h>
#include <wx/button.h>

#include "ProfileEditor.h"
#include "net.h"

class ProfileOtherSettings : public wxWizardPageSimple
{
public:
    ProfileOtherSettings(wxWizard *wizard);
    ~ProfileOtherSettings();

    wxCheckBox* m_checkboxIP;
    wxCheckBox* m_checkboxProxy;
    wxCheckBox* m_checkboxNs;
    wxCheckBox* m_checkboxApp;
    wxCheckBox* m_checkboxHp;
    wxTextCtrl* m_textHp;

    wxString m_strIP;
    wxString m_strSubMask;
    wxString m_strGateWayAddr;
    wxString m_strDNS;
    wxString m_strProxy;
    wxString m_strPort;
    wxString m_strUserName;
    wxString m_strPassword;

    NetworkSecuritySet_t m_securitySet;
    IPDNSSet_t m_ipSet;
    void SetProfileType(ADAPTER_TYPE adapterType);
    OtherSettings_t GetProfileOtherSetting();
    bool ValidateHomepage() const;

private:
    static const long ID_PROXYCHECKBOX;
    static const long ID_HPCHECKBOX;
    static const long ID_IPCHECKBOX;
    static const long ID_APPCHECKBOX;
    static const long ID_NSCHECKBOX;
    static const long ID_SET3BUTTON;
    static const long ID_SET4BUTTON;
    static const long ID_SET2BUTTON;
    static const long ID_SET1BUTTON;
    static const long ID_HPTEXTCTRL;

    wxStaticText* m_textDes3;
    wxStaticText* m_textOs;
    wxStaticBox* m_staticboxBrowser;
    wxStaticLine* m_lineSt3;
    wxStaticBitmap* m_sbPic;
    wxButton* m_buttonSet1;
    wxButton* m_buttonSet2;
    wxButton* m_buttonSet3;
    wxButton* m_buttonSet4;
    wxWizard* m_pWizard;

    vector<wxString> m_strAppPath;
    string m_strForbidShareFileAndPrint;
    string m_strForbidShareInternet;
    string m_strStartWindowFirewall;

    void Onm_cbNetworkSecrityClick(wxCommandEvent& event);
    void Onm_cbAppClick(wxCommandEvent& event);
    void Onm_cbDefaultClick(wxCommandEvent& event);
    void Onm_cbHomePageClick(wxCommandEvent& event);
    void Onm_cbProxyClick(wxCommandEvent& event);

    void Onm_Set1Click(wxCommandEvent& event);
    void Onm_Set2Click(wxCommandEvent& event);
    void Onm_Set3Click(wxCommandEvent& event);
    void Onm_Set4Click(wxCommandEvent& event);

    void OnInit(wxInitDialogEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_OTHER_SETTINGS_H_
