/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _SCAN_NETWORK_DIALOG_H
#define _SCAN_NETWORK_DIALOG_H

#include <wx/stattext.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/bmpbuttn.h>
#include <wx/timer.h>

#include "wlan.h"
#include "wlanacmevent.h"
#include "IconPositionCalculator.h"
#include "AccessPointSorter.h"
#include "GaugeDialog.h"
#include <wx/imaglist.h>

const int MAX_AP_BUTTON_COUNT = 38;
const int MAX_AP_BUTTON_ID = wxID_HIGHEST + 0x0800;
const wxSize AP_ICON_SIZE(24, 24);
const wxSize AP_LABEL_SIZE(80, 16);

struct DetectedIcon
{
    APStatus ap;
    wxBitmapButton* button;
    wxStaticText* txtLabel;
    wxString label;
};

class ScanRecorder : public wxObject
{
    public:
        ScanRecorder();
        virtual ~ScanRecorder();
        void Clear();
        int AppendAPStatus(const APStatus& pap);
        APStatus GetAPStatus(int index);

    private:
        DetectedIcon* m_aplist[MAX_AP_BUTTON_COUNT];

        friend class ScanNetworkDlg;
};

class ScanNetworkDlg : public wxDialog
{
	public:
		ScanNetworkDlg(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~ScanNetworkDlg();

		void UI_UpdateNetworkMode(NETWORK_MODE networkMode);
		void UI_UpdateNetworkStatusInfo(NETWORK_MODE networkMode, UI_NETWORK_STATUS_INFO& statusInfo);
        void UI_UpdateAPSatus(WlanResult result, const AccessPointList& apList);

        void SetDialogMode(bool forConnect = true);
        bool CloseDialog(int ret);
        bool GetSelectedNetwork(APStatus* pAp);

	protected:
		static const long ID_STATICBITMAP_BACKGROUND_IMAGE;
		static const long ID_BUTTON_REFRESH;
		static const long ID_BUTTON_CONNECT;
		static const long ID_BUTTON_CANCEL;
		static const long ID_BUTTON_DETAIL;
        static const long ID_LISTCTRL_DETAIL;
        static const long ID_SCROLLEDWINDOW;
        static const long ID_HELP;

	private:
        static const long ID_TIMER_CONNECT;
        static const long ID_TIMER_SCAN;
        static const long ID_TIMER_ALLOCATOR;
        static const int TIMER_SCAN_DELAY = 6;
        static const int TIMER_CONNECT_DELAY = 10;

		wxButton* m_btnDetail;
		wxButton* m_btnRefresh;
		wxStaticText* StaticText1;
		wxButton* m_btnConnect;
		wxButton* m_btnCancel;
        wxPanel* m_bgPanel;
		wxStaticBitmap* m_stcBackgroundImage;
		GaugeDialog* m_pGaugeDialog;

        wxImageList m_imageList;
        wxListCtrl* m_listDetail;
		wxBitmap m_bmpBackground;
		wxBitmap m_bmpAp[8];

        AccessPointList m_apArray;
        AccessPointSorter m_sorter;
        bool m_isForConnect;
        bool m_isDetail;
        bool m_isConnecting;
        int m_iSelected;

        ScanRecorder m_scanRecorder;
		IconPositionCalculator calculator;
        APStatus m_toConnect;
        APStatus m_toSelect;
        wxString m_strKey;
        int m_iKeyIdx;

		void OnButtonCancelClick(wxCommandEvent& event);
		void OnButtonRefreshClick(wxCommandEvent& event);
		void OnButtonConnectClick(wxCommandEvent& event);
		void OnInit(wxInitDialogEvent& event);
		void OnButtonDetailClick(wxCommandEvent& event);
		void OnClose(wxCloseEvent& event);

        void OnListColumnBeginDrag(wxListEvent& event);
        void OnListColumnClicked(wxListEvent& event);
		void OnListItemActivated(wxListEvent& event);
		void OnListCtrlDetailItemSelect(wxListEvent& event);
		void OnListCtrlDetailItemDeselect(wxListEvent& event);
		void OnWlanConnect(WlanAcmEvent& event);

		void OnBitmapButtonClick(wxCommandEvent& event);
		void OnBitmapButtonDblClick(wxMouseEvent& event);
        void OnBackgroundBitmapClick(wxMouseEvent& event);
        void DrawButton(const wxPoint& centerPos, int id, const wxString& label, const size_t charsOfLabel);

        void UpdateUI(const AccessPointList& apList);

        void ProcessDoubleClick();
        void ProcessBackgroundClick();
        void ConnectAP();
        void ShowDetail(bool detail = true);
        void StartRefresh();
        void RefreshIcons(int selected = -1);
        void ClearDetectedAP();
        void DeselectAllListItem();

        void LoadImages();
        unsigned int GetImageIndex(const APStatus& ap, bool selected) const;
        bool CheckSsid(APStatus* pAPStatus);
        void CreateNewWirelessProfile(const APStatus& ap, int priority, const wxString& name);

        void ShowAPInfo(const APStatus& apStatus, long nItem);
        void OnF1Press(wxCommandEvent& event);
		DECLARE_EVENT_TABLE()
};

#endif  // _SCAN_NETWORK_DIALOG_H
