/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#include "GaugeDialog.h"

#include <wx/intl.h>
#include <wx/string.h>
#include <wx/frame.h>
#include "CustomStaticText.h"
#include "ENMApp.h"

const long GaugeDialog::ID_GAUGE = wxNewId();
const long GaugeDialog::ID_STATICTEXT_LABEL = wxNewId();
const int GaugeDialog::ID_TIMER = wxNewId();

BEGIN_EVENT_TABLE(GaugeDialog, wxBitmapDialog)
	EVT_INIT_DIALOG(GaugeDialog::OnInit)
	EVT_TIMER(ID_TIMER, GaugeDialog::OnTimer)
END_EVENT_TABLE()

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
GaugeDialog::GaugeDialog(wxWindow* parent, wxWindowID id)
#if defined(__WXMSW__)
        : wxBitmapDialog(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\gauge.png"))), parent, wxEmptyString)
#else
        : wxBitmapDialog(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/gauge.png"))), parent, wxEmptyString)
#endif
        , m_timer(this, ID_TIMER)
{
	Move(wxDefaultPosition);
	m_gauge = new wxGauge(this, ID_GAUGE, 100, wxPoint(15,32), wxSize(240,16), 0, wxDefaultValidator, _T("ID_GAUGE"));
#if defined(__WXMSW__)
    m_stxLabel = new CustomStaticText(this, ID_STATICTEXT_LABEL, wxEmptyString, wxPoint(15,8), wxSize(240,14), 0, _T("ID_STATICTEXT_LABEL"));
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
#else
	m_stxLabel = new wxStaticText(this, ID_STATICTEXT_LABEL, wxEmptyString, wxPoint(15,8), wxSize(240,16), wxST_NO_AUTORESIZE);
#endif
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
GaugeDialog::~GaugeDialog()
{
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void GaugeDialog::SetProcessLabel(const wxString& label)
{
    m_stxLabel->SetLabel(label);
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
bool GaugeDialog::Show(bool show)
{
    if ( !show )
    {
        if ( HasCapture() )
        {
            ReleaseMouse();
        }
        m_timer.Stop();
    }
    return wxDialog::Show(show);
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void GaugeDialog::OnInit(wxInitDialogEvent& event)
{
#if defined(__UNIX__)
//    wxRect wxR  = ::wxGetClientDisplayRect();
//    int horizontalX = wxR.x + wxR.width/2 - this->GetSize().GetWidth()/2;
//    int verticalY = wxR.y + wxR.height/2 - this->GetSize().GetHeight()/2;
//    wxMessageBox(wxString::Format(_T("%d"), horizontalX));
//    wxMessageBox(wxString::Format(_T("%d"), verticalY));
//    this->Move(377, 270);
#else
    Center();
#endif
    m_gauge->SetValue(0);
    m_timer.Start(500, wxTIMER_CONTINUOUS);
}

/**************************************************************************************************
* Function Name :                                                                                 *
* Description  :                                                                                  *
* Date   :                                                                                        *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void GaugeDialog::OnTimer(wxTimerEvent& event)
{
    int value = m_gauge->GetValue();
    value = value >= m_gauge->GetRange() ? 0 : value + 10;
    m_gauge->SetValue(value);
}

