/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _NET_SECURITY_DIALOG_H_
#define _NET_SECURITY_DIALOG_H_

#include <wx/checkbox.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include "Profile.h"

class NetSecrityDlg: public wxDialog
{
public:
    NetSecrityDlg(wxWindow* parent, wxWindowID id = wxID_ANY);
    virtual ~NetSecrityDlg();

    NetworkSecuritySet_t GetNetworkSecuritySetting() const;
    void SetNetworkSecuritySetting(const NetworkSecuritySet_t& set);
    wxCheckBox* m_cbInternet;
    wxButton* m_btnOK;
    wxButton* m_btnCancel;
#if defined(__WXMSW__)
    wxCheckBox* m_cbFile;
    wxCheckBox* m_cbFirewall;
#endif
    NetworkSecuritySet_t m_security;

private:
    static const long ID_CBINTERNET;
    static const long ID_BTNOK;
    static const long ID_BTNCANCEL;

    void Onm_btnOKClick(wxCommandEvent& event);
    void Onm_btnCancelClick(wxCommandEvent& event);
    void OnInit(wxInitDialogEvent& event);

#if defined(__WXMSW__)
    static const long ID_CBFILE;
    static const long ID_CBFIREWALL;

    void OnCheckboxFileClicked(wxCommandEvent& event);
    void OnCheckboxFirewallClicked(wxCommandEvent& event);
#endif

    DECLARE_EVENT_TABLE()
};

#endif // _NET_SECURITY_DIALOG_H_
