/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _SSID_INPUT_DIALOG_H_
#define _SSID_INPUT_DIALOG_H_

#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/button.h>
#include <wx/dialog.h>

class SsidInputDialog: public wxDialog
{
public:

    SsidInputDialog(wxWindow* parent);
    virtual ~SsidInputDialog();

    wxString GetSsid() const;

private:
    static const long ID_STX_SSID;
    static const long ID_STATICTEXT1;
    static const long ID_TXT_SSID;
    static const int ID_BTN_OK;
    static const int ID_BTN_CANCEL;

    wxStaticText* m_stxLabel;
    wxTextCtrl* m_txtSsid;
    wxStaticText* m_stxSsid;
    wxButton* m_btnOK;
    wxButton* m_btnCancel;
    wxString m_strSsid;

    void OnButtonClick(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // _SSID_INPUT_DIALOG_H_
