/*
 * Copyright (C) 2004-2008 Geometer Plus <contact@geometerplus.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __COLLECTIONVIEW_H__
#define __COLLECTIONVIEW_H__

#include <map>

#include <ZLOptions.h>

#include "FBTextView.h"
#include "../description/BookDescription.h"
#include "../collection/BookCollection.h"

class CollectionModel;

class CollectionView : public FBTextView {

public:
	static const std::string SpecialTagAllBooks;
	static const std::string SpecialTagNoTagsBooks;

public:
	ZLBooleanOption ShowAllBooksTagOption;

public:
	CollectionView(FBReader &reader, shared_ptr<ZLPaintContext> context);
	~CollectionView();
	const std::string &caption() const;

	bool _onStylusPress(int x, int y);
	bool onStylusMove(int x, int y);
	bool onStylusMovePressed(int x, int y);
	bool onStylusRelease(int x, int y);

	void paint();
	void synchronizeModel();

	void openWithBook(BookDescriptionPtr book);

	BookCollection &collection();

	bool organizeByTags() const;

private:
	bool isSelectionEnabled() const;

	void selectBook(BookDescriptionPtr book);

	CollectionModel &collectionModel();

	void editBookInfo(BookDescriptionPtr book);
	void removeBook(BookDescriptionPtr book);
	void editTagInfo(const std::string &tag);
	void removeTag(const std::string &tag);

	enum BranchType { THIS_TAG_ONLY, TREE, TAG_AND_SUBTREE };
	bool runEditTagInfoDialog(const bool tagIsSpecial, std::string &tag, bool &editNotClone, bool &includeSubtags, const bool showIncludeSubtagsEntry, const bool hasBooks);

private:
	BookCollection myCollection;
	BookDescriptionPtr mySelectedBook;
	bool myTreeStateIsFrozen;
	bool myDoSynchronizeCollection;
	bool myDoUpdateModel;

	bool myOrganizeByTags;
	bool myShowAllBooksList;

	bool myMouseButtonPressed;

friend class RebuildCollectionRunnable;
};

inline BookCollection &CollectionView::collection() {
	return myCollection;
}

#endif /* __COLLECTIONVIEW_H__ */
