/*
 * Copyright (C) 2004-2009 Geometer Plus <contact@geometerplus.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef __FBTEXTVIEW_H__
#define __FBTEXTVIEW_H__

#include "FBView.h"

class FBReader;

class FBTextView : public FBView {

protected:
	FBTextView(FBReader &reader, shared_ptr<ZLPaintContext> context);

	bool _onStylusPress(int x, int y);
	bool onStylusMove(int x, int y);
	bool onStylusMovePressed(int x, int y);
	bool onStylusRelease(int x, int y);

private:
	bool isSelectionEnabled() const;

	bool getHyperlinkId(const ZLTextElementArea &area, std::string &id, bool &isExternal) const;

private:
	bool myScrollingInProgress;
	int myLatestUpdateY;
	ZLTime myLatestUpdateTime;
	int myScrollingSpeed;

	int myPressedX;
	int myPressedY;
};

#endif /* __FBTEXTVIEW_H__ */
