/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include <libgnomeui/libgnomeui.h>

#include "maximus-app.h"

gint
main (gint argc, gchar *argv[])
{
  MaximusApp *app;
  GnomeClient *client;
  gchar *exec[] = {"maximus"};

  g_thread_init (NULL);
  g_set_application_name ("Maximus");

  gtk_init (&argc, &argv);

  client = gnome_client_new ();
  gnome_client_set_restart_command (client, 1, exec);
  gnome_client_set_restart_style (client, GNOME_RESTART_IMMEDIATELY);

  app = maximus_app_get_default ();

  gtk_main ();

  return EXIT_SUCCESS;
}
