/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          DeviceDisableDialog.h

Description:

    This file implements class DeviceDisableDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/DeviceDisableDialog.h"
#include "include/DataMiddle.h"

//(*InternalHeaders(DeviceDisableDialog)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)
#include <wx/msgdlg.h>

//(*IdInit(DeviceDisableDialog)
const long DeviceDisableDialog::ID_STATICBITMAP1 = wxNewId();
const long DeviceDisableDialog::ID_STATICTEXT1 = wxNewId();
const long DeviceDisableDialog::ID_STATICTEXT2 = wxNewId();
const long DeviceDisableDialog::ID_CHECKBOX1 = wxNewId();
const long DeviceDisableDialog::ID_CHECKLISTBOX1 = wxNewId();
const long DeviceDisableDialog::ID_STATICLINE1 = wxNewId();
const long DeviceDisableDialog::ID_BUTTON_OK = wxNewId();
//*)

BEGIN_EVENT_TABLE(DeviceDisableDialog,wxDialog)
	//(*EventTable(DeviceDisableDialog)
	//*)
END_EVENT_TABLE()

bool DeviceDisableDialog::m_IsExist = false;

DeviceDisableDialog::DeviceDisableDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(DeviceDisableDialog)
	Create(parent, wxID_ANY, _("Power Manager Devices"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(480,325));
	StaticBitmap1 = new wxStaticBitmap(this, ID_STATICBITMAP1, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/PM-35.png"))), wxPoint(20,20), wxDefaultSize, 0, _T("ID_STATICBITMAP1"));
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("The following device(s) will be disabled under this scheme. You can manually enable the device(s) in the following list."), wxPoint(62,20), wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	StaticText1->Wrap(410);
	RecordCheckBox = new wxCheckBox(this, ID_CHECKBOX1, _("Remember my settings."), wxPoint(20,235), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
	RecordCheckBox->SetValue(true);
	DeviceCheckListBox = new wxCheckListBox(this, ID_CHECKLISTBOX1, wxPoint(20,105), wxSize(435,110), 0, 0, 0, wxDefaultValidator, _T("ID_CHECKLISTBOX1"));
	StaticLine1 = new wxStaticLine(this, ID_STATICLINE1, wxPoint(20,270), wxSize(435,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
	Button_OK = new wxButton(this, ID_BUTTON_OK, _("OK"), wxPoint(374 ,280), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_OK"));

	Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&DeviceDisableDialog::OnClose);
	//*)

    SetIcon(wxIcon(TITLE_ICON));
    Button_OK->SetDefault();

    // Set font
    wxFont StaticTextFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    StaticText1->SetFont(StaticTextFont);
    RecordCheckBox->SetFont(StaticTextFont);
    DeviceCheckListBox->SetFont(StaticTextFont);

	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&DeviceDisableDialog::OnButton_OKClick);

    m_SchemeId = 0;
    m_IsAC = 0;
}

DeviceDisableDialog::~DeviceDisableDialog()
{
	//(*Destroy(DeviceDisableDialog)
	//*)
}

bool DeviceDisableDialog::InitDlg(int schemeId, int isAC, vector<string> devicesVec)
{
    m_SchemeId = schemeId;
    m_IsAC = isAC;

    bool bRet = false;

    if ( devicesVec.size() <= 0 )
    {
        return bRet;
    }

    PowerSchemeMgmtProxy::GetInstance()->GetDevicesDesc(m_DeviceDescMap);
    string var;

    for(vector<string>::size_type index = 0; index != devicesVec.size(); ++index)
    {
        var = devicesVec[index];

        m_DevicesVec.push_back(var);

        DeviceCheckListBox->Append(PMUtility::StringToWxString(m_DeviceDescMap[var]));

        DeviceCheckListBox->Check(index);
        bRet = true;
        m_IsExist = true;
    }

    DeviceCheckListBox->SetFocus();

    return bRet;
}

void DeviceDisableDialog::OnButton_OKClick(wxCommandEvent& event)
{
    int num = DeviceCheckListBox->GetCount();
    vector<string> changedDeviceVector;

    for ( int i = 0; i < num; i++ )
    {
        if ( !DeviceCheckListBox->IsChecked(i) )
        {
            changedDeviceVector.push_back(m_DevicesVec[i]);
        }
    }

    PowerSchemeMgmtProxy::GetInstance()->SetDisabledDevices(m_SchemeId, m_IsAC, changedDeviceVector, 1);
//    // Update PM dialog UI
//    DataMiddle::GetInstance()->UpdatePMEditDlgDeviceStatus(m_IsAC, changedDeviceVector);
//    DataMiddle::GetInstance()->UpdatePMDialogDeviceStatus(m_IsAC, changedDeviceVector);

    int iResult = PowerSchemeMgmtProxy::GetInstance()->ApplyPwrScheme(m_SchemeId);

    if (APPLY_FAILED == iResult)
    {
        PowerSchemeMgmtProxy::GetInstance()->SetDisabledDevices(m_SchemeId, m_IsAC, changedDeviceVector, 0);
        m_IsExist = false;
        Destroy();

        return;
    }

     // Update PM dialog UI
    DataMiddle::GetInstance()->UpdatePMEditDlgDeviceStatus(m_IsAC, changedDeviceVector, m_SchemeId);
    DataMiddle::GetInstance()->UpdatePMDialogDeviceStatus(m_IsAC, changedDeviceVector, m_SchemeId);

    if ( !RecordCheckBox->IsChecked() )
    {
        PowerSchemeMgmtProxy::GetInstance()->SetDisabledDevices(m_SchemeId, m_IsAC, changedDeviceVector, 0);
    }

    DataMiddle::GetInstance()->UpdatePMDlgButtonStatusAfterSwitching(m_SchemeId);

    m_IsExist = false;
    Destroy();
}

void DeviceDisableDialog::OnClose(wxCloseEvent& event)
{
    m_IsExist = false;
//    DataMiddle::GetInstance()->UpdatePMDlgEditingScheme(0);
    this->Destroy();
}
