/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMDialog.cpp

Description:

    This file implements class Dialog.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#include "include/PMDialog.h"

//(*InternalHeaders(PMDialog)
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

#include <wx/accel.h>
#include <wx/msgdlg.h>
#include <wx/defs.h>
#include "include/DataMiddle.h"
#include "include/PMGlobalConstant.h"

//(*IdInit(PMDialog)
const long PMDialog::ID_STATICBITMAP_TOP = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_SCHEMENAME = wxNewId();
const long PMDialog::ID_COMBOBOX_SCHEMENAME = wxNewId();
const long PMDialog::ID_BUTTON_EDIT = wxNewId();
const long PMDialog::ID_BUTTON_DELETE = wxNewId();
const long PMDialog::ID_BUTTON_NEW = wxNewId();
const long PMDialog::ID_STATICBOX1 = wxNewId();
const long PMDialog::ID_BUTTON_OK = wxNewId();
const long PMDialog::ID_BUTTON_APPLY = wxNewId();
const long PMDialog::ID_BUTTON_CANCEL = wxNewId();
const long PMDialog::ID_STATICLINE1 = wxNewId();
const long PMDialog::ID_STATICLINE2 = wxNewId();
const long PMDialog::ID_STATICLINE3 = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_PERFORMANCE = wxNewId();
const long PMDialog::ID_STATICTEXT_LCDBRIGHTNESS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_BATTERYLIFE = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_BATTERYSETTINGS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_ACSETTINGS = wxNewId();
const long PMDialog::ID_GAUGE_DC_PEROFRMANCE = wxNewId();
const long PMDialog::ID_GAUGE_DC_LCDBRIGHTNESS = wxNewId();
const long PMDialog::ID_GAUGE_DC_BATTERYLIFE = wxNewId();
const long PMDialog::ID_GAUGE_AC_PERFORMANCE = wxNewId();
const long PMDialog::ID_GAUGE_AC_LCDBRIGHTNESS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_POWERSETTINGS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_LCDBRIGHTNESS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_LANSPEED = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_TURNOFFDISPLAY = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_ENTERSYSSTANDBY = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_WIRELESS = wxNewId();
const long PMDialog::ID_STATICTEXT_UI_LAN = wxNewId();
const long PMDialog::ID_STATICBITMAP_DC = wxNewId();
const long PMDialog::ID_STATICBITMAP_AC = wxNewId();
const long PMDialog::ID_STATICTEXT_DC_LCDBRIGHTNESS = wxNewId();
const long PMDialog::ID_STATICTEXT_DC_LANSPEED = wxNewId();
const long PMDialog::ID_STATICTEXT_DC_TURNOFFDISPLAY = wxNewId();
const long PMDialog::ID_STATICTEXT_DC_ENTERSYSSTANDBY = wxNewId();
const long PMDialog::ID_STATICTEXT_DC_WIRELESS = wxNewId();
const long PMDialog::ID_STATICTEXT_DC_LAN = wxNewId();
const long PMDialog::ID_STATICTEXT_AC_LCDBRIGHTNESS = wxNewId();
const long PMDialog::ID_STATICTEXT_AC_LANSPEED = wxNewId();
const long PMDialog::ID_STATICTEXT_AC_TURNOFFDISPLAY = wxNewId();
const long PMDialog::ID_STATICTEXT_AC_ENTERSYSSTANDBY = wxNewId();
const long PMDialog::ID_STATICTEXT_AC_WIRELESS = wxNewId();
const long PMDialog::ID_STATICTEXT_AC_LAN = wxNewId();
const long PMDialog::ID_STATICTEXT_BATTERYLIFE = wxNewId();
const long PMDialog::ID_BITMAPBUTTON1 = wxNewId();
const long PMDialog::ID_BITMAPBUTTON2 = wxNewId();
const long PMDialog::ID_BITMAPBUTTON3 = wxNewId();
//*)

BEGIN_EVENT_TABLE(PMDialog,wxDialog)
	//(*EventTable(PMDialog)
	//*)

	EVT_PAINT(PMDialog::OnPaint)
END_EVENT_TABLE()

//int PMDialog::m_iEditingSchemeId = 0;

/**constructor*/
PMDialog::PMDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
  	//(*Initialize(PMDialog)
  	Create(parent, wxID_ANY, _("Intel(R) Power Manager"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxMINIMIZE_BOX, _T("wxID_ANY"));
  	SetClientSize(wxSize(600,430));
  	//StaticBitmap_Top = new wxStaticBitmap(this, ID_STATICBITMAP_TOP, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Main_BG.png")).Rescale(wxSize(560,410).GetWidth(),wxSize(560,410).GetHeight())), wxPoint(0,5), wxSize(560,410), 0, _T("ID_STATICBITMAP_TOP"));
  	StaticText_UI_SchemeName = new wxStaticText(this, ID_STATICTEXT_UI_SCHEMENAME, _("Scheme Name:"), wxPoint(10,70), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_SCHEMENAME"));
  	ComboBox_SchemeName = new wxComboBox(this, ID_COMBOBOX_SCHEMENAME, wxEmptyString, wxPoint(150,65), wxSize(200,27), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_SCHEMENAME"));
  	Button_Edit = new wxButton(this, ID_BUTTON_EDIT, _("Edit..."), wxPoint(356,65), wxSize(70,27), 0, wxDefaultValidator, _T("ID_BUTTON_EDIT"));
  	Button_Delete = new wxButton(this, ID_BUTTON_DELETE, _("Delete"), wxPoint(430,65), wxSize(70,27), 0, wxDefaultValidator, _T("ID_BUTTON_DELETE"));
  	Button_New = new wxButton(this, ID_BUTTON_NEW, _("New..."), wxPoint(514,65), wxSize(70,27), 0, wxDefaultValidator, _T("ID_BUTTON_NEW"));
  	StaticBox1 = new wxStaticBox(this, ID_STATICBOX1, wxEmptyString, wxPoint(10,90), wxSize(572,292), 0, _T("ID_STATICBOX1"));
  	Button_OK = new wxButton(this, ID_BUTTON_OK, _("OK"), wxPoint(296,395), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_OK"));
  	Button_Apply = new wxButton(this, ID_BUTTON_APPLY, _("Apply"), wxPoint(390,395), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_APPLY"));
  	Button_Cancel = new wxButton(this, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(502,395), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
  	Button_Cancel->SetDefault();
  	StaticLine1 = new wxStaticLine(this, ID_STATICLINE1, wxPoint(10,200), wxSize(572,8), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
  	StaticLine2 = new wxStaticLine(this, ID_STATICLINE2, wxPoint(205,101), wxSize(1,282), wxLI_VERTICAL, _T("ID_STATICLINE2"));
  	StaticLine3 = new wxStaticLine(this, ID_STATICLINE3, wxPoint(405,101), wxSize(1,282), wxLI_VERTICAL, _T("ID_STATICLINE3"));
  	StaticText_UI_EffectiveOfSettings = new wxStaticText(this, ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS, _("Effective of Settings"), wxPoint(20,110), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS"));
  	StaticText_UI_Performance = new wxStaticText(this, ID_STATICTEXT_UI_PERFORMANCE, _("Performance"), wxPoint(20,134), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_PERFORMANCE"));
  	StaticText_UI_LCDBrightness = new wxStaticText(this, ID_STATICTEXT_LCDBRIGHTNESS, _("Display Brightness"), wxPoint(20,157), wxDefaultSize, 0, _T("ID_STATICTEXT_LCDBRIGHTNESS"));
  	StaticText_UI_BatteryLife = new wxStaticText(this, ID_STATICTEXT_UI_BATTERYLIFE, _("Battery Life"), wxPoint(20,180), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_BATTERYLIFE"));
  	StaticText_UI_BatterySettings = new wxStaticText(this, ID_STATICTEXT_UI_BATTERYSETTINGS, _("Battery Settings"), wxPoint(232,110), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_BATTERYSETTINGS"));
  	StaticText_UI_AC_Settings = new wxStaticText(this, ID_STATICTEXT_UI_ACSETTINGS, _("AC Settings"), wxPoint(432,110), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_ACSETTINGS"));
  	Gauge_DC_Performance = new wxGauge(this, ID_GAUGE_DC_PEROFRMANCE, 100, wxPoint(210,134), wxSize(140,18), 0, wxDefaultValidator, _T("ID_GAUGE_DC_PEROFRMANCE"));
  	Gauge_DC_LCDBrightness = new wxGauge(this, ID_GAUGE_DC_LCDBRIGHTNESS, 100, wxPoint(210,157), wxSize(140,18), 0, wxDefaultValidator, _T("ID_GAUGE_DC_LCDBRIGHTNESS"));
  	Gauge_DC_BatteryLife = new wxGauge(this, ID_GAUGE_DC_BATTERYLIFE, 100, wxPoint(210,180), wxSize(140,18), 0, wxDefaultValidator, _T("ID_GAUGE_DC_BATTERYLIFE"));
  	Gauge_AC_Performance = new wxGauge(this, ID_GAUGE_AC_PERFORMANCE, 100, wxPoint(410,134), wxSize(140,18), 0, wxDefaultValidator, _T("ID_GAUGE_AC_PERFORMANCE"));
  	Gauge_AC_LCDBrightness = new wxGauge(this, ID_GAUGE_AC_LCDBRIGHTNESS, 100, wxPoint(410,157), wxSize(140,18), 0, wxDefaultValidator, _T("ID_GAUGE_AC_LCDBRIGHTNESS"));
  	StaticText_UI_PowerSettings = new wxStaticText(this, ID_STATICTEXT_UI_POWERSETTINGS, _("Power Settings"), wxPoint(20,208), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_POWERSETTINGS"));
  	StaticText_UI_LCDBrightness2 = new wxStaticText(this, ID_STATICTEXT_UI_LCDBRIGHTNESS, _("Display Brightness:"), wxPoint(20,230), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_LCDBRIGHTNESS"));
  	StaticText_UI_LANSpeed = new wxStaticText(this, ID_STATICTEXT_UI_LANSPEED, _("LAN Speed:"), wxPoint(20,252), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_LANSPEED"));
  	StaticText_UI_TurnOffDisPlay = new wxStaticText(this, ID_STATICTEXT_UI_TURNOFFDISPLAY, _("Turn off Display:"), wxPoint(20,274), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_TURNOFFDISPLAY"));
  	StaticText_UI_EnterSysStandby = new wxStaticText(this, ID_STATICTEXT_UI_ENTERSYSSTANDBY, _("Enter System Standby:"), wxPoint(20,296), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_ENTERSYSSTANDBY"));
  	StaticText_UI_EnterSysStandby->Wrap(180);
  	StaticText_UI_Wireless = new wxStaticText(this, ID_STATICTEXT_UI_WIRELESS, _("WiFi Status:"), wxPoint(20,335), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_WIRELESS"));
  	StaticText_UI_LAN = new wxStaticText(this, ID_STATICTEXT_UI_LAN, _("LAN Status:"), wxPoint(20,357), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_LAN"));
  	StaticBitmap_DC = new wxStaticBitmap(this, ID_STATICBITMAP_DC, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Battery.png"))), wxPoint(210,110), wxDefaultSize, 0, _T("ID_STATICBITMAP_DC"));
  	StaticBitmap_AC = new wxStaticBitmap(this, ID_STATICBITMAP_AC, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/AC.png"))), wxPoint(410,110), wxDefaultSize, 0, _T("ID_STATICBITMAP_AC"));
  	StaticText_DC_LCDBrightness = new wxStaticText(this, ID_STATICTEXT_DC_LCDBRIGHTNESS, wxEmptyString, wxPoint(210,230), wxDefaultSize, 0, _T("ID_STATICTEXT_DC_LCDBRIGHTNESS"));
  	StaticText_DC_LANSpeed = new wxStaticText(this, ID_STATICTEXT_DC_LANSPEED, wxEmptyString, wxPoint(210,252), wxDefaultSize, 0, _T("ID_STATICTEXT_DC_LANSPEED"));
  	StaticText_DC_TurnOffDisplay = new wxStaticText(this, ID_STATICTEXT_DC_TURNOFFDISPLAY, wxEmptyString, wxPoint(210,274), wxDefaultSize, 0, _T("ID_STATICTEXT_DC_TURNOFFDISPLAY"));
  	StaticText_DC_EnterSYSStandby = new wxStaticText(this, ID_STATICTEXT_DC_ENTERSYSSTANDBY, wxEmptyString, wxPoint(210,296), wxDefaultSize, 0, _T("ID_STATICTEXT_DC_ENTERSYSSTANDBY"));
  	StaticText_DC_Wireless = new wxStaticText(this, ID_STATICTEXT_DC_WIRELESS, wxEmptyString, wxPoint(210,335), wxDefaultSize, 0, _T("ID_STATICTEXT_DC_WIRELESS"));
  	StaticText_DC_LAN = new wxStaticText(this, ID_STATICTEXT_DC_LAN, wxEmptyString, wxPoint(210,357), wxDefaultSize, 0, _T("ID_STATICTEXT_DC_LAN"));
  	StaticText_AC_LCDBrightness = new wxStaticText(this, ID_STATICTEXT_AC_LCDBRIGHTNESS, wxEmptyString, wxPoint(410,230), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_LCDBRIGHTNESS"));
  	StaticText_AC_LANSpeed = new wxStaticText(this, ID_STATICTEXT_AC_LANSPEED, wxEmptyString, wxPoint(410,252), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_LANSPEED"));
  	StaticText_AC_TurnOffDisplay = new wxStaticText(this, ID_STATICTEXT_AC_TURNOFFDISPLAY, wxEmptyString, wxPoint(410,274), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_TURNOFFDISPLAY"));
  	StaticText_AC_EnterSYSStandby = new wxStaticText(this, ID_STATICTEXT_AC_ENTERSYSSTANDBY, wxEmptyString, wxPoint(410,296), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_ENTERSYSSTANDBY"));
  	StaticText_AC_Wireless = new wxStaticText(this, ID_STATICTEXT_AC_WIRELESS, wxEmptyString, wxPoint(410,335), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_WIRELESS"));
  	StaticText_AC_LAN = new wxStaticText(this, ID_STATICTEXT_AC_LAN, wxEmptyString, wxPoint(410,357), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_LAN"));
  	StaticText_BatteryLife = new wxStaticText(this, ID_STATICTEXT_BATTERYLIFE, _("Not Applicable"), wxPoint(410,182), wxDefaultSize, 0, _T("ID_STATICTEXT_BATTERYLIFE"));
  	BitmapButton1 = new wxBitmapButton(this, ID_BITMAPBUTTON1, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Butt_Help_1.bmp"))), wxPoint(10,390), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BITMAPBUTTON1"));
  	BitmapButton1->SetToolTip(_("Help"));
  	BitmapButton2 = new wxBitmapButton(this, ID_BITMAPBUTTON2, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Butt_About_1.bmp"))), wxPoint(50,390), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BITMAPBUTTON2"));
  	BitmapButton2->SetToolTip(_("About Power Manager"));
  	BitmapButton3 = new wxBitmapButton(this, ID_BITMAPBUTTON3, wxBitmap(wxImage(_T("/etc/ipower-management/pictures/Butt_Options_1.bmp"))), wxPoint(90,390), wxDefaultSize, wxBU_AUTODRAW|wxNO_BORDER, wxDefaultValidator, _T("ID_BITMAPBUTTON3"));
  	BitmapButton3->SetToolTip(_("General Settings"));

  	Connect(ID_COMBOBOX_SCHEMENAME,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMDialog::OnComboBox_SchemeNameSelect);
  	Connect(ID_BUTTON_EDIT,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_EditClick);
  	Connect(ID_BUTTON_DELETE,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_DeleteClick);
  	Connect(ID_BUTTON_NEW,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_NewClick);
  	Connect(ID_BUTTON_OK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_OKClick);
  	Connect(ID_BUTTON_APPLY,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_ApplyClick);
  	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_CancelClick);
  	Connect(ID_BITMAPBUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnBitmapButtonHelpClick);
  	Connect(ID_BITMAPBUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnBitmapButtonAboutClick);
  	Connect(ID_BITMAPBUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMDialog::OnButton_OptionsClick);
  	//*)

    //////////  help   ///////////////
//    int ID_STATICTEXT1 = wxID_ANY;
//    wxHyperlinkCtrl* StaticTextHelp = new wxHyperlinkCtrl(this, ID_STATICTEXT1,  _("HELP"), _T(""), wxPoint(485,20), wxDefaultSize);
//  	wxFont StaticTextHelpFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,true,_T("Sans"),wxFONTENCODING_DEFAULT);
//  	StaticTextHelp->SetFont(StaticTextHelpFont);
//  	//StaticTextAbout->SetHoverColour(wxColour(wxT("blue")));
//  	StaticTextHelp->SetNormalColour(wxColour(wxT("blue")));
//  	StaticTextHelp->Connect(ID_STATICTEXT1, wxEVT_LEFT_UP, (wxObjectEventFunction)&PMDialog::PopHelp);
//
//    //////////  about   ///////////////
//    int ID_STATICTEXT2 = wxID_ANY;
//    wxHyperlinkCtrl* StaticTextAbout = new wxHyperlinkCtrl(this, ID_STATICTEXT2, _("ABOUT"), _("ABOUT"), wxPoint(580,20), wxDefaultSize);
//  	wxFont StaticTextAboutFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,true,_T("Sans"),wxFONTENCODING_DEFAULT);
//  	StaticTextAbout->SetFont(StaticTextAboutFont);
//  	//StaticTextAbout->SetHoverColour(wxColour(wxT("blue")));
//  	StaticTextAbout->SetNormalColour(wxColour(wxT("blue")));
//
//
//    StaticTextAbout->Connect(ID_STATICTEXT2, wxEVT_LEFT_UP, (wxObjectEventFunction)&PMDialog::PopAboutDLG);

    ////////////////////      Set the UI Strings       ////////////////////////////////////////
    //Title
    SetTitle(_("Intel(R) Power Manager"));

    // Set pictures
    SetIcon(wxIcon(TITLE_ICON));

  	BitmapButton1->SetBitmapFocus(wxBitmap(wxImage(PIC_PATH + wxT("Butt_Help_2.bmp"))));
  	BitmapButton1->SetBitmapHover(wxBitmap(wxImage(PIC_PATH + wxT("Butt_Help_2.bmp"))));
  	BitmapButton1->SetBitmapSelected(wxBitmap(wxImage(PIC_PATH + wxT("Butt_Help_3.bmp"))));//_T("pic/Butt_Help_3.bmp"))));
//    BitmapButton1->SetToolTip(_("Help"));

  	BitmapButton2->SetBitmapSelected(wxBitmap(wxImage(PIC_PATH + wxT("Butt_About_3.bmp"))));
  	BitmapButton2->SetBitmapFocus(wxBitmap(wxImage(PIC_PATH + wxT("Butt_About_2.bmp"))));
  	BitmapButton2->SetBitmapHover(wxBitmap(wxImage(PIC_PATH + wxT("Butt_About_2.bmp"))));
//  	BitmapButton2->SetToolTip(_("About"));

  	BitmapButton3->SetBitmapSelected(wxBitmap(wxImage(PIC_PATH + wxT("Butt_Options_3.bmp"))));
  	BitmapButton3->SetBitmapFocus(wxBitmap(wxImage(PIC_PATH + wxT("Butt_Options_2.bmp"))));
  	BitmapButton3->SetBitmapHover(wxBitmap(wxImage(PIC_PATH + wxT("Butt_Options_2.bmp"))));
//  	BitmapButton3->SetToolTip(_("Options"));

    Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&PMDialog::OnClose);

    Gauge_DC_Performance->SetRange(100);
    Gauge_DC_LCDBrightness->SetRange(100);
    Gauge_DC_BatteryLife->SetRange(100);
    Gauge_AC_Performance->SetRange(100);
    Gauge_AC_LCDBrightness->SetRange(100);

    // Set font
    wxFont StaticTextFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
	wxFont StaticTextBoldFont(9,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);

    StaticText_UI_SchemeName->SetFont(StaticTextFont);
    ComboBox_SchemeName->SetFont(StaticTextFont);

    StaticText_UI_AC_Settings->SetFont(StaticTextFont);
    StaticText_UI_BatterySettings->SetFont(StaticTextFont);
    StaticText_UI_PowerSettings->SetFont(StaticTextBoldFont);
    StaticText_UI_EffectiveOfSettings->SetFont(StaticTextBoldFont);

    StaticText_UI_Performance->SetFont(StaticTextFont);
    StaticText_UI_LCDBrightness->SetFont(StaticTextFont);
	StaticText_UI_BatteryLife->SetFont(StaticTextFont);
	StaticText_BatteryLife->SetFont(StaticTextFont);

	StaticText_UI_EnterSysStandby->SetFont(StaticTextFont);
    StaticText_UI_LAN->SetFont(StaticTextFont);
    StaticText_UI_LANSpeed->SetFont(StaticTextFont);
    StaticText_UI_LCDBrightness2->SetFont(StaticTextFont);
    StaticText_UI_TurnOffDisPlay->SetFont(StaticTextFont);
    StaticText_UI_Wireless->SetFont(StaticTextFont);

    StaticText_DC_LCDBrightness->SetFont(StaticTextFont);
  	StaticText_DC_LANSpeed->SetFont(StaticTextFont);
  	StaticText_DC_TurnOffDisplay->SetFont(StaticTextFont);
  	StaticText_DC_EnterSYSStandby->SetFont(StaticTextFont);
  	StaticText_DC_Wireless->SetFont(StaticTextFont);
  	StaticText_DC_LAN->SetFont(StaticTextFont);
  	StaticText_AC_LCDBrightness->SetFont(StaticTextFont);
  	StaticText_AC_LANSpeed->SetFont(StaticTextFont);
  	StaticText_AC_TurnOffDisplay->SetFont(StaticTextFont);
  	StaticText_AC_EnterSYSStandby->SetFont(StaticTextFont);
  	StaticText_AC_Wireless->SetFont(StaticTextFont);
  	StaticText_AC_LAN->SetFont(StaticTextFont);

    // Set foreground color
    StaticText_UI_AC_Settings->SetForegroundColour(wxColour(48,48,48));
    StaticText_UI_BatterySettings->SetForegroundColour(wxColour(48,48,48));
    StaticText_UI_PowerSettings->SetForegroundColour(wxColour(20,80,190));
    StaticText_UI_EffectiveOfSettings->SetForegroundColour(wxColour(20,80,190));

    //////////////////////////////////////////////////////////////////////////////////////////
    //

    wxAcceleratorEntry entries[1];

    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_BITMAPBUTTON1 );

    wxAcceleratorTable accel(1, entries);

    SetAcceleratorTable(accel);
    DataMiddle::GetInstance()->AttachPMDialog(this);
    GetVectorList();
}

/**destructor*/
PMDialog::~PMDialog()
{
	//(*Destroy(PMDialog)
	//*)

    DataMiddle::GetInstance()->DettachPMDialog();
}

/**initial the PMDialog*/
void PMDialog::Init(void)
{
    int iActiveSchemeId = 0;
    PScheme_Info pSchemeInfo = new Scheme_Info;
    pSchemeInfo->ACSettings = new Scheme_Settings;
    pSchemeInfo->DCSettings = new Scheme_Settings;

    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(iActiveSchemeId);


    pSchemeInfo->SchemeId = iActiveSchemeId;
    if(SUCCESS != PowerSchemeMgmtProxy::GetInstance()->QueryPwrScheme(pSchemeInfo) ||
        NULL == pSchemeInfo)
    {
        return;
    }

    if (NULL == pSchemeInfo)
    {
        return;
    }

    UpdateDlgUI(pSchemeInfo);

    if (pSchemeInfo)
    {
        delete pSchemeInfo;
    }

    //m_iEditSchemeId = iActiveSchemeId;

    //set the status for button
    ComboBox_SchemeName->SetFocus();
    Button_Delete->Disable();
    Button_Apply->Disable();
    Button_Cancel->SetDefault();
}

/**update the scheme combox*/
void PMDialog::UpdateSchemeNameComboList(int schemeId)
{
    ComboBox_SchemeName->Clear();

    ConfigurationFileEditor editor;
    vector<PSchemeList_t> schemeVec;

    editor.Read(schemeVec);

    for (vector<PSchemeList_t>::size_type ix = 0; ix != schemeVec.size(); ++ix)
    {
        ComboBox_SchemeName->Append(PMUtility::StringToWxString(schemeVec[ix]->name));

        if ( (schemeVec[ix]->id) == schemeId )
        {
            ComboBox_SchemeName->SetSelection(ix);
            m_iEditSchemeId = schemeId;
        }
    }
}

/**update AC setting value*/
int PMDialog::SetSelectSchemeACValue(PScheme_Settings acSchemeSettings)
{
    if (NULL == acSchemeSettings)
    {
         return 0;
    }

    //AC Settings
    int iVectorValue = 0;
    map<string, int> valueMap;

    //LCD Brightness
    iVectorValue = acSchemeSettings->LCDBrightness;
    StaticText_AC_LCDBrightness->SetLabel(PMUtility::StringToWxString(vLCDBrightnessItems[iVectorValue].Description));
    valueMap.insert(make_pair(LCD_BRIGHTNESS, iVectorValue));

    //LAN Speed
    iVectorValue = acSchemeSettings->LANSpeed;
    StaticText_AC_LANSpeed->SetLabel(PMUtility::StringToWxString(vLANSpeedItems[iVectorValue].Description));
    valueMap.insert(make_pair(LAN_SPEED, iVectorValue));

    //CloseLCD
    iVectorValue = acSchemeSettings->CloseLCD;
    StaticText_AC_TurnOffDisplay->SetLabel(PMUtility::StringToWxString(vCloseLCDItems[iVectorValue].Description));

    //Standby
    iVectorValue = acSchemeSettings->Standby;
    StaticText_AC_EnterSYSStandby->SetLabel(PMUtility::StringToWxString(vStandbyItems[iVectorValue].Description));

    //WLANStatus
    int iFlag = 0;
    iFlag = acSchemeSettings->WLANStatus;
    if (0 == iFlag)
    {
        StaticText_AC_Wireless->SetLabel(_("Disabled"));
    }
    else
    {
        StaticText_AC_Wireless->SetLabel(_("Enabled"));
    }

    //LANStatus
    iFlag = acSchemeSettings->LANStatus;
    if (0 == iFlag)
    {
        StaticText_AC_LAN->SetLabel(_("Disabled"));
    }
    else
    {
        StaticText_AC_LAN->SetLabel(_("Enabled"));
    }

    UpdateACEffectiveness(valueMap);

   return 1;
}

/**update ac effectiveness*/
int PMDialog::UpdateACEffectiveness(map<string, int>& valueMap)
{
    int percent = 0;

    PowerSchemeMgmtProxy::GetInstance()->CalculatePerformance(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_AC_Performance->SetValue(percent);


    PowerSchemeMgmtProxy::GetInstance()->CalculateDisplayBrightness(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_AC_LCDBrightness->SetValue(percent);

    return 1;
}

/**update DC setting value*/
int PMDialog::SetSelectSchemeDCValue(PScheme_Settings dcSchemeSettings)
{
    if (NULL == dcSchemeSettings)
    {
        return 0;
    }

    //DC Settings
    int iVectorValue = 0;
    map<string, int> valueMap;

    //LCD Brightness
    iVectorValue = dcSchemeSettings->LCDBrightness;
    StaticText_DC_LCDBrightness->SetLabel(PMUtility::StringToWxString(vLCDBrightnessItems[iVectorValue].Description));
    valueMap.insert(make_pair(LCD_BRIGHTNESS, iVectorValue ));

    //LAN Speed
    iVectorValue = dcSchemeSettings->LANSpeed;
    StaticText_DC_LANSpeed->SetLabel(PMUtility::StringToWxString(vLANSpeedItems[iVectorValue].Description));
    valueMap.insert(make_pair(LAN_SPEED, iVectorValue));

    //CloseLCD
    iVectorValue = dcSchemeSettings->CloseLCD;
    StaticText_DC_TurnOffDisplay->SetLabel(PMUtility::StringToWxString(vCloseLCDItems[iVectorValue].Description));

    //Standby
    iVectorValue = dcSchemeSettings->Standby;
    StaticText_DC_EnterSYSStandby->SetLabel(PMUtility::StringToWxString(vStandbyItems[iVectorValue].Description));

    //WLANStatus
    int iFlag = 0;
    iFlag = dcSchemeSettings->WLANStatus;
    if (0 == iFlag)
    {
        StaticText_DC_Wireless->SetLabel(_("Disabled"));
    }
    else
    {
        StaticText_DC_Wireless->SetLabel(_("Enabled"));
    }

    //LANStatus
    iFlag = dcSchemeSettings->LANStatus;

    if (0 == iFlag)
    {
        StaticText_DC_LAN->SetLabel(_("Disabled"));
    }
    else
    {
        StaticText_DC_LAN->SetLabel(_("Enabled"));
    }

    UpdateDCEffectiveness(valueMap);

    return 1;
}

/**update dc effectiveness*/
int PMDialog::UpdateDCEffectiveness(map<string, int>& valueMap)
{
    int percent = 0;

    PowerSchemeMgmtProxy::GetInstance()->CalculatePerformance(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_DC_Performance->SetValue(percent);

    PowerSchemeMgmtProxy::GetInstance()->CalculateDisplayBrightness(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_DC_LCDBrightness->SetValue(percent);

    PowerSchemeMgmtProxy::GetInstance()->CalculateBatteryLife(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_DC_BatteryLife->SetValue(percent);

    return 1;
}

/**get settings item*/
int PMDialog::GetVectorList(void)
{
    SETTING_ITEM_MAPPING schemeItemsMap;

    PowerSchemeMgmtProxy::GetInstance()->GetSettingItems(schemeItemsMap);
    if (schemeItemsMap.empty())
    {
        return -1;
    }

    vLCDBrightnessItems = schemeItemsMap[LCD_BRIGHTNESS];
    vLANSpeedItems = schemeItemsMap[LAN_SPEED];
    vCloseLCDItems = schemeItemsMap[CLOSE_LCD];
    vStandbyItems = schemeItemsMap[STANDBY];

    return 1;
}

/**update dialog UI*/
void PMDialog::UpdateDlgUI(PScheme_Info pSchemeInfo)
{

    // Update scheme name list
    UpdateSchemeNameComboList(pSchemeInfo->SchemeId);

    SetSelectSchemeDCValue(pSchemeInfo->DCSettings);

    SetSelectSchemeACValue(pSchemeInfo->ACSettings);
}

/**Options button click event handler*/
void PMDialog::OnButton_OptionsClick(wxCommandEvent& event)
{
    OptionsDialog *pOption = DataMiddle::GetInstance()->GetOptionsDlgInstance();

    if (NULL == pOption)
    {
        pOption = new OptionsDialog(this);
        pOption->ShowModal();
    }
    else
    {
        pOption->Raise();
    }

}

/**Edit button click event handler*/
void PMDialog::OnButton_EditClick(wxCommandEvent& event)
{
    PMEditDialog *pPMEdit = DataMiddle::GetInstance()->GetPMEditDlgInstance();
    if (NULL == pPMEdit)
    {
        if ((DeviceDisableDialog::m_IsExist))
        {
            return;
        }
        pPMEdit = new PMEditDialog(this);
//        m_iEditingSchemeId = m_iEditSchemeId;
        int isAC = 0;

        if (BatteryInfoMgmtProxy::PM_GetACAdapterStatus() == 1)
        {
            isAC = 1;
        }
        pPMEdit->Init(m_iEditSchemeId, isAC);
        pPMEdit->ShowModal();
    }
    else
    {
        pPMEdit->Raise();
    }
}

/**New button click event handler*/
void PMDialog::OnButton_NewClick(wxCommandEvent& event)
{
    if ((DeviceDisableDialog::m_IsExist))
    {
        return;
    }

    int maxNum = 0;
    PowerSchemeMgmtProxy::GetInstance()->GetMaxNumberOfSchemes(maxNum);

    ConfigurationFileEditor editor;
    vector<PSchemeList_t> schemeVec;
    editor.Read(schemeVec);
    if ( schemeVec.size() >= static_cast<unsigned int>(maxNum) )
    {
        wxMessageBox(_("Maximum number of power scheme reached. Delete unused schemes before creating new one."),
                _T(""),
                wxICON_WARNING | wxOK ,
                this);
        return;
    }

    PMNew1Dialog wizard(this);
    wizard.RunWizard(wizard.GetFirstPage());

    UpdateSchemeNameComboList(m_iEditSchemeId);
}

/**update device status*/
void PMDialog::UpdateDevicesStatus(int isAC, vector<string> &deviceVector, int schemeId)
{
    if (//(m_iEditingSchemeId != m_iEditSchemeId) ||
        (m_iEditSchemeId != schemeId) ||
        (deviceVector.size() <= 0))
    {
        return;
    }

    if (1 == isAC)
    {
        for (vector<string>::size_type ix = 0; ix != deviceVector.size(); ++ix)
        {
            string varName = deviceVector[ix];

            if (0 == varName.compare(LAN_STATUS))
            {
                 StaticText_AC_LAN->SetLabel(_("Enabled"));
            }

             if (0 == varName.compare(WLAN_STATUS))
            {
                 StaticText_AC_Wireless->SetLabel(_("Enabled"));
            }
        }
    }
    else
    {
        for (vector<string>::size_type ix = 0; ix != deviceVector.size(); ++ix)
        {
            string varName = deviceVector[ix];

            if (0 == varName.compare(LAN_STATUS))
            {
                 StaticText_DC_LAN->SetLabel(_("Enabled"));
            }

             if (0 == varName.compare(WLAN_STATUS))
            {
                 StaticText_DC_Wireless->SetLabel(_("Enabled"));
            }
        }
    }
}

/**update button status*/
void PMDialog::UpdateButtonStatusAfterSwitching(int schemeId)
{
//    if (m_iEditingSchemeId == m_iEditSchemeId)
//    {
//        m_iEditingSchemeId = 0;

        Scheme_Info SchemeInfo;
        SchemeInfo.SchemeId = m_iEditSchemeId;
        PowerSchemeMgmtProxy::GetInstance()->QueryPwrScheme(&SchemeInfo);

        if (m_iEditSchemeId == schemeId )
        {
            Button_Delete->Disable();
            Button_Apply->Disable();
        }
        else if (1 == SchemeInfo.IsDefault)
        {
            Button_Delete->Disable();
            Button_Apply->Enable();
        }
        else
        {
            Button_Delete->Enable();
            Button_Apply->Enable();
        }
//    }
}

/**switch scheme handler*/
void PMDialog::SwitchPowerScheme()
{
    if (DeviceDisableDialog::m_IsExist)
    {
        return;
    }

    int isAC = 0;
    int isWarning = 0;
    int ac_adapter = BatteryInfoMgmtProxy::PM_GetACAdapterStatus();

    if (1 == ac_adapter)
    {
        isAC = 1;
    }

    ConfigurationFileEditor editor;
    editor.ReadSwitchWarning(isWarning);

    vector<string> devicesVec;
    PowerSchemeMgmtProxy::GetInstance()->GetDisabledDevices(m_iEditSchemeId, isAC, devicesVec);

    if ( (1 == isWarning) && (devicesVec.size() > 0) )
    {
        DeviceDisableDialog* dlg = new DeviceDisableDialog(this);

        if (dlg->InitDlg(m_iEditSchemeId, isAC, devicesVec))
        {
            dlg->ShowModal();
        }

    }
    else
    {
        int iResult = PowerSchemeMgmtProxy::GetInstance()->ApplyPwrScheme(m_iEditSchemeId);

        if (APPLY_FAILED == iResult)
        {
            return;
        }


//        m_iEditingSchemeId = m_iEditSchemeId;

        UpdateButtonStatusAfterSwitching(m_iEditSchemeId);
    }
}

/**OK button click event handler*/
void PMDialog::OnButton_OKClick(wxCommandEvent& event)
{
    if ((DeviceDisableDialog::m_IsExist))
    {
        return;
    }

    int iActiveSchemeId = 0;
    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(iActiveSchemeId);

    if ( iActiveSchemeId != m_iEditSchemeId )
    {
        SwitchPowerScheme();
    }

    Show(false);
//    if (!(PMTrayIcon::IsProtocolSupported()))
//    {
//        ::wxExit();
//    }
}

/**Apply button click event handler*/
void PMDialog::OnButton_ApplyClick(wxCommandEvent& event)
{
    if ((DeviceDisableDialog::m_IsExist))
    {
        return;
    }

    int iActiveSchemeId = 0;
    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(iActiveSchemeId);

    if ( iActiveSchemeId != m_iEditSchemeId )
    {
        SwitchPowerScheme();
    }
    else
    {
        Button_Apply->Disable();
    }

}

/**cancel button click event handler*/
void PMDialog::OnButton_CancelClick(wxCommandEvent& event)
{
    //Close the window without save
    Show(false);
//    if (!(PMTrayIcon::IsProtocolSupported()))
//    {
//        ::wxExit();
//    }
}

/**delete button click event handler*/
void PMDialog::OnButton_DeleteClick(wxCommandEvent& event)
{
    if ((DeviceDisableDialog::m_IsExist))
    {
        return;
    }

     if (wxMessageBox(_("Are you sure you want to delete this power scheme?"),
                _T(""),
                wxICON_QUESTION| wxCANCEL | wxOK ,
                this) == wxCANCEL )
    {
        return;
    }

	int iActiveSchemeId = 0;

     PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(iActiveSchemeId);

     if (iActiveSchemeId == m_iEditSchemeId)// || m_iEditingSchemeId == m_iEditSchemeId)
     {
         wxMessageBox(_("The active power scheme can't be deleted."),
                _T(""), wxICON_ERROR |  wxOK, this);
        return;
     }

    //Delete the Add scheme
    if (SUCCESS == PowerSchemeMgmtProxy::GetInstance()->DeletePwrScheme(m_iEditSchemeId))
    {
        ConfigurationFileEditor editor;
        editor.Delete(m_iEditSchemeId);

        DataMiddle::GetInstance()->UpdateOptionsDlgUI();

        Init();
        Button_Apply->Enable();
    }
}

/**comboBox select event handler*/
void PMDialog::OnComboBox_SchemeNameSelect(wxCommandEvent& event)
{
    //Update the data for window
    int iSchemeFlag = ComboBox_SchemeName->GetCurrentSelection();

    ConfigurationFileEditor editor;
    vector<PSchemeList_t> schemeVec;
    editor.Read(schemeVec);
    m_iEditSchemeId = schemeVec[iSchemeFlag]->id;

    PScheme_Info pSchemeInfo = new Scheme_Info;
    pSchemeInfo->ACSettings = new Scheme_Settings;
    pSchemeInfo->DCSettings = new Scheme_Settings;

    pSchemeInfo->SchemeId = m_iEditSchemeId;
    if (SUCCESS != PowerSchemeMgmtProxy::GetInstance()->QueryPwrScheme(pSchemeInfo) ||
        NULL == pSchemeInfo)
    {
        return;
    }


    SetSelectSchemeDCValue(pSchemeInfo->DCSettings);
    SetSelectSchemeACValue(pSchemeInfo->ACSettings);

    int activeSchemeId = 0;

    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(activeSchemeId);

    //The delete button is disable if the scheme is default of active
    if ( (1 == pSchemeInfo->IsDefault) || (m_iEditSchemeId == activeSchemeId) )
    {
        Button_Delete->Disable();
    }
    else
    {
        Button_Delete->Enable();
    }

    Button_Apply->Enable();

    if (NULL != pSchemeInfo->ACSettings)
    {
        pSchemeInfo->ACSettings = NULL;
    }

    if (NULL != pSchemeInfo->DCSettings)
    {
        pSchemeInfo->DCSettings = NULL;
    }

    if (NULL != pSchemeInfo)
    {
        pSchemeInfo = NULL;
    }
}

/**help button click event handler*/
void PMDialog::OnBitmapButtonHelpClick(wxCommandEvent& event)
{
    wxString helpFile;
    PowerSchemeMgmtProxy::GetInstance()->GetHelpResourceFilePath(helpFile);

    if( wxFileExists(helpFile) )
    {
        wxString cmd = wxT("evince ") + helpFile + wxT(" --page-label=1"); //PMUtility::StringToWxString(("evince ") + helpFile + (" --page-label=1"));

        wxExecute(cmd);
    }
	return;
}

/**about button click event handler*/
void PMDialog::OnBitmapButtonAboutClick(wxCommandEvent& event)
{
    AboutDialog *aboutDlg = DataMiddle::GetInstance()->GetAboutDlgInstance();

    if (NULL == aboutDlg)
    {
        aboutDlg = new AboutDialog(this);
        aboutDlg->Show();
    }
    else
    {
        aboutDlg->Raise();
    }
}

/**the dialog close event handler*/
void PMDialog::OnClose(wxCloseEvent& event)
{
    Show(false);
//    if (!(PMTrayIcon::IsProtocolSupported()))
//    {
//        ::wxExit();
//    }
}

/**the dialog paint event*/
void PMDialog::OnPaint(wxPaintEvent& WXUNUSED(event))
 {
    wxPaintDC dc(this);
    wxBitmap m_bitmap(wxImage(_T("/etc/ipower-management/pictures/Main_BG.png"),wxBITMAP_TYPE_PNG));
    dc.DrawBitmap(m_bitmap, 0, 5, TRUE);

}
