/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_POWERMANAGEMENT_API_H
#define DCS_POWERMANAGEMENT_API_H

#include "DCSCommon.h"
#include "pm/PMDef.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Gets the CPU speed. 
 *
 * @param pSpeed	the pointer to the value of CPU speed got
 */
DCSAPI DCS_Return_Code DCS_GetCPUSpeed(DCS_CPUSpeed* pSpeed);

/**
 * Sets the cpu speed.
 *
 * @param speed		the value set to the CPU Speed
 */
DCSAPI DCS_Return_Code DCS_SetCPUSpeed(DCS_CPUSpeed speed);

/**
 * Gets the LCD maximum brightness.
 *
 * @param bright	the pointer to the max brightness value got
 */
DCSAPI DCS_Return_Code DCS_GetLCDMaxBrightness(int* bright);

/**
 * Gets the LCD maximum brightness.
 *
 * @param bright	the pointer to the brightness value got
 */
DCSAPI DCS_Return_Code DCS_GetLCDBrightness(int* bright);

/** 
 * Sets the LCD brightness, bright is (0, max LCD brightness). 
 *
 * @param bright	the value set to the brightness
 */
DCSAPI DCS_Return_Code DCS_SetLCDBrightness(int bright);

/**
 * Gets wireless status. 
 *
 * @param pEnabled		the pointer to the value of wireless status got
 */
DCSAPI DCS_Return_Code DCS_GetWirelessStatus(BOOL* pEnabled);

/**
 * Gets wireless enable/disable status. 
 *
 * @param pEnabled		the pointer to the value of wireless status got
 */
DCSAPI DCS_Return_Code DCS_GetWirelessEnableStatus(BOOL* pEnabled);

/** 
 * Turns on/off wireless. 
 *
 * @param enable	the value set to the wireless status
 */
DCSAPI DCS_Return_Code DCS_SetWirelessStatus(BOOL enable);

/** 
 * Gets LAN status. 
 *
 * @param pEnabled	the pointer to the lan status value got
 */
DCSAPI DCS_Return_Code DCS_GetLANStatus(BOOL* pEnabled);

/** 
 * Gets LAN enable/disable status. 
 *
 * @param pEnabled	the pointer to the lan status value got
 */
DCSAPI DCS_Return_Code DCS_GetLANEnableStatus(BOOL* pEnabled);

/**
 * Turns on LAN. 
 *
 * @param enable	the value is alway TRUE to turn on LAN. If the value is FALSE, DCS_NOT_SUPPORT will be returned. 	 
 */
DCSAPI DCS_Return_Code DCS_SetLANStatus(BOOL enable);

/** 
 * Sets LAN speed. 
 *
 * @param speed		the value set to the lan speed
 */
DCSAPI DCS_Return_Code DCS_SetLANSpeed(DCS_Lan_Speed speed);

/** 
 * Gets LAN speed. 
 * 
 * @param pSpeed	the pointer to the lan speed value got
 */
DCSAPI DCS_Return_Code DCS_GetLANSpeed(DCS_Lan_Speed* pSpeed);

/** 
 *Don't support such function now. DCS_NOT_SUPPORTED will be returned. 
 */
DCSAPI DCS_Return_Code DCS_GetDPSTLevel(DCS_DPST* pLevel);

/**
 *Don't support such function now. DCS_NOT_SUPPORTED will be returned. 
 */
DCSAPI DCS_Return_Code DCS_SetDPSTLevel(DCS_DPST level);

/**
 * Gets the battery count. 
 *
 * @param batCount	the pointer to value of battery count got
 */
DCSAPI DCS_Return_Code DCS_GetBatteryCount(ULONG * batCount);

/** 
 * Gets the battery information. 
 *
 * @param battery	the pointer to the value of battery infomation
 * @param batIndex	the value specifying the index of battery
 */
DCSAPI DCS_Return_Code DCS_GetBatteryInfo(PDCS_Battery_Info battery, int batIndex);

/**************************************************************************** 
 * Newly added IPM interface 
 ****************************************************************************/
/** 
 * Gets the system power status. 
 *
 * @param battery	the pointer to the value of battery status
 * @param batIndex	the value specifying the index of battery
 */
DCSAPI DCS_Return_Code DCS_GetPowerStatus(PDCS_Power_Status battery);

/**
 * Applies a power scheme.
 *
 * @param schemeId	the ID of the power scheme to set active
 */
DCSAPI DCS_Return_Code DCS_SetActivePwrScheme(int schemeId);

/**
 * Get active power scheme.
 *
 * @param pSchemeId	the pointer to the value got. 
 */
DCSAPI DCS_Return_Code DCS_GetActivePwrScheme(int * pSchemeId);

/**
 * Adds a new power scheme.
 *
 * @param pName		the power scheme name
 * @param pDesc		the description of power scheme
 * @param copyFrom	the index of the power scheme copied
 * @param schemeId	pointer to the newly added power scheme ID
 */
DCSAPI DCS_Return_Code DCS_AddPwrScheme(char *pName, char *pDesc, int copyFrom, int *schemeId);

/**
 * Adds a new power scheme with the detail data infromation. This is used for speed up the register table based operation under Windows. 
 *
 * @param pSchemeDataAll		point to the structure of all of the value.
 * @param schemeId	pointer to the newly added power scheme ID
 */
DCSAPI DCS_Return_Code DCS_AddPwrScheme_All(PPM_Power_Scheme_Data_ALL pSchemeDataAll, int *schemeId);

/**
 * Gets the all of the value of the power scheme.
 *
 * @param pSchemeDataAll		point to the structure of all of the value.
 * @param schemeId	the power scheme ID
 */
DCSAPI DCS_Return_Code DCS_GetPwrVariable_All(PPM_Power_Scheme_Data_ALL pSchemeDataAll, int schemeId);


/**
 * Deletes a power scheme.
 *
 * @param schemeId	the power scheme ID
 */
DCSAPI DCS_Return_Code DCS_DeletePwrScheme(int schemeId);

/**
 * Sets a variable value in a power scheme.
 *
 * @param schemeId	the power scheme ID
 * @param isAC      \c TRUE if AC; \c FALSE if DC
 * @param pVarName	the variable name
 * @param value		the variable value to be set
 */
DCSAPI DCS_Return_Code DCS_SetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int value);

/**
 * Sets the all of the value of the power scheme.
 *
 * @param pSchemeDataAll		point to the structure of all of the value.
 */
DCSAPI DCS_Return_Code DCS_SetPwrVariable_All(PPM_Power_Scheme_Data_ALL pSchemeDataAll);

/**
 * Gets the value of the variable.
 *
 * @param schemeId	the power scheme ID
 * @param isAC      \c TRUE if AC; \c FALSE if DC
 * @param pVarName	the variable name
 * @param pValue	the pointer to the value got
 */
DCSAPI DCS_Return_Code DCS_GetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int *pValue);

/**
 * Gets the name of the power scheme by ID.
 *
 * @param schemeId		the power scheme ID
 * @param pSchemeName	the buffer to receive scheme name. 
 * @param nameSize		the buffer size of scheme name
 * @param pSchemeDesc	the buffer to receive scheme short description. 
 * @param descSize		the buffer size of scheme description
 */
DCSAPI DCS_Return_Code DCS_GetPwrSchemeNameDesc(int schemeId, char * pSchemeName,int nameSize, char * pSchemeDesc, int descSize);


/***************************************************************
 * Newly added IPM interface
 **************************************************************/
/**
 * Gets the option number of the variable.Only for Windows.
 *
 * @param pVarName	the variable name
 * @param pValue	the pointer to the value got
 */
DCSAPI DCS_Return_Code DCS_GetPwrVariableOptCount(const char *pVarName, int *pValue);

/**
 * Gets the option value of the variable. Only for Windows.
 *
 * @param pVarName	the variable name
 * @param index		the index of the option
 * @param pValue	the pointer to the value got
 */
DCSAPI DCS_Return_Code DCS_GetPwrVariableOptValue(const char *pVarName, int index, int *pValue);

/**
 * Get the user ID of current session.
 *
 * @param userID	the buffer to receive user ID.
 * @param bufSize	the buffer size of user ID.
 */
DCSAPI DCS_Return_Code DCS_GetUserID(char * userID, int bufSize);

/***************************************************************
 * Newly added IPM interface
 **************************************************************/
/**
 * Initialize configure file, set the support status of each device. Only for Windows.
 */
DCSAPI DCS_Return_Code DCS_InitCfgFile();

/**
 * Gets int value from configuration file. Only for Windows.
 *
 * @param nFlag		the flag to indicate Private or Public configuration file.
 * @param pVarFile	the configuration file name.
 * @param pVarSec	the section name
 * @param pVarItem	the item name
 * @param nDefault	the default value to be returned. 
 * @param pValue	the point to the value got. 
 */
DCSAPI DCS_Return_Code DCS_GetIntFromCfg(int nFlag, 
										 const char * pVarFile, 
										 const char * pVarSec, 
										 const char * pVarItem,
										 int nDefault, 
										 int * pValue);

/**
 * Put int value into configuration file.Only for Windows.
 *
 * @param nFlag		the flag to indicate Private or Public configuration file.
 * @param pVarFile	the configuration file name.
 * @param pVarSec	the section name
 * @param pVarItem	the item name
 * @param value		the value to be put into. 
 */
DCSAPI DCS_Return_Code DCS_PutIntIntoCfg(int nFlag, 
										 const char * pVarFile, 
										 const char * pVarSec, 
										 const char * pVarItem,
										 int value);

/**
 * Put string into configuration file.Only for Windows.
 *
 * @param nFlag		the flag to indicate Private or Public configuration file.
 * @param pVarFile	the configuration file name.
 * @param pVarSec	the section name
 * @param pVarItem	the item name
 * @param pVarValue	the string to be put into. 
 */
DCSAPI DCS_Return_Code DCS_PutStringIntoCfg(int nFlag, 
										 const char * pVarFile, 
										 const char * pVarSec, 
										 const char * pVarItem,
										 const char * pVarValue);

/**
 * Get string from configuration file. Only for Windows.
 *
 * @param nFlag		the flag to indicate Private or Public configuration file.
 * @param pVarFile	the configuration file name.
 * @param pVarSec	the section name
 * @param pVarItem	the item name
 * @param pVarValue	the buffer to receive the value. 
 * @param valueSize	the buffer size. 
 */
DCSAPI DCS_Return_Code DCS_GetStringFromCfg(int nFlag, 
										 const char * pVarFile, 
										 const char * pVarSec, 
										 const char * pVarItem,
										 char * pVarValue,
										 int valueSize);
/**
 * Typedef of the callback function to be notified when the 
 * classmate PC changes the LCD brightness. 
 *
 * @param pData		points to the current LCD Brightness
 */
typedef void (CALLBACK *DCS_PM_LCDBrightness_Callback) (int *pData);

/** 
 * Registers the callback function to be notified 
 * when the classmate PC changes the LCD brightness
 *
 * @param pCallback		the pointer to the callback function of brightness change
 */
DCSAPI DCS_Return_Code DCS_RegisterLCDBrightnessChangedCallback (DCS_PM_LCDBrightness_Callback pCallback);

/**
 * Unregisters the callback function for LCD brightness changed notifications. 
 */
DCSAPI DCS_Return_Code DCS_UnregisterLCDBrightnessChangedCallback();

/** 
 * Typedef of the callback function to be notified when the 
 * classmate PC changes the enabled/disabled status of WLAN. 
 *
 * @param pData		points to the enabled/disabled status
 */
typedef void (CALLBACK *DCS_PM_WLan_Callback) (BOOL *pData);

/** 
 * Registers the callback function to be notified  when the 
 * classmate PC changes the enabled/disabled status of WLAN.
 *
 * @param pCallback		the pointer to the callback function of wireless lan change
 */
DCSAPI DCS_Return_Code DCS_RegisterWLanChangedCallback (DCS_PM_WLan_Callback pCallback);

/** 
 * Unregisters the callback function for WLAN status changed notifications. 
 */
DCSAPI DCS_Return_Code DCS_UnregisterWLanChangedCallback();

/** 
 * Typedef of the callback function to be notified when the 
 * classmate PC changes the enabled/disabled status of LAN. 
 *
 * @param pData		points to the enabled/disabled status
 */
typedef void (CALLBACK *DCS_PM_Lan_Callback) (BOOL *pData);

/** 
 * Registers the callback function to be notified  when the 
 * classmate PC changes the enabled/disabled status of LAN.
 *
 * @param pCallback		the pointer to the callback function of lan change
 */
DCSAPI DCS_Return_Code DCS_RegisterLanChangedCallback (DCS_PM_Lan_Callback pCallback);

/** 
 * Unregisters the callback function for LAN status changed notifications. 
 */
DCSAPI DCS_Return_Code DCS_UnregisterLanChangedCallback();

/** 
 * Typedef of the callback function to be notified when the 
 * classmate PC changes the speed of LAN. 
 *
 * @param pData		points to the value of LAN speed
 */
typedef void (CALLBACK *DCS_PM_Lan_Speed_Callback) (DCS_Lan_Speed *pData);

/** 
 * Registers the callback function to be notified  when the 
 * classmate PC changes the speed of LAN.
 *
 * @param pCallback		the pointer to the callback function of lan speed change
 */
DCSAPI DCS_Return_Code DCS_RegisterLanSpeedChangedCallback (DCS_PM_Lan_Speed_Callback pCallback);

/** 
 * Unregisters the callback function for LAN speed changed notifications. 
 */
DCSAPI DCS_Return_Code DCS_UnregisterLanSpeedChangedCallback();

/**
 *post the event of down net interface to ENM
 *
 *@param pNetType the type of network adapter type
 */
DCSAPI DCS_Return_Code DCS_Down_Interface_Request(BOOL pNetType);
/** 
 * Typedef of the callback function to be notified when PM 
 *requests to shut down the network interface. 
 *
 * @param pNetType the type of network adapter type 
 */
typedef void (CALLBACK *DCS_PM_Down_Interface_Callback) (BOOL *pNetType);

/** 
 * Registers the callback function to be notified  when PM 
 *requests to shut down the network interface.
 *
 * @param pCallback		the pointer to the callback function of wireless lan change
 */
DCSAPI DCS_Return_Code DCS_RegisterDownInterfaceCallback (DCS_PM_Down_Interface_Callback pCallback);

/** 
 * Unregisters the callback function for down network interface notifications. 
 */
DCSAPI DCS_Return_Code DCS_UnregisterDownInterfaceCallback();

#ifdef __cplusplus
}
#endif /** __cplusplus */

#endif /* DCS_POWERMANAGEMENT_API_H */
