/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include "CMPC_QCPApp.h"
#include "CMPC_QCPTypeTransfer.h"
#include "CMPC_QCPDef.h"
#if defined (__UNIX__)
#include <fstream>
#include <X11/Xlib.h>
#endif

CMPC_QCPDialog* CMPC_QCPApp::m_Dlg = NULL;

IMPLEMENT_APP(CMPC_QCPApp);

/**************************************************************************************************
* Function Name : OnInit                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
bool CMPC_QCPApp::OnInit()
{
    //Check multi instance
    #if defined(__WXMSW__)
    m_checker = new wxSingleInstanceChecker(wxT("QuickController"));
    if (NULL == m_checker)
    {
        return false;
    }
    if (m_checker->IsAnotherRunning())  //Check other QCP instance
    {
        return false;
    }
    #elif defined(__UNIX__)
    CTypeTransfer SingleInstance;
    if (!SingleInstance.GetLock())
    {
        return false;
    }
    #endif

    //Getting the path of image file
    #if defined(__WXMSW__)
    m_strImagePath  = m_GetFilePath.WindowsGetFilePath();
    m_strImagePath += wxT("\\");
    #elif defined(__UNIX__)
    m_strImagePath = m_GetFilePath.LinuxGetFilePath();
    #endif

    //Get Screen width and height
    int iScreenWidth  = -1;
    int iScreenHeight = -1;
    #if defined(__WXMSW__)
    iScreenWidth  = GetSystemMetrics(SM_CXSCREEN);
    iScreenHeight = GetSystemMetrics(SM_CYSCREEN);
    #elif defined(__UNIX__)
    Display* pDisplay = XOpenDisplay(NULL);
    if (NULL == pDisplay)
    {
        return false;
    }
    XLockDisplay(pDisplay);
    int iScreen = DefaultScreen(pDisplay);//Getting Current Screen
    if (iScreen >= ScreenCount(pDisplay))
    {
        XUnlockDisplay(pDisplay);
        XCloseDisplay(pDisplay);     //Close the display
        return false;                //Invalid screen number
    }
    iScreenWidth  = DisplayWidth(pDisplay, iScreen);
    iScreenHeight = DisplayHeight(pDisplay, iScreen);
    XUnlockDisplay(pDisplay);
    XCloseDisplay(pDisplay);     //Close the display
    #endif
    wxPoint Dlgpos((iScreenWidth - QCP_UI_WIDTH), (iScreenHeight - QCP_UI_HEIGHT) / 2);

    m_pPngHandler = new wxPNGHandler();
    wxImage::AddHandler(m_pPngHandler);
    m_Dlg = new CMPC_QCPDialog(0L, wxT("QCP Application"));
    if (NULL == m_Dlg)
    {
        #if defined(__WXMSW__)
        if (NULL != m_checker)
        {
            delete m_checker;
            m_checker = NULL;
        }
        #endif
        return false;
    }
    if ( (-1 != iScreenWidth) && (-1 != iScreenHeight) )
    {
        m_Dlg->SetPosition(Dlgpos); //Set QCP position on screen
    }

    //Setting the top show of QCP
    #if defined(__WXMSW__)
    //SetWindowPos((HWND)m_Dlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
    SetWindowPos((HWND)m_Dlg, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
/*
    HWND hCurWnd = NULL;
    DWORD lMyID;
    DWORD lCurID;

    hCurWnd = ::GetForegroundWindow();
    lMyID = ::GetCurrentThreadId();
    lCurID = ::GetWindowThreadProcessId(hCurWnd, NULL);
    ::AttachThreadInput(lMyID, lCurID, TRUE);
    SetForegroundWindow(hCurWnd);
    ::AttachThreadInput(lMyID, lCurID, FALSE);*/
    #endif

    if (m_Dlg->CanSetTransparent())
    {
        FadeIn(m_Dlg); //QCP Fade in
    }
    m_Dlg->Show();  //Show QCP Main UI

    return true;
}

/**************************************************************************************************
* Function Name : GetImageFilePath                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxString CMPC_QCPApp::GetImageFilePath()
{
    return m_strImagePath;
}

/**************************************************************************************************
* Function Name : GetInstance                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
CMPC_QCPDialog *CMPC_QCPApp::GetInstance()
{
    return m_Dlg;
}

/**************************************************************************************************
* Function Name : FadeIn                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPApp::FadeIn(CMPC_QCPDialog* pQCPDlg)
{
    if (NULL == pQCPDlg)
    {
        return;
    }

    pQCPDlg->SetTransparent(0);
    pQCPDlg->FStartUpdateUITimer(30);//Start the timer for fade in of QCP
}

/**************************************************************************************************
* Function Name : FadeOut                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CMPC_QCPApp::FadeOut(CMPC_QCPDialog* pQCPDlg)
{
    if (NULL == pQCPDlg)
    {
        return;
    }

    //QCP fade out
    for (int iCount = 254; iCount >= 0; iCount -= 15)
    {
        pQCPDlg->SetTransparent(iCount);
        #if defined(__WXMSW__)
        Sleep(30);
        #elif defined(__UNIX__)
        wxMilliSleep(30);
        #endif
    }
    pQCPDlg->SetTransparent(0);
}

/**************************************************************************************************
* Function Name : OnExit                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
int CMPC_QCPApp::OnExit()
{
    if (NULL != m_Dlg)
    {
        if (m_Dlg->CanSetTransparent())
        {
            FadeOut(m_Dlg); //QCP Fade out
        }
    }

    #if defined(__WXMSW__)
    if (NULL != m_checker)
    {
        delete m_checker;
        m_checker = NULL;
    }
    #endif

    if (NULL != m_Dlg)
    {
        delete m_Dlg;
        m_Dlg = NULL;
    }

    if (NULL != m_pPngHandler)
    {
        wxImage::RemoveHandler(m_pPngHandler->GetName());
        m_pPngHandler = NULL;
    }

    return EXIT_SUCCESS;
}

#if defined (__UNIX__)
/**************************************************************************************************
* Function Name : GetLocaleFileName                                                               *
* Description  	: Get Local File Name                                                             *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
int CMPC_QCPApp::GetLocaleFileName(int langCode, wxString& fileName)
{
    wxString wxMapFile = m_strImagePath + wxT("resource/langToFile");

    string mapfile = "/usr/share/QuickController/resource/langToFile";

    mapfile = WxStringToString(wxMapFile);

    fileName = wxT("en");
    ifstream in(mapfile.c_str());

    if (!in)
    {
        return -1;
    }

    char langCodeStr[10] = {'\0'};
    snprintf(langCodeStr, 10, "%d", langCode);
    string line;

    while(getline(in, line))
    {
        string::size_type index = line.find(":");
        if (index == string::npos || index == 0)
        {
            continue;
        }

        if (0 == line.compare(0, index, langCodeStr))
        {
            fileName = StringToWxString(line.substr(index + 1));
            in.close();
            return 1;
        }
    }

    in.close();
    return -1;
}

/**************************************************************************************************
* Function Name : StringToWxString                                                               *
* Description  	: Get Local File Name                                                             *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
wxString CMPC_QCPApp::StringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}

/**************************************************************************************************
* Function Name : WxStringToString                                                               *
* Description  	: Get Local File Name                                                             *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
string CMPC_QCPApp::WxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}
#endif
