/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPMain.h

Description:
    This file implements Quick Controller UI.
        This QCPVolumeIF class has following functions.

         1.QCP_GetVolume         Get current volume
         2.QCP_SetVolume         Set the volume
         3.QCP_SetVolumeMute     Set the mute

         This CQCPScreenRotation class has following property:

         1.QCP_RotationDegreeToIndexCW   Get the rotation degree of left
         2.QCP_RotationDegreeToIndexCCW  Get the rotation degree of right

        This QCPLinuxIF class has following property:

         1.Onm_pBitmapCloseClick             Exit the Quick Controller
         2.Onm_pBitmapAboutClick             Open the About dialog
         3.Onm_pBitmapVolumeUpClick          Adjust volume up
         4.Onm_pBitmapVolumeDownClick        Adjust volume down
         5.Onm_pBitmapBrightnessUpClick      Adjust brightness up
         6.Onm_pBitmapBrightnessDownClick    Adjust brightness down
         7.Onm_pBitMuteClick                 Set the mute
         8.Onm_pBitShowCursorClick           Launch the show cursor tool
         9.Onm_pBitSwitchDisplayClick        Launch the Switch Display tool
         10.Onm_pBitCalScreenClick           Launch the Screen calibrate
         11.Onm_pBitmapCWClick               Right direction rotation
         12.Onm_pBitmapCCWClick              Left direction rotation
         13.Onm_pBtnRotationClick   Switch rotation mode

         14.OnLeftDown
         15.OnLeftUp
         16.OnMouseMove                      Get mouse move event
         17.OnMouseOver                      Get mouse over event
	     18.OnMouseLeave                     Get mouse leave event
	     19.OnTimer                          Get timer event
	     20.OnButtonMouseMove                Get button mouse move event
	     21 OnActivate                       Get widows activeate event
         22 OnActivateApp

         23 Initialize                       Get initialize information
	     24 UpdateVolumeUI                   Update current volume UI
	     25 UpdateBrightUI                   Update current Brightness UI
	     26 UpdateRotationUI                 Update current Rotation UI

Environment (opt):
    OS: Windows XP table and Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author            Date
  =====================================================================

  0.1        Create                Li ZhongFu || Chen Dequan   2008-7-20

  =====================================================================

****************************************************************************/
#ifndef CMPC_QCPMAIN_H
#define CMPC_QCPMAIN_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/button.h>
#include <wx/statline.h>

#include "CMPC_QCPDef.h"
#include "CMPC_QCPApp.h"
#include "BitmapDialog.h"
#include "ScanEvent.h" //Update UI for synchronization brightness

//Calling the interface of DCS for auto rotation and change brightness
#include "DcsSDK/QCPSDK.h"
#include "DcsSDK/SDK/tablet/TabletDef.h"

#if defined(__WXMSW__)
#include "wxCustomStatic.h"
#endif

class CMPC_QCPDialog: public wxBitmapDialog
{
    public:
        CMPC_QCPDialog(wxBitmapDialog *dlg, const wxString& title);
        ~CMPC_QCPDialog();

        int  GetBrightnessLevel();
        void SetBrightnessLevel(int iBrightness);
        void UpdateBrightUI(int iChangeLevel);  //Update the UI of brightness when the brightness changed
        void FStartUpdateUITimer(int iMilliseconds);//Starting the timer for QCP fade in
        void UpdateCursorUI(DCS_Tablet_Sensor_Data* pDeviceMode);

    private:
         int m_iBrightLevel;      //Brightness level

    private:
        void ExitQCP();           //Exite QCP
        void Initialize(void);
        void UpdateVolumeUI(void);//Init volume UI when QCP launched
        void UpdateVolumeUI(int iVolChangeLevel);//Update the UI of volume when the volume changed
        void UpdateMuteUI();      //Update the UI of mute when the mute mode changed
        void EnableVolumeButton(void);
	    void DisableVolumeButton(void);
	    void UpdateBrightUI(void);//Init brightness UI when QCP launched
	    void EnableBrightnessButton(void);
	    void DisableBrightnessButton(void);
	    void UpdateRotationUI(void);
	    void CallExternalAppInit(void); //Show/Hide Cursor, Display Switch, Touch Screen Tool
	    void SetQCPPosition(void);      //Setting the position of QCP on screen
	    bool fCheckButtonState(void);
#if defined (__UNIX__)
        void SetLocale(void);
#endif

	    void OnUpdateBrightUIForSyn(CScanEvent& Event);

        void Onm_pBitmapCloseClick(wxMouseEvent& event);
        void Onm_pBitmapAboutClick(wxMouseEvent& event);

        void Onm_pBitmapBrightnessUpClick(wxMouseEvent& event);
        void Onm_pBitmapBrightnessDownClick(wxMouseEvent& event);

        //Adjust the brightness level on progress bar
        void Onm_pBitBrightnessLev6Click(wxMouseEvent& event);
        void Onm_pBitBrightnessLev5Click(wxMouseEvent& event);
        void Onm_pBitBrightnessLev4Click(wxMouseEvent& event);
        void Onm_pBitBrightnessLev3Click(wxMouseEvent& event);
        void Onm_pBitBrightnessLev2Click(wxMouseEvent& event);
        void Onm_pBitBrightnessLev1Click(wxMouseEvent& event);
        void Onm_pBitBrightnessLev0Click(wxMouseEvent& event);

        void Onm_pBitmapVolumeUpClick(wxMouseEvent& event);
        void Onm_pBitmapVolumeDownClick(wxMouseEvent& event);

        //Adjust the volume level on progress bar
        void Onm_pBitVolumeLev6Click(wxMouseEvent& event);
	    void Onm_pBitVolumeLev5Click(wxMouseEvent& event);
	    void Onm_pBitVolumeLev4Click(wxMouseEvent& event);
	    void Onm_pBitVolumeLev3Click(wxMouseEvent& event);
	    void Onm_pBitVolumeLev2Click(wxMouseEvent& event);
	    void Onm_pBitVolumeLev1Click(wxMouseEvent& event);
	    void Onm_pBitVolumeLev0Click(wxMouseEvent& event);

        void Onm_pBitMuteClick(wxMouseEvent& event);

        void Onm_pBitShowCursorClick(wxMouseEvent& event);
        void Onm_pBitSwitchDisplayClick(wxMouseEvent& event);
        void Onm_pBitCalScreenClick(wxMouseEvent& event);
        void Onm_pBtnRotationClick(wxMouseEvent& event);
        void Onm_pBitmapCWClick(wxMouseEvent& event);
        void Onm_pBitmapCCWClick(wxMouseEvent& event);
        void Onm_pBitmapBtn180DegreeClick(wxMouseEvent& event);

        void OnLeftDown(wxMouseEvent& evt);
        void OnLeftUp(wxMouseEvent& evt);
        void OnMouseMove(wxMouseEvent& evt);
        void OnMouseOver(wxMouseEvent& event);
	    void OnMouseLeave(wxMouseEvent& event);

	    void OnRefreshUITimer(wxTimerEvent& event);//QCP fade in when the timer started
	    void OnTimer(wxTimerEvent& f_event);
	    void OnResolution(wxTimerEvent& f_event);

	    //Control 15 seconds when the mouse move on the button
	    void OnButtonMouseMove(wxMouseEvent& event);
	    void OnActivate (wxActivateEvent &event);
        void OnActivateApp (wxActivateEvent &event);

        #if defined(__WXMSW__)
        //Controling the click event of button
        void OnMouseEnter(wxMouseEvent& event);
        void OnMouseLeaveButton(wxMouseEvent& event);

        //Controling the position of QCP on screen when rotation screen
        void OnUseKeyRotation(wxEraseEvent& event);

        bool GetAppPath(HKEY thKey, wxString* AppPath, wxString lpSubKeyPath, LPTSTR FileName);
        void RedrawBitmapBtn(wxString stText, wxString stIcon, wxString stIconDisable,
            wxBitmapButton* m_pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC);
        void RedrawRotationBitmapBtn(wxString stText, wxString stIcon,
            wxBitmapButton* m_pBitmapBtn, wxBitmap* pBitmap, wxMemoryDC* pDC);
        void ButtonState(wxString drawtext, wxBitmap* bitmap,
            wxBitmap* bitmap_icon, wxBitmap* bitmap_back, wxMemoryDC* pDC, bool bDisable = FALSE);
        #endif

        static const long ID_STATICTEXTTITLE;
        static const long ID_BITMAPBUTTONCLOSE;
        static const long ID_BITMAPBUTTONABOUT;
        static const long ID_STATICBITMAPBRIGHTSTATUS;
        static const long ID_BITMAPBUTTONBRIGHTNESSUP;
        static const long ID_BITMAPBUTTONBRIGHTNESSDOWN;
        static const long ID_STBITMAPBTNBRIGHTNESS0;
        static const long ID_STBITMAPBTNBRIGHTNESS1;
        static const long ID_STBITMAPBTNBRIGHTNESS2;
        static const long ID_STBITMAPBTNBRIGHTNESS3;
        static const long ID_STBITMAPBTNBRIGHTNESS4;
        static const long ID_STBITMAPBTNBRIGHTNESS5;
        static const long ID_STBITMAPBTNBRIGHTNESS6;

        static const long ID_BITMAPBUTTONVOLUMESTATUS;
        static const long ID_BITMAPBUTTONVOLUMEDOWN;
        static const long ID_BITMAPBUTTONVOLUMEUP;
        static const long ID_STBTNMAPVOLUMELEVEL0;
        static const long ID_STBTNMAPVOLUMELEVEL1;
        static const long ID_STBTNMAPVOLUMELEVEL2;
        static const long ID_STBTNMAPVOLUMELEVEL3;
        static const long ID_STBTNMAPVOLUMELEVEL4;
        static const long ID_STBTNMAPVOLUMELEVEL5;
        static const long ID_STBTNMAPVOLUMELEVEL6;

        static const long ID_STBITMAPMUTESTATUS;
        static const long ID_BITMAPBUTTONMUTE;
        static const long ID_BITMAPBUTTONSHOWCURSOR;
        static const long ID_BITMAPBUTTONSWITCHDISPLAY;
        static const long ID_BITMAPBUTTONCALSCREEN;
        static const long ID_BITMAPBUTTONMANUALROTATION;
        static const long ID_BITMAPBUTTONCW;
        static const long ID_BITMAPBUTTONCCW;
        static const long ID_BITMAPBTN180DEGREE;

        #if defined(__UNIX__)
        //Show the image under only Linux
        static const long ID_STATICBITMAPBRIGHTNESS0;
        static const long ID_STATICBITMAPBRIGHTNESS1;
        static const long ID_STATICBITMAPBRIGHTNESS2;
        static const long ID_STATICBITMAPBRIGHTNESS3;
        static const long ID_STATICBITMAPBRIGHTNESS4;
        static const long ID_STATICBITMAPBRIGHTNESS5;
        static const long ID_STATICBITMAPBRIGHTNESS6;

        static const long ID_STATICBITMAPVOLUME0;
        static const long ID_STATICBITMAPVOLUME1;
        static const long ID_STATICBITMAPVOLUME2;
        static const long ID_STATICBITMAPVOLUME3;
        static const long ID_STATICBITMAPVOLUME4;
        static const long ID_STATICBITMAPVOLUME5;
        static const long ID_STATICBITMAPVOLUME6;

        static const long ID_STATICTEXTMUTE;
        static const long ID_STATICTEXTSHOWCURSOR;
        static const long ID_STATICTEXTSWITCHDISPLAY;
        static const long ID_STATICTEXTCALSCREEN;
        static const long ID_STATICTEXTMANUALROTATION;

        static const long ID_STATICTBITMAPMUTE;
        static const long ID_STATICTBITMAPSHOWCURSOR;
        static const long ID_STATICTBITMAPSWITCHDISPLAY;
        static const long ID_STATICTBITMAPCALSCREEN;
        static const long ID_STATICTBITMAPMANUALROTATION;
        static const long ID_STATICTBITMAPCW;
        static const long ID_STATICTBITMAPCCW;
        static const long ID_STBIT180DEGREE;
        #endif

        //(*Declarations(CMPC_QCPDialog)
        wxBitmapButton* m_pBitmapClose;
        wxBitmapButton* m_pBitmapAbout;

        wxBitmapButton* m_pBitmapBrightnessUp;
        wxBitmapButton* m_pBitmapBrightnessDown;
        wxBitmapButton* m_pStBitmapBtnBrightnessLevel[BRIGHTLEVEL];//Adjust brightness level on button
        #if defined(__UNIX__)
        wxStaticBitmap* m_pStaticBitmapBrightness[BRIGHTLEVEL];
        #endif

        wxBitmapButton* m_pBitmapVolumeDown;
        wxBitmapButton* m_pBitmapVolumeUp;
        wxBitmapButton* m_pStBitmapBtnVolumeLevel[VOLUMELEVEL]; //Adjust volume level on button
        #if defined(__UNIX__)
        wxStaticBitmap* m_pStaticBitmapVolume[VOLUMELEVEL];//Show the image under only Linux
        #endif

        wxBitmapButton* m_pBitMute;
        wxBitmapButton* m_pBitShowCursor;
        wxBitmapButton* m_pBitSwitchDisplay;
        wxBitmapButton* m_pBitCalScreen;
        wxBitmapButton* m_pBtnRotation;
        wxBitmapButton* m_pBitmapCW;
        wxBitmapButton* m_pBitmapCCW;
        wxBitmapButton* m_pBitmapBtn180Degree; //The screen rotation 180 degree
        wxStaticBitmap* m_pStMapMute;//Show the status of mute mode

        #if defined(__WXMSW__)
        wxCustomStatic*   m_pStaticTextTitle; //Implementation of wxCustomStatic in wxCustomStatic.h
        wxBitmap *m_pBkmapnormal;
        wxBitmap *m_pBkmapover;
        wxBitmap *m_pBkmapdown;
        wxBitmap *m_pBkmapdisable;

        wxBitmap *m_pBkmapRotationnormal;
        wxBitmap *m_pBkmapRotationover;
        wxBitmap *m_pBkmapRotationdown;
        wxBitmap *m_pBkmapRotationdisable;

        wxBitmap *m_pBkmapMute;
        wxBitmap *m_pBkmapUnMute;
        wxBitmap *m_pBkmapShowCursor;
        wxBitmap *m_pBkmapHideCursor;
        wxBitmap *m_pBkmapSwitchExternal;
        wxBitmap *m_pBkmapSwitchInternal;
        wxBitmap *m_pBkmapCalScreen;
        wxBitmap *m_pBkmapRotation;
        wxBitmap *m_pBkCWmap;
        wxBitmap *m_pBkCCWmap;
        wxBitmap *m_pBk180Degree;

        #elif defined(__UNIX__)
        wxStaticText*   m_pStaticTextTitle;

        wxStaticBitmap* m_pStaticBitmapMute;
        wxStaticBitmap* m_pStaticBitmapShowCursor;
        wxStaticBitmap* m_pStaticBitmapSwitchDisplay;
        wxStaticBitmap* m_pStaticBitmapCalScreen;
        wxStaticBitmap* m_pStaticBitmapManualRotation;
        wxStaticBitmap* m_pStaticBitMapCW;
        wxStaticBitmap* m_pStaticBitMapCCW;
        wxStaticBitmap* m_pStaticBitMap180Degree;

        wxStaticText* m_pStaticTextMute;
        wxStaticText* m_pStaticTextShowCursor;
        wxStaticText* m_pStaticTextSwitchDisplay;
        wxStaticText* m_pStaticTextCalScreen;
        wxStaticText* m_pStaticTextManualRotation;
        #endif

        bool m_bControlClick; //Controling the click event of button.
        bool m_bAboutState;   //Control 15 seconds for the About Dialog
        bool m_bNeedUpdate;
        bool m_bMuteState;
        bool m_bCursorState;
        bool m_bManualRotation;
        bool m_bVolumeSynControl;//Control the disable status of QCP UI
        bool m_bNeedEnableBar;
        bool m_bMoving;      //Control QCP moving on screen
        #if defined(__WXMSW__)
        bool m_bPreventExit;     //Prevent the close event of QCP when switch display
        bool m_bRotationIcon;
        #endif
        BOOL m_bRotationStatus;//Manual rotation:(0)  Auto rotation:(1)
        int m_iCount;          //Counter
        int m_iVolLevel;       //Volume level
        int m_iFadeInCounter;
        bool m_bDCSInitRet; //Return true: success; false: fail
        DCS_Return_Code m_RegBrightnessRet;//Register result of brightness callback function
        DCS_Return_Code m_FnKeyRet;
        DCS_Return_Code m_RegTabletRet;

        int m_iScreenWidth;    //Getting Screen width
        int m_iScreenHeight;   //Getting Screen height

        //Getting external application path
        wxString m_AppShowCursorExePath;
        wxString m_AppTSControllerPath;
        wxString m_AppSwitchDisplayExePath;
        wxString m_AppTouchToolExePath;

        wxString m_ResourcefilePath;//Getting the image file path

        wxBitmap m_bitmap;
        wxPoint  m_point;
        wxPoint  m_delta;

        wxTimer* m_pTRefreshUI;//Define the timer for QCP fade in
        wxTimer* m_pTimer;     //Control QCP exit after 15 seconds
        wxTimer* m_pResolutionTimer;    //Control Resolution and volume Syn

        wxLocale m_locale;  //Language localization

        DECLARE_EVENT_TABLE()
};

#endif // CMPC_QCPMAIN_H
