/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          LinuxHideCursor.cpp

Description:

Environment (opt):

Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================

  =====================================================================
****************************************************************************/
#include "LinuxHideCursor.h"
#include "IniFile.h"
#include "CMPC_QCPSearchFilePath.h"
#include "CMPC_QCPTypeTransfer.h"
#include <wx/utils.h>


static char *TSController = const_cast<char*>("TSController");
static char *HideCursorStr = const_cast<char*>("HideCursor");
static char *TRUESTR = const_cast<char*>("TRUE");

static char *CursorStatusStr = const_cast<char*>("CursorStatus");
static char *FALSESTR = const_cast<char*>("FALSE");
static char *FirstNum = const_cast<char*>("123");

static char *HideStr = const_cast<char*>("Hide");
static char *ShowStr = const_cast<char*>("Show");

/**************************************************************************************************
* Function Name : CHideCursor                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
CHideCursor::CHideCursor()
    :m_hiddenCursor(TRUE)
{
    CTypeTransfer TypeTransfer;
    CSearchFilePath GetFilePath;

    m_stResourcefilePath = GetFilePath.LinuxGetFilePath();
    m_sCfgFilePath = TypeTransfer.fWxStringToString(wxGetHomeDir() + wxT("/"));//Get usr's home directory
    m_sCfgFilePath += CFG_FILE;
}

/**************************************************************************************************
* Function Name : ~CHideCursor                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
CHideCursor::~CHideCursor()
{
}

/**************************************************************************************************
* Function Name : CheckCFG                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CHideCursor::CheckCFG(BOOL bMode)//Tablet:TRUE or ClamShell:FALSE
{
    CIniFile IniFile;
    if (access(m_sCfgFilePath.c_str(), F_OK) < 0) // The .cfg file not exist
	{
		int fd = open(m_sCfgFilePath.c_str(),
                        O_RDWR|O_CREAT,
                        S_IRUSR | S_IWUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);

        if ( fd != -1 )
		{
		    close(fd);
		    //if (TRUE == bMode)//Tablet
            {
                const char* str = m_sCfgFilePath.c_str();
                IniFile.Ini_WriteString(TSController, HideCursorStr, TRUESTR, str);
                IniFile.Ini_WriteString(TSController, CursorStatusStr, HideStr, str);
            }
           /* else //ClamShell
            {
                IniFile.Ini_WriteString("TSController", "HideCursor","FALSE",(char*)m_sCfgFilePath.c_str());
                IniFile.Ini_WriteString("TSController", "CursorStatus","Show", (char*)m_sCfgFilePath.c_str());
            }*/
        }
	}
}

/**************************************************************************************************
* Function Name : HideCursor                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CHideCursor::HideCursor()
{
    BOOL ret = CheckMouse();
	if (ret)  //mouse exists, don't hide
	{
		return;
	}
	CTypeTransfer TypeTransfer;
	wxString wxstAppPath = m_stResourcefilePath + wxT("resource/hidecursor.sh");
	string sAppPath = TypeTransfer.fWxStringToString(wxstAppPath);

    system(sAppPath.c_str());
}

/**************************************************************************************************
* Function Name : ShowCursor                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
void CHideCursor::ShowCursor()
{
    CTypeTransfer TypeTransfer;
	wxString wxstAppPath = m_stResourcefilePath + wxT("resource/showcursor.sh");
	string sAppPath = TypeTransfer.fWxStringToString(wxstAppPath);

    system(sAppPath.c_str());
}

/**************************************************************************************************
* Function Name : CheckMouse                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
BOOL CHideCursor::CheckMouse()
{//check if the usb mouse is plugined
	int ret = 0;
	CTypeTransfer TypeTransfer;

	wxString wxstAppPath = m_stResourcefilePath + wxT("resource/checkmouse.sh");
	string sAppPath = TypeTransfer.fWxStringToString(wxstAppPath);
	ret = system(sAppPath.c_str());
	if (ret > 0)//have mouse
	{
		return TRUE;
	}
	else // no mouse
	{
		return FALSE;
	}
}

/**************************************************************************************************
* Function Name : GetCursorStatus                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
BOOL CHideCursor::GetCursorStatus()
{
    char str_tmp[MAX_PATH];
    int iHide = INFOMGMT_ERR_PARAM;
    CIniFile IniFile;

	memset(str_tmp, 0, MAX_PATH);

    CheckCFG(TRUE); //Check the .cfg file exist;default is tablet

	if ( access(m_sCfgFilePath.c_str(), 0) ==0 ) //R_OK file exist
	{
		iHide = IniFile.Ini_ReadString(TSController, HideCursorStr, FirstNum, str_tmp, (char*)m_sCfgFilePath.c_str());
	}

	if (!(strcmp(str_tmp,"TRUE")))
	{
		m_hiddenCursor = TRUE;
		return TRUE;
	}

	m_hiddenCursor = FALSE;

	return FALSE;
}

/**************************************************************************************************
* Function Name : SetCursorStatus                                                     *
* Description  	: Init for QCP                                                                    *
* Date   	: 08/12/01                                                                            *
* Parameter     : [[EN]] None [[EN]]                                                              *
* Return Code  	:                                                                                 *
* Author   	:                                                                                     *
**************************************************************************************************/
int  CHideCursor::SetCursorStatus(BOOL bStatus)
{
    if (access(m_sCfgFilePath.c_str(),F_OK) < 0) // dir not exist
	{
		return -1;
	}
	m_hiddenCursor = bStatus;

	FILE* file;
	if ( (file = fopen(m_sCfgFilePath.c_str(),"w+")) != NULL )
	{
	    CIniFile IniFile;
		if (m_hiddenCursor == TRUE)
		{
			IniFile.Ini_WriteString(TSController, HideCursorStr, TRUESTR, (char*)m_sCfgFilePath.c_str());
			IniFile.Ini_WriteString(TSController, CursorStatusStr, HideStr, (char*)m_sCfgFilePath.c_str());
		}
		else
		{
			IniFile.Ini_WriteString(TSController, HideCursorStr,FALSESTR,(char*)m_sCfgFilePath.c_str());
			IniFile.Ini_WriteString(TSController, CursorStatusStr,ShowStr, (char*)m_sCfgFilePath.c_str());
		}
	}
	fclose(file);

	return 0;
}
