/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPDef.h

Description:
    This file defines the macro of QCP.


Environment (opt):
    OS: Windows XP table and Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                       Chen Dequan   2008-9-25

  =====================================================================

****************************************************************************/
#ifndef QCP_DEF_H_INCLUDED
#define QCP_DEF_H_INCLUDED

/****************************************************************************
Defining the width and height of QCP UI
****************************************************************************/
#define QCP_UI_WIDTH         270 //Width of QCP UI
#define QCP_UI_HEIGHT        338 //Height of QCP UI
/****************************************************************************/


/****************************************************************************
Defining the ID of timer
****************************************************************************/
#define REFRESH_UI_TIMER_ID 0    //Define the timer ID for QCP fade in
#define EXIT_TIMER_ID       1    //This timer ID is QCP exit after 15 seconds
#define RESOLUTION_TIMER_ID 2    //This timer ID is refresh the position of QCP on screen
/****************************************************************************/


/****************************************************************************
Defining time interval for the timer
****************************************************************************/
#define TIMER_RESOLUTION    300       //To time for volume synchronization
#define TIME_INTERVAL       1000 * 15 //QCP exited after 15 seconds
/****************************************************************************/


/****************************************************************************
Defining the size and position of brightness and volume progress bar
****************************************************************************/
#define PRO_BAR_SIZE_X      28    //The width of brightness progree bar and volume progree bar
#define PRO_BAR_SIZE_Y      15    //The height of brightness progree bar and volume progree bar

#if defined(__WXMSW__)

#define BRIGHT_PRO_BAR_POS_X  26  //The progress bar of Brightness start position on QCP main UI
#define VOL_PRO_BAR_POS_X     87  //The progress bar of volume start position on QCP main UI

#elif defined(__UNIX__)

#define BRIGHT_PRO_BAR_POS_X  27  //The progress bar of Brightness start position on QCP main UI
#define VOL_PRO_BAR_POS_X     89  //The progress bar of volume start position on QCP main UI
#endif

//The progress bar of volume position on QCP main UI
#define BRIGHTVOL_PRO_BAR_POS6Y 112
#define BRIGHTVOL_PRO_BAR_POS5Y 128
#define BRIGHTVOL_PRO_BAR_POS4Y 144
#define BRIGHTVOL_PRO_BAR_POS3Y 160
#define BRIGHTVOL_PRO_BAR_POS2Y 176
#define BRIGHTVOL_PRO_BAR_POS1Y 192
#define BRIGHTVOL_PRO_BAR_POS0Y 208
/****************************************************************************/


/****************************************************************************
Defining the level of brightness and volume progress bar
****************************************************************************/
#define BRIGHTLEVEL 7    //Defining the level of brightness
#define VOLUMELEVEL 7    //Defining the level of volume
/****************************************************************************/


/****************************************************************************
Defining the mode of rotation
****************************************************************************/
#define AUTOROTATION_ENABLED    1   //Auto rotation
#define AUTOROTATION_DISABLED   0   //Manual rotation
/****************************************************************************/

/*QCP debug log*/
//#define QCP_DEBUG

#endif // QCP_DEF_H_INCLUDED
