/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_ICON_H_
#define _LAUNCHER_ICON_H_

#include <glib-object.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_ICON (launcher_icon_get_type ())

#define LAUNCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_ICON, LauncherIcon))

#define LAUNCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_ICON, LauncherIconClass))

#define LAUNCHER_IS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_ICON))

#define LAUNCHER_IS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_ICON))

#define LAUNCHER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_ICON, LauncherIconClass))

typedef struct _LauncherIcon        LauncherIcon;
typedef struct _LauncherIconClass   LauncherIconClass;
typedef struct _LauncherIconPrivate LauncherIconPrivate;
 
struct _LauncherIcon
{
  ClutterGroup        parent;	

  LauncherIconPrivate *priv;
};

struct _LauncherIconClass
{
  ClutterGroupClass   parent_class;

  /*< signals />*/
  void (*category_selected) (LauncherIcon       *icon, 
                             LauncherMenuCategory *category);
};

GType launcher_icon_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_icon_new (void);

void launcher_icon_set_application (LauncherIcon            *icon, 
                                    LauncherMenuApplication *application);

gint launcher_icon_get_width_for_grid  (gint cols, gint rows);
gint launcher_icon_get_height_for_grid (gint cols, gint rows);

#endif /* _LAUNCHER_ICON_H_ */

