/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib-object.h>

#include "clutter-focus-group.h"


static void
clutter_focus_group_base_init (gpointer g_iface)
{
  static gboolean initialised = FALSE;

  if (!initialised)
  {
    GType iface_type = G_TYPE_FROM_INTERFACE (g_iface);

    initialised = TRUE;
  }
}

GType
clutter_focus_group_get_type (void)
{
  static GType focus_group_type = 0;

  if (G_UNLIKELY (!focus_group_type))
    {
      GTypeInfo focus_group_info =
      {
        sizeof (ClutterFocusGroupIface),
        clutter_focus_group_base_init,
        NULL, /* iface_finalize */
      };

      focus_group_type = g_type_register_static (G_TYPE_INTERFACE,
                                               "ClutterFocusGroup",
                                               &focus_group_info, 0);

      g_type_interface_add_prerequisite (focus_group_type, CLUTTER_TYPE_ACTOR);
    }

  return focus_group_type;
}

gboolean 
clutter_focus_group_direction_event (ClutterFocusGroup     *group,
                                     ClutterFocusDirection  dir)
{
  g_return_val_if_fail (CLUTTER_IS_FOCUS_GROUP (group), FALSE);

  CLUTTER_FOCUS_GROUP_GET_IFACE (group)->direction_event (group, dir);
}



