/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_LINK_EDITOR_H_
#define _LAUNCHER_LINK_EDITOR_H_

#include <glib-object.h>
#include <gtk/gtk.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_LINK_EDITOR (launcher_link_editor_get_type ())

#define LAUNCHER_LINK_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_LINK_EDITOR, LauncherLinkEditor))

#define LAUNCHER_LINK_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_LINK_EDITOR, LauncherLinkEditorClass))

#define LAUNCHER_IS_LINK_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_LINK_EDITOR))

#define LAUNCHER_IS_LINK_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_LINK_EDITOR))

#define LAUNCHER_LINK_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_LINK_EDITOR, LauncherLinkEditorClass))

typedef struct _LauncherLinkEditor        LauncherLinkEditor;
typedef struct _LauncherLinkEditorClass   LauncherLinkEditorClass;
typedef struct _LauncherLinkEditorPrivate LauncherLinkEditorPrivate;
 
struct _LauncherLinkEditor
{
  GtkDialog        parent;	

  LauncherLinkEditorPrivate *priv;
};

struct _LauncherLinkEditorClass
{
  GtkDialogClass   parent_class;
};

enum
{
  LINK_TYPE_WEB=0,
  LINK_TYPE_FILE,
  LINK_TYPE_APP
};


GType       launcher_link_editor_get_type (void) G_GNUC_CONST;

GtkWidget * launcher_link_editor_new      ();


#endif /* _LAUNCHER_LINK_EDITOR_H_ */

