/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_DEFINES_H_
#define _LAUNCHER_DEFINES_H_

#define CSW() (CLUTTER_STAGE_WIDTH ())
#define CSH() (CLUTTER_STAGE_HEIGHT ())

#define CAW(obj) (clutter_actor_get_width(CLUTTER_ACTOR (obj)))
#define CAH(obj) (clutter_actor_get_height(CLUTTER_ACTOR (obj)))

#define PANEL_HEIGHT 24
#define PADDING 5
#define N_CATS 13

#define CAT_FONT "Sans 8"
#define CAT_PADDING 6


#define ICONVIEW_WIDTH() (BAR_WIDTH()*3)
#define ICONVIEW_HEIGHT() (WIN_HEIGHT()-(PANEL_HEIGHT*2.3))
#define ICONVIEW_PADDING 10
#define ICONVIEW_ROWS 4
#define ICONVIEW_COLS 4

#define ICON_FONT "Sans Bold 8"
#define ICON_WIDTH() ((ICONVIEW_WIDTH()-((ICONVIEW_COLS+1)*ICONVIEW_PADDING))/ICONVIEW_COLS)
#define ICON_HEIGHT() ((ICONVIEW_HEIGHT()-((ICONVIEW_ROWS+1)*ICONVIEW_PADDING))/ICONVIEW_ROWS)

#define APP_PADDING 10
#define APP_FONT "Sans 8"
#define APP_ROWS 4
#define APP_COLS 4

#define FAVCATNAME "emblem-favorite"

#define NOTIFY_FONT "Sans Bold 9"
#define XDG_OPEN "xdg-open"

/* OLD */

#define CAT_SIZE() ((CSH()-PANEL_HEIGHT*3)/N_CATS)

#define APP_SIZE()  ((CSH()-PANEL_HEIGHT*3)/(APP_ROWS+1))
#define CAT_ICON_SIZE (CAT_SIZE())
#define APP_ICON_SIZE (APP_SIZE())

#define SIDEBAR_WIDTH() (CAT_SIZE()*2)

#define FAST_TIME 200
#define MID_TIME  200
#define SLOW_TIME 300

#endif /* _LAUNCHER_DEFINES_H_ */
