/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_SHORTCUT_H_
#define _LAUNCHER_SHORTCUT_H_

#include <glib-object.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"

#include "clutter-drag-dest.h"


#define LAUNCHER_TYPE_SHORTCUT (launcher_shortcut_get_type ())

#define LAUNCHER_SHORTCUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_SHORTCUT, LauncherShortcut))

#define LAUNCHER_SHORTCUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_SHORTCUT, LauncherShortcutClass))

#define LAUNCHER_IS_SHORTCUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_SHORTCUT))

#define LAUNCHER_IS_SHORTCUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_SHORTCUT))

#define LAUNCHER_SHORTCUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_SHORTCUT, LauncherShortcutClass))

typedef struct _LauncherShortcut        LauncherShortcut;
typedef struct _LauncherShortcutClass   LauncherShortcutClass;
typedef struct _LauncherShortcutPrivate LauncherShortcutPrivate;
 
struct _LauncherShortcut
{
  ClutterDragDest        parent;	

  LauncherShortcutPrivate *priv;
};

struct _LauncherShortcutClass
{
  ClutterDragDestClass   parent_class;

  /*< signals />*/
  void (*clicked) (LauncherShortcut *shortcut);
  void (*eject)   (LauncherShortcut *shortcut);
};

GType launcher_shortcut_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_shortcut_new (const gchar *icon,
                                      const gchar *label,
                                      gboolean     can_unmount);

void           launcher_shortcut_set_active (LauncherShortcut *shortcut,
                                             gboolean          active);

const gchar  * launcher_shortcut_get_label (LauncherShortcut *shortcut);

GdkPixbuf    * launcher_shortcut_get_icon (LauncherShortcut *shortcut);

void           launcher_shortcut_clicked  (LauncherShortcut *shortcut);

void           launcher_shortcut_set_can_eject (LauncherShortcut *shortcut,
                                                gboolean          can_eject);

#endif /* _LAUNCHER_SHORTCUT_H_ */

