/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_LAUNCHER_CONFIG_H
#define _HAVE_LAUNCHER_CONFIG_H

#include <glib.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define LAUNCHER_TYPE_CONFIG (launcher_config_get_type ())

#define LAUNCHER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        LAUNCHER_TYPE_CONFIG, LauncherConfig))

#define LAUNCHER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        LAUNCHER_TYPE_CONFIG, LauncherConfigClass))

#define LAUNCHER_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        LAUNCHER_TYPE_CONFIG))

#define LAUNCHER_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
        LAUNCHER_TYPE_CONFIG))

#define LAUNCHER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
        LAUNCHER_TYPE_CONFIG, LauncherConfigClass))

typedef struct _LauncherConfig LauncherConfig;
typedef struct _LauncherConfigClass LauncherConfigClass;
typedef struct _LauncherConfigPrivate LauncherConfigPrivate;

struct _LauncherConfig
{
  GObject       parent;

  /* Config values */
  gint          win_width;
  gint          win_height;
  gint          bar_width;

  gint          iconview_width;
  gint          iconview_height;
  gint          iconview_padding;
  gint          iconview_rows;
  gint          iconview_cols;

  gint          icon_width;
  gint          icon_height;

  gint          shortcut_height;

  gchar         font_name[300];
  
  /*< private >*/
  LauncherConfigPrivate   *priv;
};

struct _LauncherConfigClass 
{
  /*< private >*/
  GObjectClass    parent_class;

  /* <signals> */
  void (*config_changed) (LauncherConfig *config);
  void (*resume_event)   (LauncherConfig *condfig);
  
  /* future padding */
  void (*_launcher_config_1) (void);
  void (*_launcher_config_2) (void);
  void (*_launcher_config_3) (void);
  void (*_launcher_config_4) (void);
};

GType           launcher_config_get_type    (void) G_GNUC_CONST;

LauncherConfig* launcher_config_get_default (void);

G_END_DECLS

#endif /* _HAVE_LAUNCHER_CONFIG_H */
