/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CLUTTER_DRAG_DEST_H_
#define _CLUTTER_DRAG_DEST_H_

#include <glib.h>
#include <clutter/clutter.h>

#define CLUTTER_TYPE_DRAG_DEST (clutter_drag_dest_get_type ())

#define CLUTTER_DRAG_DEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CLUTTER_TYPE_DRAG_DEST, ClutterDragDest))

#define CLUTTER_DRAG_DEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CLUTTER_TYPE_DRAG_DEST, ClutterDragDestClass))

#define CLUTTER_IS_DRAG_DEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CLUTTER_TYPE_DRAG_DEST))

#define CLUTTER_IS_DRAG_DEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CLUTTER_TYPE_DRAG_DEST))

#define CLUTTER_DRAG_DEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CLUTTER_TYPE_DRAG_DEST, ClutterDragDestClass))

typedef struct _ClutterDragDest        ClutterDragDest;
typedef struct _ClutterDragDestClass   ClutterDragDestClass;
typedef struct _ClutterDragDestPrivate ClutterDragDestPrivate;
 
struct _ClutterDragDest
{
  ClutterGroup       parent;	

  ClutterDragDestPrivate *priv;
};

struct _ClutterDragDestClass
{
  ClutterGroupClass   parent_class;

  gboolean (*drop) (ClutterDragDest *dest, gpointer data);

};

GType     clutter_drag_dest_get_type (void) G_GNUC_CONST;

void      clutter_drag_dest_enable (ClutterDragDest *dest);
  
gboolean  clutter_drag_dest_drop (ClutterDragDest *dest,
                                  gpointer         data);

void      clutter_drag_dest_finish (ClutterDragDest *dest,
                                    gboolean         success);

#endif /* _CLUTTER_DRAG_DEST_H_ */

