# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>


from elisa.plugins.search.searcher import Searcher
from elisa.plugins.yesfm.constants import SERVER_NAME, API_PATH

from elisa.core import common
from elisa.core.utils import defer
from elisa.core.media_uri import MediaUri
from elisa.core.utils.i18n import install_translation
from elisa.core.resource_manager import ResourceProviderNotFound
from elisa.core.utils.cancellable_defer import cancellable_coiterate
from elisa.core.utils.sorting import async_sorted_merge, natural_cmp
from elisa.core.resource_manager import  ResourceProviderNotFound

from elisa.plugins.poblesec.search_controller import SearcherEntry

from twisted.internet import task

from urllib import quote


_ = install_translation('yesfm')


class YesfmSearcher(Searcher):
    provider_path = 'elisa.plugins.yesfm.yesfm_resource:YesfmResource'
    base_uri = "http://%s/%ssearch" % (SERVER_NAME, API_PATH)

    paths = ['music']

    def search(self, uri, model):

        provider = self._query_provider()

        if provider is None:
            msg = "Yesfm Resource Provider missing"
            return defer.fail(ResourceProviderNotFound(msg))

        query_uri = MediaUri('%s/%s' % (self.base_uri, quote(uri.filename)))

        res_model, dfr = provider.get(query_uri, None)
        dfr.addCallback(self._parse_into_model, model)
        return dfr

    def _parse_into_model(self, result, model):
        dfr = defer.succeed(None)
        if result.artists is not None:
            dfr.addCallback(self._fill_in_data, result.artists.result,
                    model.artists, 'name')
        if result.albums is not None:
            dfr.addCallback(self._fill_in_data, result.albums.result,
                    model.albums, 'album')
        if result.tracks is not None:
            dfr.addCallback(self._fill_in_data, result.tracks.result,
                    model.tracks, 'title')
        return dfr

    def _fill_in_data(self, result, resulting_list, reference_list, attr):

        reference_list.extend(resulting_list)
        return result

        # DISABLED alphabetical sorting
        #def compare(self, other):
        #    # the way we want to compare the objects
        #    return natural_cmp(getattr(self, attr), getattr(other, attr))

        #return async_sorted_merge(reference_list,
        #        resulting_list, compare=compare)


def music_search_result_decorator(controller):
    searcher = 'YesfmSearcher'
    title = _('Yes.FM Search Results')
    icon_resource = 'elisa.plugins.yesfm.logo'
    searcher_entry = SearcherEntry(searcher, title, icon_resource)
    controller.searchers.append(searcher_entry)
    return defer.succeed(None)
