#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import ConfigParser

from time import sleep
from datetime import datetime
from PyQt4 import QtCore, QtGui
from PyQt4 import uic
from cStringIO import StringIO

from urlgrabber import urlread

releases = []

def get_md5_from_url(url):
    try:
      response = urlread(url)
    except URLGrabError, e:
      return ""
    response_s = response.split()
    if (len(response_s)>1 and len(response_s[0])==32):
      return response_s[0]
    return ""

def init_releases_by_conffile():
    config = ConfigParser.ConfigParser()
    config.read([os.path.join('/etc','liveusb-creator-ubuntu.cfg'),'liveusb-creator-ubuntu.cfg', os.path.join(os.path.expanduser('~'),'.config','liveusb-creator-ubuntu.cfg')])
    section_list = config.sections();
    for section in section_list:
      if (not config.has_option(section,"name")):
        continue
      if (not config.has_option(section,"url")):
        continue
      name = config.get(section,"name")
      url = config.get(section,"url")
      if (config.has_option(section,"md5")):
        md5 = config.get(section,"md5")
      elif (url.endswith(".img")):
        md5 = get_md5_from_url(url+".md5sum")
      else:
        md5 = ""
      record = { 'name':name, 'url':url, 'md5':md5, }
      releases.append(record)
