/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment media rendering library
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

/**
 * SECTION:pgmversion
 * @short_description: Pigment version macros.
 *
 * You can use the macros to keep the Pigment version information in
 * your application.
 *
 * Use the pgm_version() function if you want to know which version of
 * Pigment you are currently linked against.
 *
 * The version macros get defined by including "pgm/pgm.h".
 *
 * Last reviewed on 2007-04-12 (0.1.5)
 */

#ifndef __PGM_VERSION_H__
#define __PGM_VERSION_H__

#include <glib.h>

G_BEGIN_DECLS

/**
 * PGM_VERSION_MAJOR:
 *
 * The major version of Pigment at compile time.
 */
#define PGM_VERSION_MAJOR (0)
/**
 * PGM_VERSION_MINOR:
 *
 * The minor version of Pigment at compile time.
 */
#define PGM_VERSION_MINOR (3)
/**
 * PGM_VERSION_MICRO:
 *
 * The micro version of Pigment at compile time.
 */
#define PGM_VERSION_MICRO (7)
/**
 * PGM_VERSION_NANO:
 *
 * The nano version of Pigment at compile time. Actual releases have 0,
 * Subversion versions have 1, prerelease versions have [2-n].
 */
#define PGM_VERSION_NANO (0)

G_END_DECLS

#endif /* __PGM_VERSION_H__ */
