%{!?majorminor: %define         majorminor      0.3}
%{!?gstreamer:  %define         gstreamer       gstreamer}

Name:           pigment
Version:        0.3.9
Release:        1
Summary:        Pigment media rendering library

Group:          Applications/Multimedia
License:        LGPL
URL:            https://code.fluendo.com/pigment/trac
Source:         http://www.fluendo.com/elisa/downloads/pigment/%{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires:       glib2 >= 2.8.0
Requires:       pango >= 1.8
Requires:       pangocairo >= 1.8
Requires:       %{gstreamer} >= 0.10.0

BuildRequires:  glib2-devel >= 2.8.0
BuildRequires:  pango-devel >= 1.8
BuildRequires:  pangocairo-devel >= 1.8
BuildRequires:  libX11-devel
BuildRequires:  %{gstreamer}-devel >= 0.10.0
BuildRequires:  %{gstreamer}-plugins-base-devel >= 0.10.0
BuildRequires:  mesa-libGLU-devel
BuildRequires:  gtk-doc

# for gdk-pixbuf
BuildRequires:  gtk2-devel

%description
Pigment is a GLib/GObject library designed to easily create rich
application user interfaces embedding different media types. Its
design allows to use it on several platforms, thanks to a plugin
system allowing to choose the underlying graphical API.

%package devel
Summary:        Libraries/include files for Pigment
Group:          Development/Libraries

Requires:       %{name} = %{version}-%{release}
Requires:       glib2-devel >= 2.8.0

%description devel
Pigment is a GLib/GObject library designed to easily create rich
application user interfaces embedding different media types. Its
design allows to use it on several platforms, thanks to a plugin
system allowing to choose the underlying graphical API.

This package contains the libraries and includes files necessary to
develop applications and plugins using Pigment.

%prep
%setup -q -n %{name}-%{version}

%build
%configure --enable-gtk-doc
make

%install
rm -rf $RPM_BUILD_ROOT

# Install doc temporarily in order to be included later by rpm
%makeinstall docdir="`pwd`/installed-doc"

# Do not package .la files
find $RPM_BUILD_ROOT%{_libdir} -name "*.la" -exec rm {} \;

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root, -)
%doc AUTHORS COPYING INSTALL NEWS README RELEASE TODO ChangeLog
%{_libdir}/libpigment-%{majorminor}.so.*
%{_libdir}/pigment-%{majorminor}/%{version}/*.so

%files devel
%defattr(-, root, root, -)
%{_includedir}/pigment-%{majorminor}/pgm/*.h
%{_includedir}/pigment-%{majorminor}/pgm/gtk/*.h
%{_libdir}/libpigment-%{majorminor}.so
%{_libdir}/pkgconfig/pigment-%{majorminor}.pc
%{_libdir}/pkgconfig/pigment-gtk-%{majorminor}.pc
%{_datadir}/gtk-doc/html/pigment

%changelog
* Mon Jan 21 2008 Loïc Molinari <loic@fluendo.com>
- changed plugin path

* Fri Jan 11 2008 Loïc Molinari <loic@fluendo.com>
- updated doc files
- changed the description
- adapted for the python binding split
- added libpigment-gtk

* Tue Jan 8 2008 Loïc Molinari <loic@fluendo.com>
- removed the image sink plugin which is now linked statically

* Thu Aug 2 2007 Loïc Molinari <loic@fluendo.com>
- adapted to branch 0.3

* Tue Mar 13 2007 Loïc Molinari <loic@fluendo.com>
- adapted to library namespace change
- changed description

* Fri Feb 16 2007 Loïc Molinari <loic@fluendo.com>
- added libX11-devel and libXrandr-devel build requirements

* Thu Feb 01 2007 Loïc Molinari <loic@fluendo.com>
- removed the pygtk2-devel build requirement
- removed the libSDL requirement

* Thu Jan 04 2007 Thomas Vander Stichele <thomas at apestaart dot org>
- fix requires
- fix URL's
- add plugins-base BR
- pull in either pygobject2-devel or pygtk2-devel depending on version

* Thu Nov 09 2006 Loïc Molinari <loic@fluendo.com>
- changed the license

* Thu Nov 09 2006 Thomas Vander Stichele <thomas at apestaart dot org>
- cleaned up
- fixed for 64-bit systems
- get versions from configure.ac

* Wed Nov 08 2006 Loïc Molinari <loic@fluendo.com>
- added the GStreamer video sink plugin

* Thu Oct 31 2006 Christian Schaller <christian@fluendo.com>
- first draft of spec file
