/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Neil J. Patel <neil.patel@canonical.com>
 *
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <libwnck/libwnck.h>

#include <panel-applet.h>
#include <panel-applet-gconf.h>

#define ICON_SIZE 24

typedef struct 
{
  GtkWidget    *image;
  GtkWidget    *applet;
  
} GoHomeApp;

static void cw_panel_background_changed (PanelApplet               *applet,
                                         PanelAppletBackgroundType  type,
				                                 GdkColor                  *colour,
				                                 GdkPixmap                 *pixmap,
                                         gpointer                   user_data);
static void display_about_dialog (BonoboUIComponent *component, 
                                  gpointer           user_data, 
                                  const gchar       *verb);

static const char Context_menu_xml [] =
   "<popup name=\"button3\">\n"
  "   <menuitem name=\"About Item\" "
   "             verb=\"MenuAbout\" "
   "           _label=\"_About\"\n"
   "          pixtype=\"stock\" "
   "          pixname=\"gnome-stock-about\"/>\n"
   "</popup>\n";

static const BonoboUIVerb _menu_verbs [] = {
        BONOBO_UI_VERB ("MenuAbout", display_about_dialog),
        BONOBO_UI_VERB_END
}; 

static const gchar *close_window_authors [] = {
	"Neil J. Patel <neil.patel@canonical.com>",
	NULL
};

static gboolean
on_button_press (GtkWidget      *eb, 
                 GdkEventButton *event,
                 GoHomeApp *app)
{
  WnckScreen *screen;
  
  g_return_val_if_fail (app, FALSE);

  if (event->button != 1)
    return FALSE;

  screen = wnck_screen_get_default ();
   
  wnck_screen_toggle_showing_desktop (screen,
                                     !wnck_screen_get_showing_desktop (screen));

  return TRUE;
}

static gboolean
cw_applet_fill (PanelApplet *applet, 
                const gchar *iid, 
                gpointer     data)
{
  GtkIconTheme *theme = gtk_icon_theme_get_default ();
  WnckScreen *screen;
  GoHomeApp *app;
  GtkWidget *eb;
  GdkPixbuf *home;

  if (strcmp (iid, "OAFIID:GNOME_GoHome") != 0)
		return FALSE;
  	
  bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  home  = gtk_icon_theme_load_icon (theme, "gtk-home", ICON_SIZE, 0, NULL); 

  app = g_slice_new0 (GoHomeApp);
  screen = wnck_screen_get_default ();

  app->applet = GTK_WIDGET (applet);

  eb = gtk_event_box_new ();
  g_object_set (eb, "above-child", TRUE, "visible-window", FALSE, NULL);
	gtk_container_add (GTK_CONTAINER (applet), eb);

  app->image = gtk_image_new_from_pixbuf (home);
  gtk_container_add (GTK_CONTAINER (eb), app->image);
  g_object_unref (home);

	gtk_widget_show_all (GTK_WIDGET (applet));
	
		
  /* Signals */
	g_signal_connect (applet, "change-background",
			             G_CALLBACK (cw_panel_background_changed), NULL);
  g_signal_connect (eb, "button-release-event",
                    G_CALLBACK (on_button_press), app);
	
  panel_applet_setup_menu (PANEL_APPLET (applet),
                         	Context_menu_xml,
                         	_menu_verbs,
                         	NULL);
	
	return TRUE;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_GoHome_Factory",
                             PANEL_TYPE_APPLET,
                             "Show Desktop",
                             "0",
                             cw_applet_fill,
                             NULL);

static void 
cw_panel_background_changed (PanelApplet               *applet,
                             PanelAppletBackgroundType  type,
                             GdkColor                  *colour,
                             GdkPixmap                 *pixmap,
                             gpointer                   user_data)
{
  GtkRcStyle *rc_style;
  GtkStyle *style;

  /* reset style */
  gtk_widget_set_style (GTK_WIDGET (applet), NULL);
  rc_style = gtk_rc_style_new ();
  gtk_widget_modify_style (GTK_WIDGET (applet), rc_style);
  gtk_rc_style_unref (rc_style);

  switch (type) 
  {
    case PANEL_NO_BACKGROUND:
      break;
    case PANEL_COLOR_BACKGROUND:
      gtk_widget_modify_bg (GTK_WIDGET (applet), GTK_STATE_NORMAL, colour);
      break;
    
    case PANEL_PIXMAP_BACKGROUND:
      style = gtk_style_copy (GTK_WIDGET (applet)->style);
      if (style->bg_pixmap[GTK_STATE_NORMAL])
        g_object_unref (style->bg_pixmap[GTK_STATE_NORMAL]);
      style->bg_pixmap[GTK_STATE_NORMAL] = g_object_ref (pixmap);
      gtk_widget_set_style (GTK_WIDGET (applet), style);
      g_object_unref (style);
      break;
  }
}

static void
display_about_dialog (BonoboUIComponent *component, 
                      gpointer           user_data, 
                      const gchar       *verb)
{
  GtkWidget *panel_about_dialog;
	
  panel_about_dialog = gtk_about_dialog_new ();

  g_object_set (panel_about_dialog,
                "name", _("Go Home"),
                "comments", _("Go Home"),
                "version", "0.1",
                "authors", close_window_authors,
                "logo-icon-name", "gtk-home",
                "copyright", "Copyright \xc2\xa9 2008 Canonical Ltd",
                NULL);

  gtk_widget_show (panel_about_dialog);

  g_signal_connect (panel_about_dialog, "response",
                    G_CALLBACK (gtk_widget_destroy), NULL);
	

  gtk_window_present (GTK_WINDOW (panel_about_dialog));
}
