# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest
import sys
import gobject

from pkg_resources import resource_filename

from elisa.plugins.pigment.widgets.onscreen_keyboard import OnScreenKeyboard
from elisa.plugins.pigment.widgets.onscreen_keyboard import UnknownLayerError
from elisa.plugins.pigment.widgets.style import Style
from elisa.plugins.pigment.widgets.const import *
import pgm

class TestOnScreenKeyboard(unittest.TestCase):

    def setUp(self):
        layout = resource_filename('elisa.plugins.pigment.tests',
                                   'data/widgets/mockup_keyboard.xml')
        self.keyboard = OnScreenKeyboard(layout)

    def test_update_style_properties(self):
        style = Style()
        style.text_color = (1, 2, 3, 4)
        style.text_height = 2.0
        style.background_color = (1, 2, 3, 4)

        self.keyboard._update_style_properties(style.get_items())
        for key in self.keyboard._get_key_buttons():
            self.failUnlessEqual (key._label.fg_color, style.text_color)
            self.failUnlessEqual (key._label.height, style.text_height)
        self.failUnlessEqual (self.keyboard.opacity, style.background_color[-1])
        self.failUnlessEqual (self.keyboard._background.bg_color, style.background_color)

    def test_set_cursor(self):
        self.fail()

    def test_parse_layout(self):
        self.failUnless(self.keyboard._fixed_layer)
        self.failUnlessEqual(self.keyboard._fixed_layer.id, 'fixed')

        self.failUnlessEqual(len(self.keyboard._layers), 2)
        for layer_id in ['layer1', 'layer2']:
            layer = self.keyboard._layers[layer_id]
            self.failUnlessEqual(layer.id, layer_id)
            self.failUnlessEqual(len(layer.rows), 5)

    def test_render(self):
        self.fail()

    def test_render_layer(self):
        self.fail()

    def test_get_key_buttons(self):
        self.fail()

    def test_set_selected_key(self):
        for i, row in enumerate(self.keyboard._keys):
            for j, key in enumerate(row):
                self.keyboard._set_selected_key(key)
                self.failUnlessEqual(self.keyboard.selected_key, (i, j))

    def test_emit_text(self):
        """Testing signal emission. Is this safe? """

        def on_key_press(widget, value):
            print "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
            self.failUnlessEqual(value, "a")

        self.keyboard.connect("key-press", on_key_press)
        self.keyboard._emit_text(None, 0, 0, 0, None, None, None, "a")

    def test_move_cursor(self):
        first_key = self.keyboard._keys[0][0]
        self.keyboard._set_selected_key(first_key)

        self.keyboard.move_cursor(RIGHT)
        self.failUnlessEqual(self.keyboard.selected_key, (0, 1))

        self.keyboard.move_cursor(LEFT)
        self.failUnlessEqual(self.keyboard.selected_key, (0, 0))

        self.keyboard.move_cursor(TOP)
        self.failUnlessEqual(self.keyboard.selected_key, (4, 0))

        self.keyboard.move_cursor(BOTTOM)
        self.failUnlessEqual(self.keyboard.selected_key, (0, 0))

        self.keyboard.move_cursor(LEFT)
        self.failUnlessEqual(self.keyboard.selected_key, (0, 6))

        self.keyboard.move_cursor(RIGHT)
        self.failUnlessEqual(self.keyboard.selected_key, (0, 0))

    def test_do_key_press_event(self):
        self.fail()

    def test_layer(self):
        self.failUnlessEqual(self.keyboard.get_layer(), 'layer1')
        self.keyboard.set_layer('layer2')
        self.failUnlessEqual(self.keyboard.get_layer(), 'layer2')

    def test_swap_layers(self):
        self.keyboard._swap_layers(None, 0, 0, 0, None, None, None,
                                   ['layer1', 'layer2'])
        self.failUnlessEqual(self.keyboard.get_layer(), 'layer2')
        self.keyboard._swap_layers(None, 0, 0, 0, None, None, None,
                                   ['layer1', 'layer2'])
        self.failUnlessEqual(self.keyboard.get_layer(), 'layer1')

        self.failUnlessRaises(UnknownLayerError,
                              self.keyboard._swap_layers,
                              None, 0, 0, 0, None, None, None, ['layerX'])


