# -*- coding: utf-8 -*-
# (c) 2008 Canonical Ltd.
# Author: Martin Pitt <martin.pitt@ubuntu.com>
# License: GPL v2 or later

from jockey.xorg_driver import XorgDriverHandler

class FglrxDriver(XorgDriverHandler):
    def __init__(self, ui):
        XorgDriverHandler.__init__(self, ui, 'fglrx', 'xorg-driver-fglrx',
            'fglrx', 'ati', add_modules=['glx'],
            name=ui._('ATI accelerated graphics driver'),
            description=ui._('3D-accelerated proprietary graphics driver for '
                'ATI cards.'),
            rationale=ui._('This driver is required to fully utilise '
                'the 3D potential of ATI graphics cards, as well as provide '
                '2D acceleration of newer cards.'))

    def enable_config_hook(self):
        # X.org does not work otherwise
        if len(self.xorg_conf.getSections('Screen')) == 0:
            self.xorg_conf.append(self.xorg_conf.makeSection(None, 
                ['Section', 'Screen']))
	self.xorg_conf.getSections('Screen')[0].defaultdepth = 24

    def supports_composite(self):
        '''Return whether this driver supports the composite extension.'''

        return True

