!define PROGRAM_NAME "Liveusb creator Ubuntu"
!define PROGRAM_VERSION "0.3.2"
!define INSTALLER_PYTHON "python-2.5.2.msi"
!define INSTALLER_PYTHONQT "PyQt-Py2.5-gpl-4.4.3-1.exe"
!define INSTALLER_PYTHONWIN32 "pywin32-212.win32-py2.5.exe"

# define name of installer
SetCompressor lzma
Name "${PROGRAM_NAME} ${PROGRAM_VERSION}"
OutFile "liveusb-creator-ubuntu-installer-${PROGRAM_VERSION}.exe"
InstallDir "$PROGRAMFILES\${PROGRAM_NAME}"
#ShowInstDetails show

Section -SETTINGS
        # set the installation directory as the destination for the following actions
	SetOutPath "$INSTDIR"
	SetOverwrite ifnewer
SectionEnd

Section -Prerequisites
	MessageBox MB_YESNO "Install Python Interpreter?" /SD IDYES IDNO endInstallPython
	  File "win32\${INSTALLER_PYTHON}"
	  #ExecWait '"msiexec" /passive /i "$INSTDIR\${INSTALLER_PYTHON}"'
	  ExecWait '"msiexec" /i "$INSTDIR\${INSTALLER_PYTHON}"'
	  Goto endInstallPython
	endInstallPython:
	MessageBox MB_YESNO "Install Python QT?" /SD IDYES IDNO endInstallPythonQT
	  File "win32\${INSTALLER_PYTHONQT}"
	  ExecWait '"$INSTDIR\${INSTALLER_PYTHONQT}"'
	  Goto endInstallPythonQT
	endInstallPythonQT:
	MessageBox MB_YESNO "Install Python Win32?" /SD IDYES IDNO endInstallPythonWin32
	  File "win32\${INSTALLER_PYTHONWIN32}"
	  ExecWait '"$INSTDIR\${INSTALLER_PYTHONWIN32}"'
	  Goto endInstallPythonWin32
	endInstallPythonWin32:
SectionEnd
 
# start default section
Section
    # create the uninstaller
    writeUninstaller "$INSTDIR\uninstall.exe"

    File /r "data"
    File /r "liveusb"
    File /r "tests"
    File /r "tools"
    File "liveusb-creator"
    File "setup.py"
    File "AUTHORS"
    File "ChangeLog"
    File "LICENSE.txt"
    File "Readme.txt"
    File "win32installer.nsi"
    File "win32.vcheck"
    File "liveusb-creator-ubuntu.cfg"

    CreateShortCut "$INSTDIR\liveusb-creator-ubuntu.lnk" '"C:\Python25\python.exe"' '"$INSTDIR\liveusb-creator"' "$INSTDIR\data\UbuntuLogo.ico" ""
 
    CreateDirectory "$SMPROGRAMS\${PROGRAM_NAME}"
    CopyFiles "$INSTDIR\liveusb-creator-ubuntu.lnk" "$SMPROGRAMS\${PROGRAM_NAME}"
    CreateShortCut "$SMPROGRAMS\${PROGRAM_NAME}\uninstall.lnk" '"$INSTDIR\uninstall.exe"'
SectionEnd
 
# uninstaller section start
Section "uninstall"
 
    # first, delete the uninstaller
    delete "$INSTDIR\uninstall.exe"
 
    # second, remove the link from the start menu
    delete "$SMPROGRAMS\${PROGRAM_NAME}\uninstall.lnk"
    delete "$SMPROGRAMS\${PROGRAM_NAME}\liveusb-creator-ubuntu.lnk"
    Rmdir /r "$SMPROGRAMS\${PROGRAM_NAME}"

    Rmdir /r "$INSTDIR"
 
# uninstaller section end
SectionEnd
