#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import ConfigParser

from time import sleep
from datetime import datetime
from PyQt4 import QtCore, QtGui
from PyQt4 import uic
from cStringIO import StringIO

from urlgrabber import urlread
from urlgrabber.grabber import URLGrabber, URLGrabError

releases = []

def get_md5_from_url(url):
    try:
      response = urlread(url)
    except URLGrabError, e:
      return ""
    response_s = response.split()
    if (len(response_s)>1 and len(response_s[0])==32):
      return response_s[0]
    return ""

def match_wildcards(name,path):
    ret=0
    if (not os.path.exists(path)):
      return 0
    files = os.listdir(path)
    for filename in files:
      flag1=True
      for i in range(len(name)):
        if (name[i]=="*"):
          break
        if (i >= len(filename)):
          flag1=False
          break
        if (name[i] != filename[i]):
          flag1=False
          break
      if (not flag1):
        continue
      for i in range(len(name)):
        j = len(name)-i-1
        k = len(filename)-i-1
        if (name[j]=="*"):
          break
        if (k < 0):
          flag1=False
          break
        if (name[j]!=filename[k]):
          flag1=False
          break
      if (flag1):
        ret = filename
    return ret

def search_file_in_dirs_by_name(name,dirs):
    for dir in dirs:
      if (name.find("*")!=-1):
        nname = match_wildcards(name,dir)
        if (nname != 0):
          name = nname
        else:
          continue
      cfname=os.path.join(dir,name)
      if (cfname != "" and os.path.exists(cfname)):
        part=""
        if (dir==""):
          part=name
        else:
          part=dir+"/"+name
        if part.startswith("/"):
          ret="file://"+part
        else:
          ret="file:///"+part
        return ret
    return 0

def init_releases_by_conffile():
    config = ConfigParser.ConfigParser()
    config.read([os.path.join('/etc','liveusb-creator-ubuntu.cfg'),'liveusb-creator-ubuntu.cfg', os.path.join(os.path.expanduser('~'),'.config','liveusb-creator-ubuntu.cfg')])
    section_list = config.sections();
    for section in section_list:
      if (not config.has_option(section,"name")):
        continue
      if (not config.has_option(section,"url")):
        continue
      name = config.get(section,"name")
      url = config.get(section,"url")
      if (url.startswith("file_search_cd://")):
        url = search_file_in_dirs_by_name(url[17:],["","/","/media/cdrom", \
            "/media/CDROM", \
            "/media/cdrom0", "/media/cdrom1", "/media/cdrom2", \
            "/media/cdrom3", "/media/cdrom4", \
            "/mnt", \
            "C:", "D:", "E:", "F:", "G:", "H:", "I:", "J:", "Z:"]);
      if (not url):
        continue
      if (config.has_option(section,"md5")):
        md5 = config.get(section,"md5")
      elif (url.endswith(".img")):
        md5 = get_md5_from_url(url+".md5sum")
      else:
        md5 = ""
      record = { 'name':name, 'url':url, 'md5':md5, }
      releases.append(record)
