# -*- coding: utf-8 -*-
#
# (c) Copyright 2003-2008 Hewlett-Packard Development Company, L.P.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# Author: Don Welch
#

# Local
from g import *
from codes import *
import status, pml
from prnt import pcl, ldl, colorcal


# ********************** Clean **********************


def cleaning(dev, clean_type, level1, level2, level3,
              loadpaper_ui, dlg1, dlg2, dlg3, wait_ui):

    state = 0

    while state != -1:
        if state == 0: # Initial level1 print
            state = 1
            if clean_type == CLEAN_TYPE_PCL_WITH_PRINTOUT:
                ok = loadpaper_ui()
                if not ok:
                    state = -1

        elif state == 1: # Do level 1
            level1(dev)
            state = 2

        elif state == 2: # Load plain paper
            state = -1
            ok = loadpaper_ui()
            if ok:
                state = 3

        elif state == 3: # Print test page
            state = 4
            print_clean_test_page(dev)

        elif state == 4: # Need level 2?
            state = -1
            ok = dlg1()
            if ok:
                state = 5

        elif state == 5: # Do level 2
            level2(dev)
            state = 6

        elif state == 6: # Load plain paper
            state = -1
            ok = loadpaper_ui()
            if ok:
                state = 7

        elif state == 7: # Print test page
            state = 8
            print_clean_test_page(dev)

        elif state == 8: # Need level 3?
            state = -1
            ok = dlg2()
            if ok:
                state = 9

        elif state == 9: # Do level 3
            level3(dev)
            state = 10

        elif state == 10: # Load plain paper
            state = -1
            ok = loadpaper_ui()
            if ok:
                state = 11

        elif state == 11: # Print test page
            state = 12
            print_clean_test_page(dev)

        elif state == 12:
            state = -1
            dlg3()

    return ok


def print_clean_test_page(dev):
    dev.closePrint()
    dev.printGzipFile(os.path.join(prop.home_dir, 'data',
                      'ps', 'clean_page.pdf.gz'), raw=False)

def cleanType1(dev): # PCL, Level 1
    dev.writeEmbeddedPML(pml.OID_CLEAN, pml.CLEAN_CLEAN)
    dev.closePrint()

def primeType1(dev): # PCL, Level 2
    dev.writeEmbeddedPML(pml.OID_CLEAN, pml.CLEAN_PRIME)
    dev.closePrint()

def wipeAndSpitType1(dev): # PCL, Level 3
    dev.writeEmbeddedPML(pml.OID_CLEAN, pml.CLEAN_WIPE_AND_SPIT)
    dev.closePrint()

def cleanType2(dev): # LIDIL, Level 1
    dev.printData(ldl.buildResetPacket())
    dev.printData(ldl.buildLIDILPacket(ldl.PACKET_TYPE_COMMAND,
                                       ldl.COMMAND_HANDLE_PEN,
                                       ldl.COMMAND_HANDLE_PEN_CLEAN_LEVEL1))
    dev.closePrint()

def primeType2(dev): # LIDIL, Level 2
    dev.printData(ldl.buildResetPacket())
    dev.printData(ldl.buildLIDILPacket(ldl.PACKET_TYPE_COMMAND,
                                       ldl.COMMAND_HANDLE_PEN,
                                       ldl.COMMAND_HANDLE_PEN_CLEAN_LEVEL2))
    dev.closePrint()

def wipeAndSpitType2(dev): # LIDIL, Level 3
    dev.printData(ldl.buildResetPacket())
    dev.printData(ldl.buildLIDILPacket(ldl.PACKET_TYPE_COMMAND,
                                       ldl.COMMAND_HANDLE_PEN,
                                       ldl.COMMAND_HANDLE_PEN_CLEAN_LEVEL3))
    dev.closePrint()
    
    
