# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.poblesec.vertical_list import VerticalListController
from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.graph.image import Image

import pgm
from pgm.utils.image import cairo_gradient
from pgm.timing import implicit

class PreviewWidget(Widget):
    def __init__(self):
        super(PreviewWidget, self).__init__()

        self.image = Image()
        self.add(self.image)
        self.image.bg_a = 0
        self.image.layout = pgm.IMAGE_SCALED
        self.image.alignment = pgm.IMAGE_BOTTOM
        self.image.x, self.image.y = (0.0, 0.0)
        self.image.width, self.image.height = (1.0, 0.5)
        self.image.visible = True

        # reflection
        self.reflection = Image()
        self.add(self.reflection)
        flip_matrix = pgm.mat4x4_new_predefined(pgm.MAT4X4_FLIP_VERTICAL)
        self.reflection.mapping_matrix = flip_matrix
        self.reflection.bg_a = 0
        self.reflection.layout = pgm.IMAGE_SCALED
        self.reflection.alignment = pgm.IMAGE_TOP
        self.reflection.x, self.reflection.y = (0.0, 0.5)
        self.reflection.width, self.reflection.height = (1.0, 0.5)
        self.reflection.opacity = 80
        self.reflection.visible = True

class PreviewListController(VerticalListController):

    def set_frontend(self, frontend):
        super(PreviewListController, self).set_frontend(frontend)

        self.preview = PreviewWidget()
        self.widget.add(self.preview)
        list_width = self.nodes.x+self.nodes.width
        self.preview.width, self.preview.height = ((1.0-list_width)*0.7, 0.8)
        x = list_width+((1.0-list_width)-self.preview.width)/2.0
        y = (1.0-self.preview.height)/2.0 + self.preview.height/7.0
        self.preview.x, self.preview.y = (x, y)
        self.preview.visible = True

        self.animated_preview = implicit.AnimatedObject(self.preview)

        # FIXME: this should probably be done (and refactored) just after self.nodes
        #        is created in VerticalListController
        self.nodes.connect('selected-item-changed', self._initiate_load_preview)

        if self.nodes.selected_item_index != -1:
            self._initiate_load_preview(self.nodes, None, None)

    def image_from_item(self, item):
        return None

    def _initiate_load_preview(self, widget, item, previous_item):
        # do not do anything if it was already fading out
        if self.animated_preview.opacity == 0.0:
            return

        self.animated_preview.stop_animations()

        def load_new_preview(timer):
            # unload any previously loaded preview
            self.preview.image.clear()
            self.preview.reflection.clear()

            self.animated_preview.setup_next_animations(duration=200,
                                            transformation=implicit.DECELERATE,
                                            end_callback=None)
            self.animated_preview.opacity = 255
            selected_item = self.model[self.nodes.selected_item_index]
            self._load_preview(selected_item)

        self.animated_preview.setup_next_animations(duration=200,
                                            transformation=implicit.DECELERATE,
                                            end_callback=load_new_preview)
        self.animated_preview.opacity = 0.0

    def _load_preview(self, item):
        image_path = self.image_from_item(item)

        if image_path != None:
            self.preview.image.set_from_file(image_path)
            # FIXME: deactivated because of Python Cairo bindings not releasing
            # the GIL thus locking Pigment's rendering thread when the viewport
            # update-pass signal is emitted
            #try:
            #    cairo_gradient(image_path, self.preview.reflection, 0.4)
            #except:
            #    # FIXME: add support for JPG to the cairo gradient
            #    pass
