# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.media_uri import MediaUri
from elisa.plugins.poblesec.link import Link
from twisted.internet import defer
from elisa.core.common import application

from elisa.core.utils.i18n import install_translation

_ = install_translation('poblesec')

def pictures_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/pictures_menu"
    link.label = _("Pictures")
    link.icon = "elisa.plugins.poblesec.pictures_section"
    controller.model.append(link)

    return defer.succeed(None)

def filesystem_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/pictures/directory_list"
    link.label = _("Folders")
    link.icon = "elisa.plugins.poblesec.pictures_folders"
    link.controller_args = {'media_type': 'pictures'}
    controller.model.append(link)

    return defer.succeed(None)

def internet_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/pictures/internet"
    link.label = _("Internet")
    link.icon = "elisa.plugins.poblesec.internet"
    controller.model.append(link)

    return defer.succeed(None)

def network_decorator(controller):
    link = Link()
    link.controller_path = "/poblesec/pictures/network"
    link.label = _("Home network")
    link.icon = "elisa.plugins.poblesec.network"
    link.controller_args = {'media_type': 'pictures'}
    controller.model.append(link)

    return defer.succeed(None)

def hardware_decorator(controller):
    uri = MediaUri("volumes://?filter=removable")
    model, dfr = application.resource_manager.get(uri, None)

    def do_list_hardware(model):
        devices = sorted(model.volumes, key=lambda i: i.label.lower())

        for dev in devices:
            # TODO: nothing else yet supported
            if dev.protocol != 'file':
                continue
            if not dev.mount_point:
                continue
            link = Link()
            link.controller_path = "/poblesec/pictures/filesystem"
            link.controller_args = {'uri': dev.mount_point, 'media_type': 'image'}
            link.label = dev.label
            link.icon = "elisa.plugins.poblesec.removable_device"
            controller.model.append(link)

        return model

    def do_list_hardware_error(err, *args):
        return err

    dfr.addCallback(do_list_hardware)
    dfr.addErrback(do_list_hardware_error)

    return dfr
